---
layout: post
title: ESLint v2.12.0 released
teaser: "We just pushed ESLint v2.12.0, which is a minor release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - nzakas
categories:
  - Release Notes
---

## Highlights

This is a summary of the major changes you need to know about for this version of ESLint.

### JSCS Compatibility

We are continuing to work on compatibility with JSCS, and in this release we added two new rules that correspond to JSCS rules:

* [`max-lines`](https://eslint.org/docs/rules/max-lines) - equivalent of [maximumNumberOfLines](http://jscs.info/rule/maximumNumberOfLines)
* [`object-curly-newline`](https://eslint.org/docs/rules/object-curly-newline) - equivalent of [requirePaddingNewLinesInObjects](http://jscs.info/rule/requirePaddingNewLinesInObjects) and [disallowPaddingNewLinesInObjects](http://jscs.info/rule/disallowPaddingNewLinesInObjects)

### Introducing `eslint:all`

We've had numerous requests to provide a configuration that turns on all rules ESLint provides. You can now set `extends` in your configuration file equal to `"eslint:all"` to get every core rule enabled with their default settings.

**Important**: This configuration is **not recommended for production use** because it changes with every minor and major version of ESLint. Use at your own risk.

You can read more in the [documentation](https://eslint.org/docs/user-guide/configuring#using-eslintall).

### Performance Improvement

You might have seen [this case study](https://www.youtube.com/watch?v=iMqi55rcR00&feature=youtu.be&t=1770) of debugging a performance issue in ESLint at Google I/O. A [pull request](https://github.com/eslint/eslint/pull/6215) was filed during the talk that showed some significant performance improvement. There were some details of the pull request that weren't quite correct and caused some regressions, however, we were able to adopt the basic approach to realize some of the performance improvements.

In [#6276](https://github.com/eslint/eslint/pull/6276), we enabled this improvement for anyone who is either not using `.eslintignore` or is using `.eslintignore` without specifying a re-inclusion pattern (beginning with `!`). This showed a significant performance improvement when run on the ESLint repo itself and we expect developers with large projects (especially those with a `node_modules` directory) to see savings of whole seconds when linting everything (such as using `eslint .`). If you already manually pass in filenames on the command line, you won't see any improvement because the gains are on directory traversal.

### Formalized Semantic Versioning Policy

One of the things that JSCS did well was formally defining their semantic versioning policy. In the world of linters, it's not always clear whether something should be a patch or a minor version bump. For instance, what if a rule has a bug where it's not finding problems that it should? While we could classify that as a bug, fixing the bug could cause ESLint users' lint builds to break, which is unexpected in a patch version.

The JSCS team had a really well-reasoned semantic versioning policy to give their users a clear picture of when to expect lint build breakage. We decided to adopt a policy based on the JSCS one and have posted it on our [README](https://github.com/eslint/eslint#semantic-versioning-policy). The end result is that we are taking breaking your lint builds very seriously and want to be clear when such breakages can occur and why.

### All New Rules

The complete list of new rules in this release:

* [`max-lines`](https://eslint.org/docs/rules/max-lines)
* [`no-mixed-operators`](https://eslint.org/docs/rules/no-mixed-operators)
* [`object-curly-newline`](https://eslint.org/docs/rules/object-curly-newline)
* [`rest-spread-spacing`](https://eslint.org/docs/rules/rest-spread-spacing)







## Features


* [2520f5a](https://github.com/eslint/eslint/commit/2520f5a) New: `max-lines` rule (fixes [#6078](https://github.com/eslint/eslint/issues/6078)) ([#6321](https://github.com/eslint/eslint/issues/6321)) (alberto)
* [0e14016](https://github.com/eslint/eslint/commit/0e14016) New: `no-mixed-operators` rule (fixes [#6023](https://github.com/eslint/eslint/issues/6023)) ([#6241](https://github.com/eslint/eslint/issues/6241)) (Toru Nagashima)
* [f804397](https://github.com/eslint/eslint/commit/f804397) New: Add `eslint:all` option (fixes [#6240](https://github.com/eslint/eslint/issues/6240)) ([#6248](https://github.com/eslint/eslint/issues/6248)) (Robert Fletcher)
* [2663569](https://github.com/eslint/eslint/commit/2663569) New: `object-curly-newline` (fixes [#6072](https://github.com/eslint/eslint/issues/6072)) ([#6223](https://github.com/eslint/eslint/issues/6223)) (Toru Nagashima)
* [1313804](https://github.com/eslint/eslint/commit/1313804) New: rest-spread-spacing rule (fixes [#5391](https://github.com/eslint/eslint/issues/5391)) ([#6278](https://github.com/eslint/eslint/issues/6278)) (Kai Cataldo)




## Enhancements


* [54c30fb](https://github.com/eslint/eslint/commit/54c30fb) Update: Add explicit default option `always` for `eqeqeq` (refs [#6144](https://github.com/eslint/eslint/issues/6144)) ([#6342](https://github.com/eslint/eslint/issues/6342)) (alberto)
* [2d63370](https://github.com/eslint/eslint/commit/2d63370) Update: max-len will warn indented comment lines (fixes [#6322](https://github.com/eslint/eslint/issues/6322)) ([#6324](https://github.com/eslint/eslint/issues/6324)) (Kai Cataldo)
* [9bfbc64](https://github.com/eslint/eslint/commit/9bfbc64) Update: Option for object literals in `arrow-body-style` (fixes [#5936](https://github.com/eslint/eslint/issues/5936)) ([#6216](https://github.com/eslint/eslint/issues/6216)) (alberto)
* [6e03c4b](https://github.com/eslint/eslint/commit/6e03c4b) Update: Add never option to arrow-body-style (fixes [#6317](https://github.com/eslint/eslint/issues/6317)) ([#6318](https://github.com/eslint/eslint/issues/6318)) (Andrew Hyndman)
* [72c2ea5](https://github.com/eslint/eslint/commit/72c2ea5) Update: callback-return allows for object methods (fixes [#4711](https://github.com/eslint/eslint/issues/4711)) ([#6277](https://github.com/eslint/eslint/issues/6277)) (Kai Cataldo)
* [fca0679](https://github.com/eslint/eslint/commit/fca0679) Update: Improve perf not traversing default ignored dirs (fixes [#5679](https://github.com/eslint/eslint/issues/5679)) ([#6276](https://github.com/eslint/eslint/issues/6276)) (alberto)




## Bug Fixes


* [316a507](https://github.com/eslint/eslint/commit/316a507) Fix: one-var allows uninitialized vars in ForIn/ForOf (fixes [#5744](https://github.com/eslint/eslint/issues/5744)) ([#6272](https://github.com/eslint/eslint/issues/6272)) (Kai Cataldo)
* [61dfe68](https://github.com/eslint/eslint/commit/61dfe68) Fix: `no-useless-rename` false positive in babel-eslint (fixes [#6266](https://github.com/eslint/eslint/issues/6266)) ([#6290](https://github.com/eslint/eslint/issues/6290)) (alberto)
* [bb69380](https://github.com/eslint/eslint/commit/bb69380) Fix: no-useless-rename handles ExperimentalRestProperty (fixes [#6284](https://github.com/eslint/eslint/issues/6284)) ([#6288](https://github.com/eslint/eslint/issues/6288)) (Kevin Partington)




## Documentation


* [dcd4ad7](https://github.com/eslint/eslint/commit/dcd4ad7) Docs: clarify usage of inline disable comments (fixes [#6335](https://github.com/eslint/eslint/issues/6335)) ([#6347](https://github.com/eslint/eslint/issues/6347)) (Kai Cataldo)
* [c03300b](https://github.com/eslint/eslint/commit/c03300b) Docs: Clarified how plugin rules look in plugin configs (fixes [#6346](https://github.com/eslint/eslint/issues/6346)) ([#6351](https://github.com/eslint/eslint/issues/6351)) (Kevin Partington)
* [9c87709](https://github.com/eslint/eslint/commit/9c87709) Docs: Add semantic versioning policy (fixes [#6244](https://github.com/eslint/eslint/issues/6244)) ([#6343](https://github.com/eslint/eslint/issues/6343)) (Nicholas C. Zakas)
* [5affab1](https://github.com/eslint/eslint/commit/5affab1) Docs: Describe values under Extending Configuration Files (refs [#6240](https://github.com/eslint/eslint/issues/6240)) ([#6336](https://github.com/eslint/eslint/issues/6336)) (Mark Pedrotti)
* [477fbc1](https://github.com/eslint/eslint/commit/477fbc1) Docs: Add section about customizing RuleTester (fixes [#6227](https://github.com/eslint/eslint/issues/6227)) ([#6331](https://github.com/eslint/eslint/issues/6331)) (Jeroen Engels)
* [dfe05bf](https://github.com/eslint/eslint/commit/dfe05bf) Docs: Link JSCS rules to their corresponding page. ([#6334](https://github.com/eslint/eslint/issues/6334)) (alberto)
* [1cc4356](https://github.com/eslint/eslint/commit/1cc4356) Docs: Remove reference to numeric config (fixes [#6309](https://github.com/eslint/eslint/issues/6309)) ([#6327](https://github.com/eslint/eslint/issues/6327)) (Kevin Partington)
* [2d4efbe](https://github.com/eslint/eslint/commit/2d4efbe) Docs: Describe options in rule under Strict Mode ([#6312](https://github.com/eslint/eslint/issues/6312)) (Mark Pedrotti)
* [c1953fa](https://github.com/eslint/eslint/commit/c1953fa) Docs: Typo fix 'and' -> 'any' ([#6326](https://github.com/eslint/eslint/issues/6326)) (Stephen Edgar)
* [d49ab4b](https://github.com/eslint/eslint/commit/d49ab4b) Docs: Code conventions improvements ([#6313](https://github.com/eslint/eslint/issues/6313)) (Kevin Partington)
* [6cbee31](https://github.com/eslint/eslint/commit/6cbee31) Docs: Typo fix 'colum' -> 'column' ([#6306](https://github.com/eslint/eslint/issues/6306)) (Andrew Cobby)
* [89580a4](https://github.com/eslint/eslint/commit/89580a4) Docs: Distinguish examples in rules under Stylistic Issues part 5 ([#6291](https://github.com/eslint/eslint/issues/6291)) (Kenneth Williams)
* [38dccdd](https://github.com/eslint/eslint/commit/38dccdd) Docs: `--no-ignore` disables all forms of ignore (fixes [#6260](https://github.com/eslint/eslint/issues/6260)) ([#6304](https://github.com/eslint/eslint/issues/6304)) (alberto)
* [320e8b0](https://github.com/eslint/eslint/commit/320e8b0) Docs: Describe options in rules under Possible Errors part 4 ([#6270](https://github.com/eslint/eslint/issues/6270)) (Mark Pedrotti)
* [3e052c1](https://github.com/eslint/eslint/commit/3e052c1) Docs: Mark no-useless-rename as fixable in rules index ([#6297](https://github.com/eslint/eslint/issues/6297)) (Dalton Santos)






## Build Related


* [c78c8cb](https://github.com/eslint/eslint/commit/c78c8cb) Build: Remove commit check from appveyor (fixes [#6292](https://github.com/eslint/eslint/issues/6292)) ([#6294](https://github.com/eslint/eslint/issues/6294)) (alberto)




## Chores


* [977cdd5](https://github.com/eslint/eslint/commit/977cdd5) Chore: remove unused method from FileFinder (fixes [#6344](https://github.com/eslint/eslint/issues/6344)) ([#6345](https://github.com/eslint/eslint/issues/6345)) (alberto)
* [3e38fc1](https://github.com/eslint/eslint/commit/3e38fc1) Chore: more tests for comments at the end of blocks (refs [#6090](https://github.com/eslint/eslint/issues/6090)) ([#6273](https://github.com/eslint/eslint/issues/6273)) (Kai Cataldo)
