---
layout: post
title: ESLint v2.11.0 released
teaser: "We just pushed ESLint v2.11.0, which is a minor release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - nzakas
categories:
  - Release Notes
---

## Highlights

This is a summary of the major changes you need to know about for this version of ESLint.

### JSCS Compatibility

We've started our JSCS compatibility work by continuing to add new rules and rule options to fill in the gaps between what ESLint can do and what JSCS can do. This release includes the new [`no-useless-rename`](https://eslint.org/docs/rules/no-useless-rename) rule, which corresponds to the JSCS [`disallowIdenticalDestructuringNames`](http://jscs.info/rule/disallowIdenticalDestructuringNames).

You can follow our progress on JSCS compatibility by looking at the [milestone](https://github.com/eslint/eslint/milestones/JSCS%20Compatibility).

### New Rules

The new rules included in this release are:

* [`no-useless-rename`](https://eslint.org/docs/rules/no-useless-rename)
* [`unicode-bom`](https://eslint.org/docs/rules/unicode-bom)
* [`no-prototype-builtins`](https://eslint.org/docs/rules/no-prototype-builtins)


## Features


* [fea8fe6](https://github.com/eslint/eslint/commit/fea8fe6) New: no-useless-rename (fixes [#6058](https://github.com/eslint/eslint/issues/6058)) ([#6249](https://github.com/eslint/eslint/issues/6249)) (Kai Cataldo)
* [088bda9](https://github.com/eslint/eslint/commit/088bda9) New: `unicode-bom` rule to allow or disallow BOM (fixes [#5502](https://github.com/eslint/eslint/issues/5502)) ([#6230](https://github.com/eslint/eslint/issues/6230)) (Andrew Johnston)
* [04bd586](https://github.com/eslint/eslint/commit/04bd586) New: Disallow use of Object.prototype methods on objects (fixes [#2693](https://github.com/eslint/eslint/issues/2693)) ([#6107](https://github.com/eslint/eslint/issues/6107)) (Andrew Levine)




## Enhancements


* [74c458d](https://github.com/eslint/eslint/commit/74c458d) Update: key-spacing rule whitespace fixer (fixes [#6167](https://github.com/eslint/eslint/issues/6167)) ([#6169](https://github.com/eslint/eslint/issues/6169)) (Ruurd Moelker)
* [53754ec](https://github.com/eslint/eslint/commit/53754ec) Update: max in `max-statements-per-line` should be >=0 (fixes [#6171](https://github.com/eslint/eslint/issues/6171)) ([#6172](https://github.com/eslint/eslint/issues/6172)) (alberto)
* [54d1201](https://github.com/eslint/eslint/commit/54d1201) Update: Add treatUndefinedAsUnspecified option (fixes [#6026](https://github.com/eslint/eslint/issues/6026)) ([#6194](https://github.com/eslint/eslint/issues/6194)) (Kenneth Williams)
* [18152dd](https://github.com/eslint/eslint/commit/18152dd) Update: Add checkLoops option to no-constant-condition (fixes [#5477](https://github.com/eslint/eslint/issues/5477)) ([#6202](https://github.com/eslint/eslint/issues/6202)) (Kai Cataldo)




## Bug Fixes


* [77dd2b4](https://github.com/eslint/eslint/commit/77dd2b4) Fix: On --init, print message when package.json is invalid (fixes [#6257](https://github.com/eslint/eslint/issues/6257)) ([#6261](https://github.com/eslint/eslint/issues/6261)) (Kai Cataldo)
* [7f60186](https://github.com/eslint/eslint/commit/7f60186) Fix: `--ignore-pattern` can't uningnore files (fixes [#6127](https://github.com/eslint/eslint/issues/6127)) ([#6253](https://github.com/eslint/eslint/issues/6253)) (alberto)
* [b4cff9d](https://github.com/eslint/eslint/commit/b4cff9d) Fix: Incorrect object-property-newline behavior (fixes [#6207](https://github.com/eslint/eslint/issues/6207)) ([#6213](https://github.com/eslint/eslint/issues/6213)) (Rafał Ruciński)
* [ee0cd58](https://github.com/eslint/eslint/commit/ee0cd58) Fix: `newline-before-return` shouldn't disallow newlines (fixes [#6176](https://github.com/eslint/eslint/issues/6176)) ([#6217](https://github.com/eslint/eslint/issues/6217)) (alberto)
* [d4f5526](https://github.com/eslint/eslint/commit/d4f5526) Fix: `vars-on-top` crashs at export declarations (fixes [#6210](https://github.com/eslint/eslint/issues/6210)) ([#6220](https://github.com/eslint/eslint/issues/6220)) (Toru Nagashima)
* [14bfc03](https://github.com/eslint/eslint/commit/14bfc03) Fix: `comma-dangle` wrong autofix (fixes [#6233](https://github.com/eslint/eslint/issues/6233)) ([#6235](https://github.com/eslint/eslint/issues/6235)) (Toru Nagashima)
* [c10c07f](https://github.com/eslint/eslint/commit/c10c07f) Fix: lost code in autofixing (refs [#6233](https://github.com/eslint/eslint/issues/6233)) ([#6234](https://github.com/eslint/eslint/issues/6234)) (Toru Nagashima)
* [7644908](https://github.com/eslint/eslint/commit/7644908) Fix: no-multiple-empty-lines BOF and EOF defaults (fixes [#6179](https://github.com/eslint/eslint/issues/6179)) ([#6180](https://github.com/eslint/eslint/issues/6180)) (Ruurd Moelker)
* [72335eb](https://github.com/eslint/eslint/commit/72335eb) Fix: `max-statements-per-line` false positive (fixes [#6173](https://github.com/eslint/eslint/issues/6173), fixes [#6153](https://github.com/eslint/eslint/issues/6153)) ([#6192](https://github.com/eslint/eslint/issues/6192)) (Toru Nagashima)
* [9fce04e](https://github.com/eslint/eslint/commit/9fce04e) Fix: `generator-star-spacing` false positive (fixes [#6135](https://github.com/eslint/eslint/issues/6135)) ([#6168](https://github.com/eslint/eslint/issues/6168)) (Toru Nagashima)




## Documentation


* [35b4656](https://github.com/eslint/eslint/commit/35b4656) Docs: Edit arrow-parens.md to show correct output value ([#6245](https://github.com/eslint/eslint/issues/6245)) (Adam Terlson)
* [cdd65d7](https://github.com/eslint/eslint/commit/cdd65d7) Docs: added examples for arrow-body-style (refs [#5498](https://github.com/eslint/eslint/issues/5498)) ([#6242](https://github.com/eslint/eslint/issues/6242)) (Tieme van Veen)
* [e6d5b1f](https://github.com/eslint/eslint/commit/e6d5b1f) Docs: Add rule deprecation section to user guide (fixes [#5845](https://github.com/eslint/eslint/issues/5845)) ([#6201](https://github.com/eslint/eslint/issues/6201)) (Kai Cataldo)




## Dependency Upgrades


* [777941e](https://github.com/eslint/eslint/commit/777941e) Upgrade: doctrine to 1.2.2 (fixes [#6121](https://github.com/eslint/eslint/issues/6121)) ([#6231](https://github.com/eslint/eslint/issues/6231)) (alberto)
