---
layout: post
title: ESLint v2.10.0 released
teaser: "We just pushed ESLint v2.10.0, which is a minor release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - ilyavolodin
categories:
  - Release Notes
---

## Highlights

This is a summary of the major changes you need to know about for this version of ESLint.

### New Rules

This version introduces one new rule:

* [`object-property-newline`](https://eslint.org/docs/rules/object-property-newline)

### New Rule Options

A few rules got additional options:

* [`no-extra-parens`](https://eslint.org/docs/rules/no-extra-parens)
* [`no-irregular-whitespace`](https://eslint.org/docs/rules/no-irregular-whitespace)
* [`prefer-const`](https://eslint.org/docs/rules/prefer-const)
* [`object-shorthand`](https://eslint.org/docs/rules/object-shorthand)

## Features


* [f84eb80](https://github.com/eslint/eslint/commit/f84eb80) New: Add new rule `object-property-newline` (fixes [#5667](https://github.com/eslint/eslint/issues/5667)) ([#5933](https://github.com/eslint/eslint/issues/5933)) (Vitor Balocco)




## Enhancements


* [767da6f](https://github.com/eslint/eslint/commit/767da6f) Update: add returnAssign option to no-extra-parens (fixes [#6036](https://github.com/eslint/eslint/issues/6036)) ([#6095](https://github.com/eslint/eslint/issues/6095)) (Kai Cataldo)
* [0734967](https://github.com/eslint/eslint/commit/0734967) Update: Add an option to `prefer-const` (fixes [#5692](https://github.com/eslint/eslint/issues/5692)) ([#6040](https://github.com/eslint/eslint/issues/6040)) (Toru Nagashima)
* [7941d5e](https://github.com/eslint/eslint/commit/7941d5e) Update: Add autofix for `lines-around-comment` (fixes [#5956](https://github.com/eslint/eslint/issues/5956)) ([#6062](https://github.com/eslint/eslint/issues/6062)) (alberto)
* [8633e4d](https://github.com/eslint/eslint/commit/8633e4d) Update: multipass should not exit prematurely (fixes [#5995](https://github.com/eslint/eslint/issues/5995)) ([#6048](https://github.com/eslint/eslint/issues/6048)) (alberto)
* [3c44c2c](https://github.com/eslint/eslint/commit/3c44c2c) Update: Adds an avoidQuotes option for object-shorthand (fixes [#3366](https://github.com/eslint/eslint/issues/3366)) ([#5870](https://github.com/eslint/eslint/issues/5870)) (Chris Sauvé)
* [a3a6e06](https://github.com/eslint/eslint/commit/a3a6e06) Update: no-irregal-whitespace in a regular expression (fixes [#5840](https://github.com/eslint/eslint/issues/5840)) ([#6018](https://github.com/eslint/eslint/issues/6018)) (Linda_pp)




## Bug Fixes


* [10b0933](https://github.com/eslint/eslint/commit/10b0933) Fix: Optimize no-irregular-whitespace for the common case (fixes [#6116](https://github.com/eslint/eslint/issues/6116)) ([#6117](https://github.com/eslint/eslint/issues/6117)) (Andres Suarez)
* [e13e696](https://github.com/eslint/eslint/commit/e13e696) Fix: `_` and `$` in isES5Constructor (fixes [#6085](https://github.com/eslint/eslint/issues/6085)) ([#6094](https://github.com/eslint/eslint/issues/6094)) (Kevin Locke)
* [67916b9](https://github.com/eslint/eslint/commit/67916b9) Fix: `no-loop-func` crashed (fixes [#6130](https://github.com/eslint/eslint/issues/6130)) ([#6138](https://github.com/eslint/eslint/issues/6138)) (Toru Nagashima)
* [d311a62](https://github.com/eslint/eslint/commit/d311a62) Fix: Sort fixes consistently even if they overlap (fixes [#6124](https://github.com/eslint/eslint/issues/6124)) ([#6133](https://github.com/eslint/eslint/issues/6133)) (alberto)
* [067db14](https://github.com/eslint/eslint/commit/067db14) Fix: Replace `assert.deepEqual` by `lodash.isEqual` (fixes [#6111](https://github.com/eslint/eslint/issues/6111)) ([#6112](https://github.com/eslint/eslint/issues/6112)) (alberto)
* [52fdf04](https://github.com/eslint/eslint/commit/52fdf04) Fix: `no-multiple-empty-lines` duplicate errors at BOF (fixes [#6113](https://github.com/eslint/eslint/issues/6113)) ([#6114](https://github.com/eslint/eslint/issues/6114)) (alberto)
* [ef739cd](https://github.com/eslint/eslint/commit/ef739cd) Fix: Merge various command line configs at the same time (fixes [#6104](https://github.com/eslint/eslint/issues/6104)) ([#6108](https://github.com/eslint/eslint/issues/6108)) (Ed Lee)
* [6df4b23](https://github.com/eslint/eslint/commit/6df4b23) Fix: `no-return-assign` warning nested expressions (fixes [#5913](https://github.com/eslint/eslint/issues/5913)) ([#6041](https://github.com/eslint/eslint/issues/6041)) (Toru Nagashima)
* [d40017f](https://github.com/eslint/eslint/commit/d40017f) Fix: comma-style accounts for parens in array (fixes [#6006](https://github.com/eslint/eslint/issues/6006)) ([#6038](https://github.com/eslint/eslint/issues/6038)) (Kai Cataldo)
* [a9a4652](https://github.com/eslint/eslint/commit/a9a4652) Fix: throw when rule uses `fix` but `meta.fixable` not set (fixes [#5970](https://github.com/eslint/eslint/issues/5970)) ([#6043](https://github.com/eslint/eslint/issues/6043)) (Vitor Balocco)
* [388d6f8](https://github.com/eslint/eslint/commit/388d6f8) Fix: `no-sequences` false negative at arrow expressions (fixes [#6082](https://github.com/eslint/eslint/issues/6082)) ([#6083](https://github.com/eslint/eslint/issues/6083)) (Toru Nagashima)
* [a66bf19](https://github.com/eslint/eslint/commit/a66bf19) Fix: `lines-around-comment` multiple errors on same line (fixes [#5965](https://github.com/eslint/eslint/issues/5965)) ([#5994](https://github.com/eslint/eslint/issues/5994)) (alberto)
* [ef8cbff](https://github.com/eslint/eslint/commit/ef8cbff) Fix: object-shorthand should only lint computed methods (fixes [#6015](https://github.com/eslint/eslint/issues/6015)) ([#6024](https://github.com/eslint/eslint/issues/6024)) (Kai Cataldo)
* [dd8bf93](https://github.com/eslint/eslint/commit/dd8bf93) Fix: blockless else in max-statements-per-line (fixes [#5926](https://github.com/eslint/eslint/issues/5926)) ([#5993](https://github.com/eslint/eslint/issues/5993)) (Glen Mailer)
* [3db2e89](https://github.com/eslint/eslint/commit/3db2e89) Fix: Do not swallow exceptions in CLIEngine.getFormatter (fixes [#5977](https://github.com/eslint/eslint/issues/5977)) ([#5978](https://github.com/eslint/eslint/issues/5978)) (Gustav Nikolaj)
* [eb2fb44](https://github.com/eslint/eslint/commit/eb2fb44) Fix: Always ignore defaults unless explicitly passed (fixes [#5547](https://github.com/eslint/eslint/issues/5547)) ([#5820](https://github.com/eslint/eslint/issues/5820)) (Ian VanSchooten)
* [2f15354](https://github.com/eslint/eslint/commit/2f15354) Fix: Removed false positives of break and continue (fixes [#5972](https://github.com/eslint/eslint/issues/5972)) ([#6000](https://github.com/eslint/eslint/issues/6000)) (Onur Temizkan)




## Documentation


* [098cd9c](https://github.com/eslint/eslint/commit/098cd9c) Docs: Distinguish examples in rules under Stylistic Issues part 4 ([#6136](https://github.com/eslint/eslint/issues/6136)) (Kenneth Williams)
* [805742c](https://github.com/eslint/eslint/commit/805742c) Docs: Clarify JSX option usage ([#6132](https://github.com/eslint/eslint/issues/6132)) (Richard Collins)
* [36bec90](https://github.com/eslint/eslint/commit/36bec90) Docs: linkify URLs in development-environment.md ([#6150](https://github.com/eslint/eslint/issues/6150)) (chrisjshull)
* [29c401a](https://github.com/eslint/eslint/commit/29c401a) Docs: Convert rules in index under Removed from list to table ([#6091](https://github.com/eslint/eslint/issues/6091)) (Mark Pedrotti)
* [6294459](https://github.com/eslint/eslint/commit/6294459) Docs: Correct syntax for default ignores and `.eslintignore` example ([#6118](https://github.com/eslint/eslint/issues/6118)) (alberto)
* [e6f56da](https://github.com/eslint/eslint/commit/e6f56da) Docs: Document `--ignore-pattern` ([#6120](https://github.com/eslint/eslint/issues/6120)) (alberto)
* [c4fc39b](https://github.com/eslint/eslint/commit/c4fc39b) Docs: Update headings of rules under Removed (refs [#5774](https://github.com/eslint/eslint/issues/5774)) ([#6102](https://github.com/eslint/eslint/issues/6102)) (Mark Pedrotti)
* [04563ca](https://github.com/eslint/eslint/commit/04563ca) Docs: Describe options in rules under Possible Errors part 2 ([#6063](https://github.com/eslint/eslint/issues/6063)) (Mark Pedrotti)
* [0b67170](https://github.com/eslint/eslint/commit/0b67170) Docs: Correct default for `one-var-declaration-per-line` (fixes [#6017](https://github.com/eslint/eslint/issues/6017)) ([#6022](https://github.com/eslint/eslint/issues/6022)) (Ed Lee)
* [992d9cf](https://github.com/eslint/eslint/commit/992d9cf) Docs: Fix typography/teriminology in indent doc (fixes [#6045](https://github.com/eslint/eslint/issues/6045)) ([#6044](https://github.com/eslint/eslint/issues/6044)) (Rich Trott)
* [ad10106](https://github.com/eslint/eslint/commit/ad10106) Docs: Update comma-style docs ([#6039](https://github.com/eslint/eslint/issues/6039)) (Kai Cataldo)
* [8e96064](https://github.com/eslint/eslint/commit/8e96064) Docs: Clarify rule example in README since we allow string error levels ([#6061](https://github.com/eslint/eslint/issues/6061)) (Kevin Partington)
* [a2cc54e](https://github.com/eslint/eslint/commit/a2cc54e) Docs: Organize meta and describe visitor in Working with Rules ([#5967](https://github.com/eslint/eslint/issues/5967)) (Mark Pedrotti)
* [d5f4104](https://github.com/eslint/eslint/commit/d5f4104) Docs: mention parsing errors in strict mode (fixes [#5485](https://github.com/eslint/eslint/issues/5485)) ([#5991](https://github.com/eslint/eslint/issues/5991)) (Mark Pedrotti)
* [249732e](https://github.com/eslint/eslint/commit/249732e) Docs: Move docs from eslint.github.io (fixes [#5964](https://github.com/eslint/eslint/issues/5964)) ([#6012](https://github.com/eslint/eslint/issues/6012)) (Nicholas C. Zakas)
* [4c2de6c](https://github.com/eslint/eslint/commit/4c2de6c) Docs: Add example of diff clarity to comma-dangle rule docs ([#6035](https://github.com/eslint/eslint/issues/6035)) (Vitor Balocco)
* [ab57e94](https://github.com/eslint/eslint/commit/ab57e94) Docs: Add example of diff clarity to newline-per-chained-call ([#5986](https://github.com/eslint/eslint/issues/5986)) (Vitor Balocco)
* [88bc014](https://github.com/eslint/eslint/commit/88bc014) Docs: Update readme info about jshint ([#6027](https://github.com/eslint/eslint/issues/6027)) (alberto)
* [a2c15cc](https://github.com/eslint/eslint/commit/a2c15cc) Docs: put config example in code block ([#6005](https://github.com/eslint/eslint/issues/6005)) (Amos Wenger)
* [a5011cb](https://github.com/eslint/eslint/commit/a5011cb) Docs: Fix a wrong examples' header of `prefer-arrow-callback`. ([#6020](https://github.com/eslint/eslint/issues/6020)) (Toru Nagashima)
* [1484ede](https://github.com/eslint/eslint/commit/1484ede) Docs: Typo in nodejs-api ([#6025](https://github.com/eslint/eslint/issues/6025)) (alberto)
* [ade6a9b](https://github.com/eslint/eslint/commit/ade6a9b) Docs: typo: "eslint-disable-line" not "eslint disable-line" ([#6019](https://github.com/eslint/eslint/issues/6019)) (Will Day)






## Build Related


* [06f6252](https://github.com/eslint/eslint/commit/06f6252) Build: Use split instead of slice/indexOf for commit check (fixes [#6109](https://github.com/eslint/eslint/issues/6109)) ([#6110](https://github.com/eslint/eslint/issues/6110)) (Ed Lee)
* [716345f](https://github.com/eslint/eslint/commit/716345f) Build: Match rule id at beginning of heading (refs [#5774](https://github.com/eslint/eslint/issues/5774)) ([#6089](https://github.com/eslint/eslint/issues/6089)) (Mark Pedrotti)
* [dc538aa](https://github.com/eslint/eslint/commit/dc538aa) Build: Pin proxyquire to ">=1.0.0 <1.7.5" (fixes [#6096](https://github.com/eslint/eslint/issues/6096)) ([#6100](https://github.com/eslint/eslint/issues/6100)) (alberto)




## Chores


* [5d390b2](https://github.com/eslint/eslint/commit/5d390b2) Chore: Replace deprecated calls to context - batch 4 (fixes [#6029](https://github.com/eslint/eslint/issues/6029)) ([#6087](https://github.com/eslint/eslint/issues/6087)) (alberto)
* [4ae39d2](https://github.com/eslint/eslint/commit/4ae39d2) Chore: Replace deprecated calls to context - batch 3 (refs [#6029](https://github.com/eslint/eslint/issues/6029)) ([#6056](https://github.com/eslint/eslint/issues/6056)) (alberto)
* [cd1b057](https://github.com/eslint/eslint/commit/cd1b057) Chore: Replace deprecated calls to context - batch 2 (refs [#6029](https://github.com/eslint/eslint/issues/6029)) ([#6049](https://github.com/eslint/eslint/issues/6049)) (alberto)
* [9b9d76c](https://github.com/eslint/eslint/commit/9b9d76c) Chore: Replace deprecated calls to context - batch 1 (refs [#6029](https://github.com/eslint/eslint/issues/6029)) ([#6034](https://github.com/eslint/eslint/issues/6034)) (alberto)
