---
layout: post
title: ESLint v2.9.0 released
teaser: "We just pushed ESLint v2.9.0, which is a minor release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - nzakas
categories:
  - Release Notes
---

## Highlights

This is a summary of the major changes you need to know about for this version of ESLint.

### Improved Autofix

This release features a new version of autofix. Now, when you use the `--fix` option, ESLint will make multiple passes over your code in an attempt to fix as many issues as possible. As a result, autofix will take more time now than it did previously, but we believe that this change will ultimately result in less developer time spent fixing things that can be automatically fixed by ESLint.

Additionally, due to implementing multipass autofix, we were able to extend autofix to more rules. The following rules now will be autofixed:

* [`comma-dangle`](https://eslint.org/docs/rules/comma-dangle)
* [`no-whitespace-before-property`](https://eslint.org/docs/rules/no-whitespace-before-property)

### New Rules

This version introduces some new rules:

* [`no-unsafe-finally`](https://eslint.org/docs/rules/no-unsafe-finally)
* [`no-useless-computed-key`](https://eslint.org/docs/rules/no-useless-computed-key)


## Features


* [e606523](https://github.com/eslint/eslint/commit/e606523) New: Rule `no-unsafe-finally` (fixes [#5808](https://github.com/eslint/eslint/issues/5808)) ([#5932](https://github.com/eslint/eslint/issues/5932)) (Onur Temizkan)
* [a01b412](https://github.com/eslint/eslint/commit/a01b412) New: Add `no-useless-computed-key` rule (fixes [#5402](https://github.com/eslint/eslint/issues/5402)) (Burak Yigit Kaya)




## Enhancements


* [e2ad1ec](https://github.com/eslint/eslint/commit/e2ad1ec) Update: object-shorthand lints computed methods (fixes [#5871](https://github.com/eslint/eslint/issues/5871)) ([#5963](https://github.com/eslint/eslint/issues/5963)) (Chris Sauvé)
* [51ddd4b](https://github.com/eslint/eslint/commit/51ddd4b) Update: Use process @abstract when processing @return (fixes [#5941](https://github.com/eslint/eslint/issues/5941)) ([#5945](https://github.com/eslint/eslint/issues/5945)) (Simon Schick)
* [52a4bea](https://github.com/eslint/eslint/commit/52a4bea) Update: Add autofix for `no-whitespace-before-property` (fixes [#5927](https://github.com/eslint/eslint/issues/5927)) ([#5951](https://github.com/eslint/eslint/issues/5951)) (alberto)
* [586478e](https://github.com/eslint/eslint/commit/586478e) Update: Add autofix for `comma-dangle` (fixes [#3805](https://github.com/eslint/eslint/issues/3805)) ([#5925](https://github.com/eslint/eslint/issues/5925)) (alberto)
* [cb78585](https://github.com/eslint/eslint/commit/cb78585) Update: Add `allowUnboundThis` to `prefer-arrow-callback` (fixes [#4668](https://github.com/eslint/eslint/issues/4668)) (Burak Yigit Kaya)
* [19f6fff](https://github.com/eslint/eslint/commit/19f6fff) Update: Autofixing does multiple passes (refs [#5329](https://github.com/eslint/eslint/issues/5329)) (Nicholas C. Zakas)
* [2b39461](https://github.com/eslint/eslint/commit/2b39461) Update: `commentPattern` option for `default-case` rule (fixes [#5803](https://github.com/eslint/eslint/issues/5803)) (Artyom Lvov)




## Bug Fixes


* [a8a2cd8](https://github.com/eslint/eslint/commit/a8a2cd8) Fix: Avoid autoconfig crashes from inline comments (fixes [#5992](https://github.com/eslint/eslint/issues/5992)) ([#5999](https://github.com/eslint/eslint/issues/5999)) (Ian VanSchooten)
* [141b778](https://github.com/eslint/eslint/commit/141b778) Fix: no-control-regex literal handling fixed. (fixes [#5737](https://github.com/eslint/eslint/issues/5737)) ([#5943](https://github.com/eslint/eslint/issues/5943)) (Efe Gürkan YALAMAN)
* [577757d](https://github.com/eslint/eslint/commit/577757d) Fix: Clarify color option (fixes [#5928](https://github.com/eslint/eslint/issues/5928)) ([#5974](https://github.com/eslint/eslint/issues/5974)) (Grant Snodgrass)
* [1e7a3ef](https://github.com/eslint/eslint/commit/1e7a3ef) Fix: `id-match` false positive in property values (fixes [#5885](https://github.com/eslint/eslint/issues/5885)) ([#5960](https://github.com/eslint/eslint/issues/5960)) (Mike Sherov)
* [f842d18](https://github.com/eslint/eslint/commit/f842d18) Fix: `no-this-before-super` crash on unreachable paths (fixes [#5894](https://github.com/eslint/eslint/issues/5894)) (Toru Nagashima)
* [f1b2992](https://github.com/eslint/eslint/commit/f1b2992) Fix: `no-useless-escape` false positive in JSXAttribute (fixes [#5882](https://github.com/eslint/eslint/issues/5882)) (Toru Nagashima)
* [a9c5323](https://github.com/eslint/eslint/commit/a9c5323) Fix: Install ESLint on init if not installed (fixes [#5833](https://github.com/eslint/eslint/issues/5833)) (Kai Cataldo)




## Documentation


* [e7e6581](https://github.com/eslint/eslint/commit/e7e6581) Docs: Update CLA link ([#5980](https://github.com/eslint/eslint/issues/5980)) (Gustav Nikolaj)
* [46e058d](https://github.com/eslint/eslint/commit/46e058d) Docs: Correct typo in configuring.md ([#5957](https://github.com/eslint/eslint/issues/5957)) (Nick S. Plekhanov)
* [43f6d05](https://github.com/eslint/eslint/commit/43f6d05) Docs: Update docs to refer to column ([#5937](https://github.com/eslint/eslint/issues/5937)) (Sashko Stubailo)
* [a4f9c5a](https://github.com/eslint/eslint/commit/a4f9c5a) Docs: Distinguish examples in rules under Stylistic Issues part 3 (Kenneth Williams)
* [249eb40](https://github.com/eslint/eslint/commit/249eb40) Docs: Clarify init sets up local installation (fixes [#5874](https://github.com/eslint/eslint/issues/5874)) (Kai Cataldo)
* [6cd8c86](https://github.com/eslint/eslint/commit/6cd8c86) Docs: Describe options in rules under Possible Errors part 1 (Mark Pedrotti)
* [a02960b](https://github.com/eslint/eslint/commit/a02960b) Docs: Fix missing delimiter in README links (Kevin Partington)
* [3a9e72c](https://github.com/eslint/eslint/commit/3a9e72c) Docs: Update developer guide with new standards (Nicholas C. Zakas)
* [74674ad](https://github.com/eslint/eslint/commit/74674ad) Docs: Move `sort-imports` to 'ECMAScript 6' (Kenneth Williams)
* [ae69ddb](https://github.com/eslint/eslint/commit/ae69ddb) Docs: Fix severity type in example (Kenneth Williams)
* [1e4b0ca](https://github.com/eslint/eslint/commit/1e4b0ca) Docs: Reduce length of paragraphs in rules index (Mark Pedrotti)
* [8cfe1eb](https://github.com/eslint/eslint/commit/8cfe1eb) Docs: Fix a wrong option (Zach Orlovsky)
* [8f6739f](https://github.com/eslint/eslint/commit/8f6739f) Docs: Add alberto as reviewer (alberto)
* [2ae4938](https://github.com/eslint/eslint/commit/2ae4938) Docs: Fix message for `inline-config` option (alberto)
* [089900b](https://github.com/eslint/eslint/commit/089900b) Docs: Fix a wrong rule name in an example (Toru Nagashima)
* [c032b41](https://github.com/eslint/eslint/commit/c032b41) Docs: Fix emphasis (Toru Nagashima)
* [ae606f0](https://github.com/eslint/eslint/commit/ae606f0) Docs: Update JSCS info in README (alberto)
* [ed38358](https://github.com/eslint/eslint/commit/ed38358) Docs: Removed incorrect example (James M. Greene)
* [af3113c](https://github.com/eslint/eslint/commit/af3113c) Docs: Fix config comments in indent docs (Brandon Mills)




## Dependency Upgrades


* [23b00e0](https://github.com/eslint/eslint/commit/23b00e0) Upgrade: npm-license to 0.3.2 (fixes [#5996](https://github.com/eslint/eslint/issues/5996)) ([#5998](https://github.com/eslint/eslint/issues/5998)) (alberto)
* [377167d](https://github.com/eslint/eslint/commit/377167d) Upgrade: ignore to 3.1.2 (fixes [#5979](https://github.com/eslint/eslint/issues/5979)) ([#5988](https://github.com/eslint/eslint/issues/5988)) (alberto)
* [25d626a](https://github.com/eslint/eslint/commit/25d626a) Upgrade: espree 3.1.4 (fixes [#5923](https://github.com/eslint/eslint/issues/5923), fixes [#5756](https://github.com/eslint/eslint/issues/5756)) (Kai Cataldo)




## Build Related


* [0be26bc](https://github.com/eslint/eslint/commit/0be26bc) Build: Add nodejs 6 to travis (fixes [#5971](https://github.com/eslint/eslint/issues/5971)) ([#5973](https://github.com/eslint/eslint/issues/5973)) (Gyandeep Singh)
* [0023fe6](https://github.com/eslint/eslint/commit/0023fe6) Build: Add “chore” to commit tags (fixes [#5880](https://github.com/eslint/eslint/issues/5880)) ([#5929](https://github.com/eslint/eslint/issues/5929)) (Mike Sherov)




## Chores


* [42d1ecc](https://github.com/eslint/eslint/commit/42d1ecc) Chore: Add metadata to existing rules - Batch 7 (refs [#5417](https://github.com/eslint/eslint/issues/5417)) ([#5969](https://github.com/eslint/eslint/issues/5969)) (Vitor Balocco)
* [d24516a](https://github.com/eslint/eslint/commit/d24516a) Chore: Add metadata to existing rules - Batch 6 (refs [#5417](https://github.com/eslint/eslint/issues/5417)) ([#5966](https://github.com/eslint/eslint/issues/5966)) (Vitor Balocco)
* [5f8abab](https://github.com/eslint/eslint/commit/5f8abab) Chore: Add metadata to existing rules - Batch 5 (refs [#5417](https://github.com/eslint/eslint/issues/5417)) ([#5944](https://github.com/eslint/eslint/issues/5944)) (Vitor Balocco)
* [0562f77](https://github.com/eslint/eslint/commit/0562f77) Chore: Add missing newlines to test cases (fixes [#5947](https://github.com/eslint/eslint/issues/5947)) (Rich Trott)
* [fc78e78](https://github.com/eslint/eslint/commit/fc78e78) Chore: Enable quote-props rule in eslint-config-eslint (refs [#5188](https://github.com/eslint/eslint/issues/5188)) ([#5938](https://github.com/eslint/eslint/issues/5938)) (Gyandeep Singh)
* [e7c0737](https://github.com/eslint/eslint/commit/e7c0737) Chore: Enable no-console rule in eslint-config-eslint (refs [#5188](https://github.com/eslint/eslint/issues/5188)) (Kevin Partington)
* [9afb9cb](https://github.com/eslint/eslint/commit/9afb9cb) Chore: Remove workaround for espree and escope bugs (fixes [#5852](https://github.com/eslint/eslint/issues/5852)) (alberto)
* [3ffc582](https://github.com/eslint/eslint/commit/3ffc582) Chore: Update copyright and license info (alberto)
* [02be29f](https://github.com/eslint/eslint/commit/02be29f) Chore: Remove CLA check from bot (Nicholas C. Zakas)
* [220713e](https://github.com/eslint/eslint/commit/220713e) Chore: Add metadata to existing rules - Batch 4 (refs [#5417](https://github.com/eslint/eslint/issues/5417)) (Vitor Balocco)
* [df53414](https://github.com/eslint/eslint/commit/df53414) Chore: Include jQuery Foundation info (Nicholas C. Zakas)
