---
layout: post
title: ESLint Joins The jQuery Foundation
teaser: "We are happy to announce that ESLint is now part of the jQuery Foundation. This is a huge step and we share what this means for the project. We're also looking forward to its growth throughout the open source community."
date: 2016-04-19
tags:
  - jQuery Foundation
  - Open Source
authors:
  - nzakas
categories:
  - Announcements
---

I've believed for a while that once an open source project reaches a certain level of ubiquity, the maintainers have a responsibility to ensure its survival for the good of the community. Over the past couple of years, I watched as important projects hit roadblocks: YUI abruptly shut down, Node.js splintered before merging back together, and Express was left in a state of disarray. Communities were left scrambling, unsure what to rely on. During this time, I started formulating a plan for how to keep ESLint from falling into the same pattern.

Today, ESLint joins the jQuery Foundation to ensure that the project will live on for as long as the community needs it. The jQuery Foundation has been a great home for projects like jQuery and Esprima, and after merging with the Dojo Foundation, is also the home of projects such as Lodash and Grunt. I'm proud to have ESLint listed alongside some of the most important and influential projects in the JavaScript ecosystem.

From my perspective, ESLint joining the jQuery Foundation ensures a few things:

1. The project will go on even after I've left it. While I don't have any plans to leave the project, history shows that it's quite common for the creators of open source projects to eventually leave. From John Resig leaving jQuery to Ryan Dahl leaving Node.js, I can't picture myself being immune from the same path.
1. ESLint will never be "sold" to a company. As the events with Node.js and Express show, this type of relationship doesn't always work out smoothly. I feel that the ESLint community deserves this type of guarantee so there's no question about whether or not it's safe to rely on ESLint.
1. The ESLint project will be up-to-date with all the latest best practices and legal advice relevant to open source.

It's my hope that these assurances will help the ESLint community to continue to grow and thrive.

## What Is Changing

While the transition to the jQuery Foundation is mostly transparent, there are a few things that are changing:

* **CLA** - ESLint will change from using its own CLA to the jQuery Foundation CLA. If you previously signed the ESLint CLA, we'll be asking you to sign the jQuery Foundation CLA the next time you submit a pull request.
* **Code of Conduct** - ESLint will change to use the jQuery Foundation Code of Conduct instead of our own. This change is minimal because we used the jQuery Foundation's Code of Conduct as the model for own. The only real change here is that the Foundation will be overseeing the Code of Conduct and handling violations directly instead of being handled by the ESLint team.
* **Legal** - The jQuery Foundation will be handling all legal aspects of ESLint going forward. That means they are the copyright holders and will also be registering ESLint and the ESLint logo as trademarks to protect the project.

## What Isn't Changing

Everything else will be the same as it always has been. Specifically:

* We will continue to use the ESLint GitHub organization for all ESLint-related projects.
* The ESLint team will continue to maintain and develop ESLint going forward.
* All ESLint team members will continue to be team members.

## A New Beginning

I hope you're as excited about ESLint joining the jQuery Foundation as I am. I see this as an important step in the life of ESLint as a whole. The ESLint community has made the project the success that it is, and moving ESLint into the jQuery Foundation is my way of saying that the project is, and always will be, for the community.

-- Nicholas
