---
layout: post
title: ESLint v2.8.0 released
teaser: "We just pushed ESLint v2.8.0, which is a minor release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - nzakas
categories:
  - Release Notes
---

## Enhancements


* [76913b6](https://github.com/eslint/eslint/commit/76913b6) Update: Add metadata to existing rules - Batch 3 (refs [#5417](https://github.com/eslint/eslint/issues/5417)) (Vitor Balocco)
* [fb3c2eb](https://github.com/eslint/eslint/commit/fb3c2eb) Update: allow template literals (fixes [#5234](https://github.com/eslint/eslint/issues/5234)) (Jonathan Haines)
* [5a4a935](https://github.com/eslint/eslint/commit/5a4a935) Update: Add metadata to existing rules - Batch 2 (refs [#5417](https://github.com/eslint/eslint/issues/5417)) (Vitor Balocco)
* [f8db9c9](https://github.com/eslint/eslint/commit/f8db9c9) Update: add nestedBinaryExpressions to no-extra-parens (fixes [#3065](https://github.com/eslint/eslint/issues/3065)) (Ilya Volodin)
* [0045d57](https://github.com/eslint/eslint/commit/0045d57) Update: `allowNamedFunctions` in `prefer-arrow-callback` (fixes [#5675](https://github.com/eslint/eslint/issues/5675)) (alberto)
* [19da72a](https://github.com/eslint/eslint/commit/19da72a) Update: Add metadata to existing rules - Batch 1 (refs [#5417](https://github.com/eslint/eslint/issues/5417)) (Vitor Balocco)
* [24b6215](https://github.com/eslint/eslint/commit/24b6215) Update: Include 'typeof' in rule 'no-constant-condition' (fixes [#5228](https://github.com/eslint/eslint/issues/5228)) (Vamshi krishna)
* [6fd7d82](https://github.com/eslint/eslint/commit/6fd7d82) Update: Change order in `eslint --init` env options (fixes [#5742](https://github.com/eslint/eslint/issues/5742)) (alberto)
* [6703c02](https://github.com/eslint/eslint/commit/6703c02) Update: no-useless-escape / exact locations of errors (fixes [#5751](https://github.com/eslint/eslint/issues/5751)) (Onur Temizkan)
* [b0e6bc4](https://github.com/eslint/eslint/commit/b0e6bc4) Update: add allowEmptyCatch option to no-empty (fixes [#5800](https://github.com/eslint/eslint/issues/5800)) (Kai Cataldo)
* [228f201](https://github.com/eslint/eslint/commit/228f201) Update: `commentPattern` option for `no-fallthrough` rule (fixes [#5757](https://github.com/eslint/eslint/issues/5757)) (Artyom Lvov)
* [2b202fc](https://github.com/eslint/eslint/commit/2b202fc) Update: Add ignore option to space-before-function-parens (fixes [#4127](https://github.com/eslint/eslint/issues/4127)) (Craig Silverstein)




## Bug Fixes


* [34ad8d2](https://github.com/eslint/eslint/commit/34ad8d2) Fix: Check that module.paths exists (fixes [#5791](https://github.com/eslint/eslint/issues/5791)) (Nicholas C. Zakas)
* [ea2e625](https://github.com/eslint/eslint/commit/ea2e625) Fix: newline-before-return handles return as first token (fixes [#5816](https://github.com/eslint/eslint/issues/5816)) (Kevin Partington)
* [cc14e43](https://github.com/eslint/eslint/commit/cc14e43) Fix: `no-fallthrough` empty case with comment (fixes [#5799](https://github.com/eslint/eslint/issues/5799)) (alberto)
* [13c8b14](https://github.com/eslint/eslint/commit/13c8b14) Fix: LogicalExpression checks for short circuit (fixes [#5693](https://github.com/eslint/eslint/issues/5693)) (Vamshi krishna)
* [73b225e](https://github.com/eslint/eslint/commit/73b225e) Fix: Document and fix metadata (refs [#5417](https://github.com/eslint/eslint/issues/5417)) (Ilya Volodin)
* [c59d909](https://github.com/eslint/eslint/commit/c59d909) Fix: Extra paren check around object arrow bodies (fixes [#5789](https://github.com/eslint/eslint/issues/5789)) (Brandon Mills)
* [02743d5](https://github.com/eslint/eslint/commit/02743d5) Fix: catch self-assignment operators in `no-magic-number` (fixes [#4400](https://github.com/eslint/eslint/issues/4400)) (alberto)
* [ccd8ca9](https://github.com/eslint/eslint/commit/ccd8ca9) Fix: Added property onlyDeclaration to id-match rule (fixes [#3488](https://github.com/eslint/eslint/issues/3488)) (Gajus Kuizinas)
* [3d84b91](https://github.com/eslint/eslint/commit/3d84b91) Fix: ignore trailing whitespace in template literal (fixes [#5786](https://github.com/eslint/eslint/issues/5786)) (Kai Cataldo)
* [24c12ba](https://github.com/eslint/eslint/commit/24c12ba) Fix: improve `constructor-super` errors for literals (fixes [#5449](https://github.com/eslint/eslint/issues/5449)) (Toru Nagashima)




## Documentation


* [a8821a5](https://github.com/eslint/eslint/commit/a8821a5) Docs: Distinguish examples in rules under Stylistic Issues part 2 (Kenneth Williams)
* [37239b1](https://github.com/eslint/eslint/commit/37239b1) Docs: Add new members of the team (Ilya Volodin)
* [882d199](https://github.com/eslint/eslint/commit/882d199) Docs: Improve options description in `no-redeclare` (alberto)
* [6a71ceb](https://github.com/eslint/eslint/commit/6a71ceb) Docs: Improve options description in `no-params-reassign` (alberto)
* [a959063](https://github.com/eslint/eslint/commit/a959063) Docs: Remove link to deprecated ESLintTester project (refs [#3110](https://github.com/eslint/eslint/issues/3110)) (Trey Thomas)
* [6f88546](https://github.com/eslint/eslint/commit/6f88546) Docs: Use double quotes for better Win compatibility (fixes [#5796](https://github.com/eslint/eslint/issues/5796)) (alberto)
* [c94e74e](https://github.com/eslint/eslint/commit/c94e74e) Docs: Make rule descriptions more consistent (Kenneth Williams)
* [6028252](https://github.com/eslint/eslint/commit/6028252) Docs: Distinguish examples in rules under Stylistic Issues part 1 (Mark Pedrotti)
* [f1f1dd7](https://github.com/eslint/eslint/commit/f1f1dd7) Docs: Add @pedrottimark as a committer (Brandon Mills)
* [41db670](https://github.com/eslint/eslint/commit/41db670) Docs: Clarify disable inline comments (Kai Cataldo)
* [9c9a295](https://github.com/eslint/eslint/commit/9c9a295) Docs: Add note about shell vs node glob parameters in cli (alberto)
* [5308ff9](https://github.com/eslint/eslint/commit/5308ff9) Docs: Add code backticks to sentence in fixable rules (Mark Pedrotti)
* [965ec06](https://github.com/eslint/eslint/commit/965ec06) Docs: fix the examples for space-before-function-paren. (Craig Silverstein)
