---
layout: post
title: ESLint v2.5.3 released
teaser: "We just pushed ESLint v2.5.3, which is a minor release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes-patch.png
tags:
  - release
  - patch
authors:
  - nzakas
categories:
  - Release Notes
---

## Highlights

This is a summary of the major changes you need to know about for this version of ESLint.

## Rolling Back of Bundled Dependencies

In v2.5.0, we started bundling dependencies with ESLint. The goal was to create a more stable ESLint package that was functional regardless of the state of npm. Unfortunately, this process turned out to be more complicated than we expected. As we continued to get bug reports over the past couple of days, we decided to revert the bundling of dependencies for now until we can investigate further.










## Bug Fixes

* [98e6bd9](https://github.com/eslint/eslint/commit/98e6bd9) Fix: Correct default for indentation in `eslint --init` (fixes * [#5698](https://github.com/eslint/eslint/issues/5698)) (alberto)
* [679095e](https://github.com/eslint/eslint/commit/679095e) Fix: make the default of `options.cwd` in runtime (fixes * [#5694](https://github.com/eslint/eslint/issues/5694)) (Toru Nagashima)
* [c41fab9](https://github.com/eslint/eslint/commit/c41fab9) Fix: don't use path.extname with undefined value (fixes * [#5678](https://github.com/eslint/eslint/issues/5678)) (Myles Borins)

## Documentation

* [1cc7f8e](https://github.com/eslint/eslint/commit/1cc7f8e) Docs: Remove mention of minimatch for .eslintignore (Ian VanSchooten)
* [5bd69a9](https://github.com/eslint/eslint/commit/5bd69a9) Docs: Reorder FAQ in README (alberto)
* [4f06f2f](https://github.com/eslint/eslint/commit/4f06f2f) Docs: Distinguish examples in rules under Best Practices part 2 (Mark Pedrotti)
* [8c5d954](https://github.com/eslint/eslint/commit/8c5d954) Docs: Typo fix (István Donkó)
* [09659d6](https://github.com/eslint/eslint/commit/09659d6) Docs: Use string severity (Kenneth Williams)
* [a4ae769](https://github.com/eslint/eslint/commit/a4ae769) Docs: Manual changelog update for v2.5.1 (Nicholas C. Zakas)

## Build Related


* [8749ac5](https://github.com/eslint/eslint/commit/8749ac5) Build: Disable bundling dependencies (fixes [#5687](https://github.com/eslint/eslint/issues/5687)) (Nicholas C. Zakas)
* [013a18e](https://github.com/eslint/eslint/commit/013a18e) Build: Fix bundling script (fixes * [#5680](https://github.com/eslint/eslint/issues/5680)) (Nicholas C. Zakas)
