---
layout: post
title: ESLint v2.5.0 released
teaser: "We just pushed ESLint v2.5.0, which is a minor release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - nzakas
categories:
  - Release Notes
---

## Highlights

This is a summary of the major changes you need to know about for this version of ESLint.

### Node.js without OpenSSL Compatibility

Previously, the `--cache` feature was using the Node.js `crypto` module to calculate hashes of files to determine which files had changed. Because of this, ESLint wouldn't work on Node.js compiled without OpenSSL. We changed the `--cache` feature to use a third-party hash function instead, allowing us to remove our dependency on the Node.js `crypto` module and ensure ESLint works fine for Node.js without OpenSSL.

### Bundled Dependencies

This is the first version of ESLint that bundles its dependencies. [Recent events](http://blog.npmjs.org/post/141577284765/kik-left-pad-and-npm) have made it clear that for a development tool like ESLint, bundling dependencies makes a lot of sense. This will ensure a couple of things:

1. That everyone using v2.5.0 of ESLint will be using the same dependencies, meaning that dependency updates won't break a previously working ESLint version.
2. We won't fall victim to dependencies that were available at release time suddenly disappearing.

Bundling dependencies does mean that npm cannot dedupe ESLint dependencies upon installation, but as ESLint is a development tool only, we felt like this tradeoff was worth making to ensure that any given ESLint version that was validated to work at release time will continue to work for everyone no matter what.

### New Rules

* ['no-useless-escape'](https://eslint.org/docs/rules/no-useless-escape)
* ['max-statements-per-line'](https://eslint.org/docs/rules/max-statements-per-line)
* ['no-duplicate-imports'](https://eslint.org/docs/rules/no-duplicate-imports)

## Features


* [d6f8409](https://github.com/eslint/eslint/commit/d6f8409) New: Rule - No useless escape (fixes [#5460](https://github.com/eslint/eslint/issues/5460)) (Onur Temizkan)
* [92d1749](https://github.com/eslint/eslint/commit/92d1749) New: max-statements-per-line (fixes [#5424](https://github.com/eslint/eslint/issues/5424)) (Kenneth Williams)
* [c289414](https://github.com/eslint/eslint/commit/c289414) New: `no-duplicate-imports` rule (fixes [#3478](https://github.com/eslint/eslint/issues/3478)) (Simen Bekkhus)




## Enhancements


* [48ad5fe](https://github.com/eslint/eslint/commit/48ad5fe) Update: Add 'caughtErrors' to rule no-unused-vars (fixes [#3837](https://github.com/eslint/eslint/issues/3837)) (vamshi)
* [d0ae66c](https://github.com/eslint/eslint/commit/d0ae66c) Update: Allow autoconfiguration for JSX code (fixes [#5511](https://github.com/eslint/eslint/issues/5511)) (Ian VanSchooten)
* [4b05ce6](https://github.com/eslint/eslint/commit/4b05ce6) Update: Enforce repo coding conventions via ESLint (refs [#5188](https://github.com/eslint/eslint/issues/5188)) (Kevin Partington)
* [03037c2](https://github.com/eslint/eslint/commit/03037c2) Update: Overrides for space-unary-ops (fixes [#5060](https://github.com/eslint/eslint/issues/5060)) (Afnan Fahim)
* [24d986a](https://github.com/eslint/eslint/commit/24d986a) Update: replace MD5 hashing of cache files with MurmurHash (fixes [#5522](https://github.com/eslint/eslint/issues/5522)) (Michael Ficarra)




## Bug Fixes


* [7021aa9](https://github.com/eslint/eslint/commit/7021aa9) Fix: lines-around-comment in ESLint repo, part 2 (refs [#5188](https://github.com/eslint/eslint/issues/5188)) (Kevin Partington)
* [aaf324a](https://github.com/eslint/eslint/commit/aaf324a) Fix: missing support for json sub configs (fixes [#5413](https://github.com/eslint/eslint/issues/5413)) (Noam Okman)
* [ad90c2b](https://github.com/eslint/eslint/commit/ad90c2b) Fix: incorrect config message (fixes [#5653](https://github.com/eslint/eslint/issues/5653)) (s0ph1e)
* [32748dc](https://github.com/eslint/eslint/commit/32748dc) Fix: `radix` rule false positive at shadowed variables (fixes [#5639](https://github.com/eslint/eslint/issues/5639)) (Toru Nagashima)
* [66db38d](https://github.com/eslint/eslint/commit/66db38d) Fix: `--no-ignore` should not un-ignore default ignores (fixes [#5547](https://github.com/eslint/eslint/issues/5547)) (alberto)
* [4b7305e](https://github.com/eslint/eslint/commit/4b7305e) Fix: Allow default ignored files to be unignored (fixes [#5410](https://github.com/eslint/eslint/issues/5410)) (Ian VanSchooten)
* [9a22625](https://github.com/eslint/eslint/commit/9a22625) Fix: `prefer-const` false positive at non-blocked if (fixes [#5610](https://github.com/eslint/eslint/issues/5610)) (Toru Nagashima)
* [b1fd482](https://github.com/eslint/eslint/commit/b1fd482) Fix: leading comments added from previous node (fixes [#5531](https://github.com/eslint/eslint/issues/5531)) (Kai Cataldo)
* [e94b77d](https://github.com/eslint/eslint/commit/e94b77d) Fix: Respect 'ignoreTrailingComments' in max-len rule (fixes [#5563](https://github.com/eslint/eslint/issues/5563)) (Vamshi Krishna)
* [9289ef8](https://github.com/eslint/eslint/commit/9289ef8) Fix: handle personal package.json without config (fixes [#5496](https://github.com/eslint/eslint/issues/5496)) (Denny Christochowitz)
* [87d74b2](https://github.com/eslint/eslint/commit/87d74b2) Fix: `prefer-const` got to not change scopes (refs [#5284](https://github.com/eslint/eslint/issues/5284)) (Toru Nagashima)
* [f405030](https://github.com/eslint/eslint/commit/f405030) Fix: Ensure allowing `await` as a property name (fixes [#5564](https://github.com/eslint/eslint/issues/5564)) (Toru Nagashima)
* [aefc90c](https://github.com/eslint/eslint/commit/aefc90c) Fix: `no-useless-constructor` clash (fixes [#5573](https://github.com/eslint/eslint/issues/5573)) (Toru Nagashima)
* [cfc14a9](https://github.com/eslint/eslint/commit/cfc14a9) Fix: valid-jsdoc correctly checks type union (fixes [#5260](https://github.com/eslint/eslint/issues/5260)) (Kai Cataldo)
* [689cb7d](https://github.com/eslint/eslint/commit/689cb7d) Fix: `quote-props` false positive on certain keys (fixes [#5532](https://github.com/eslint/eslint/issues/5532)) (Burak Yigit Kaya)
* [167a03a](https://github.com/eslint/eslint/commit/167a03a) Fix: `brace-style` erroneously ignoring certain errors (fixes [#5197](https://github.com/eslint/eslint/issues/5197)) (Burak Yigit Kaya)
* [3133f28](https://github.com/eslint/eslint/commit/3133f28) Fix: object-curly-spacing doesn't know types (fixes [#5537](https://github.com/eslint/eslint/issues/5537)) (fixes [#5538](https://github.com/eslint/eslint/issues/5538)) (Burak Yigit Kaya)
* [bc769ca](https://github.com/eslint/eslint/commit/bc769ca) Fix: Improve file path resolution (fixes [#5314](https://github.com/eslint/eslint/issues/5314)) (Ian VanSchooten)




## Documentation


* [095c435](https://github.com/eslint/eslint/commit/095c435) Docs: Remove ES2016 from experimental section of README (Kevin Partington)
* [ea06868](https://github.com/eslint/eslint/commit/ea06868) Docs: Clarify --ext does not apply to globs (fixes [#5452](https://github.com/eslint/eslint/issues/5452)) (Ian VanSchooten)
* [6022426](https://github.com/eslint/eslint/commit/6022426) Docs: Add link to chat room in README primary links (alberto)
* [2fbb530](https://github.com/eslint/eslint/commit/2fbb530) Docs: Add link to "Proposing a Rule Change" in README (alberto)
* [12a43f1](https://github.com/eslint/eslint/commit/12a43f1) Docs: remove brace expansion from configuring.md (refs [#5314](https://github.com/eslint/eslint/issues/5314)) (Jonathan Haines)
* [a551831](https://github.com/eslint/eslint/commit/a551831) Docs: Distinguish examples in rules under Node.js and CommonJS (Mark Pedrotti)
* [e3e06f3](https://github.com/eslint/eslint/commit/e3e06f3) Docs: Distinguish examples in rules under Best Practices part 4 (Mark Pedrotti)
* [a9f0865](https://github.com/eslint/eslint/commit/a9f0865) Docs: Update no-sequences rule docs for clarity (fixes [#5536](https://github.com/eslint/eslint/issues/5536)) (Kai Cataldo)
* [bae7b30](https://github.com/eslint/eslint/commit/bae7b30) Docs: Add michaelficarra as committer (alberto)
* [e2990e7](https://github.com/eslint/eslint/commit/e2990e7) Docs: Consistent wording in rules README (alberto)
* [49b4d2a](https://github.com/eslint/eslint/commit/49b4d2a) Docs: Update team list with new members (Ilya Volodin)
* [38a0a64](https://github.com/eslint/eslint/commit/38a0a64) Docs: Clarify `linebreak-style` docs (fixes [#5628](https://github.com/eslint/eslint/issues/5628)) (alberto)
* [051b255](https://github.com/eslint/eslint/commit/051b255) Docs: Remove or rewrite references to former ecmaFeatures (Mark Pedrotti)
* [c335650](https://github.com/eslint/eslint/commit/c335650) Docs: correct the no-confusing-arrow docs (Daniel Norman)
* [5a881e7](https://github.com/eslint/eslint/commit/5a881e7) Docs: Fix typo in code snippet for no-unmodified-loop-condition rule (Chris Rebert)
* [9eaa20d](https://github.com/eslint/eslint/commit/9eaa20d) Docs: Fix typo in CLI help message (ryym)
* [a7c3e67](https://github.com/eslint/eslint/commit/a7c3e67) Docs: Invalid json in `configuring.md` (alberto)
* [4e50332](https://github.com/eslint/eslint/commit/4e50332) Docs: Make `prefer-template` examples consistent. (alberto)
* [d0ca171](https://github.com/eslint/eslint/commit/d0ca171) Docs: Separate parser and config questions in issue template (Kevin Partington)
* [9ca8567](https://github.com/eslint/eslint/commit/9ca8567) Docs: Distinguish examples in rules under Best Practices part 3 (Mark Pedrotti)
* [b9c69f1](https://github.com/eslint/eslint/commit/b9c69f1) Docs: Distinguish examples in rules under Variables part 2 (Mark Pedrotti)




## Dependency Upgrades


* [25bf491](https://github.com/eslint/eslint/commit/25bf491) Upgrade: globals 9.x (fixes [#5668](https://github.com/eslint/eslint/issues/5668)) (Toru Nagashima)
* [83cd651](https://github.com/eslint/eslint/commit/83cd651) Upgrade: chai to 3.5.0 (fixes [#5647](https://github.com/eslint/eslint/issues/5647)) (alberto)




## Build Related


* [646f863](https://github.com/eslint/eslint/commit/646f863) Build: Bundle dependencies in package.json (fixes [#5013](https://github.com/eslint/eslint/issues/5013)) (Nicholas C. Zakas)
* [569c478](https://github.com/eslint/eslint/commit/569c478) Build: Fix phantomjs CI problems (fixes [#5666](https://github.com/eslint/eslint/issues/5666)) (alberto)
