---
layout: post
title: ESLint v2.4.0 released
teaser: "We just pushed ESLint v2.4.0, which is a minor release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - nzakas
categories:
  - Release Notes
---

## Highlights

This is a summary of the major changes you need to know about for this version of ESLint.

### babel-eslint Compatibility Fix

The v2.3.0 release introduced a change that broke compatibility with `babel-eslint`. We realize that a lot of you depend on `babel-eslint` and so we wanted to make sure to restore compatibility as quickly as possible. We couldn't undo the change that cause the problem as it would have caused a regression for ESLint, and it took us some time to figure out the right approach to solve the problem.

With v2.4.0, `babel-eslint` compatibility is now restored with a permanent solution that should prevent this from happening again. We appreciate your patience as we tried to determine the best long-term solution.






## Features


* [13ef1c7](https://github.com/eslint/eslint/commit/13ef1c7) New: add `--parser-options` to CLI (fixes [#5495](https://github.com/eslint/eslint/issues/5495)) (Jordan Harband)




## Enhancements


* [9c6c70c](https://github.com/eslint/eslint/commit/9c6c70c) Update: add `allowParens` option to `no-confusing-arrow` (fixes [#5332](https://github.com/eslint/eslint/issues/5332)) (Burak Yigit Kaya)




## Bug Fixes


* [97b2466](https://github.com/eslint/eslint/commit/97b2466) Fix: estraverse/escope to work with unknowns (fixes [#5476](https://github.com/eslint/eslint/issues/5476)) (Nicholas C. Zakas)
* [641b3f7](https://github.com/eslint/eslint/commit/641b3f7) Fix: validate the type of severity level (fixes [#5499](https://github.com/eslint/eslint/issues/5499)) (Shinnosuke Watanabe)
* [03e6869](https://github.com/eslint/eslint/commit/03e6869) Fix: newline-before-return: bug with comment (fixes [#5480](https://github.com/eslint/eslint/issues/5480)) (mustafa)
* [ad100fd](https://github.com/eslint/eslint/commit/ad100fd) Fix: overindent in VariableDeclarator parens or brackets (fixes [#5492](https://github.com/eslint/eslint/issues/5492)) (David Greenspan)
* [9f18a81](https://github.com/eslint/eslint/commit/9f18a81) Fix: Ignore destructuring assignment in `object-shorthand` (fixes [#5488](https://github.com/eslint/eslint/issues/5488)) (alberto)
* [38eb7f1](https://github.com/eslint/eslint/commit/38eb7f1) Fix: key-spacing checks ObjectExpression is multiline (fixes [#5479](https://github.com/eslint/eslint/issues/5479)) (Kevin Partington)
* [9592c45](https://github.com/eslint/eslint/commit/9592c45) Fix: `no-unmodified-loop-condition` false positive (fixes [#5445](https://github.com/eslint/eslint/issues/5445)) (Toru Nagashima)




## Documentation


* [9ee8869](https://github.com/eslint/eslint/commit/9ee8869) Docs: no-unused-expressions - add more edge unusable and usable examples (Brett Zamir)
* [56bf864](https://github.com/eslint/eslint/commit/56bf864) Docs: Create parity between no-sequences examples (Brett Zamir)
* [ae1ee54](https://github.com/eslint/eslint/commit/ae1ee54) Docs: fix func-style arrow exception option (Craig Martin)
* [91852fd](https://github.com/eslint/eslint/commit/91852fd) Docs: no-lone-blocks - show non-problematic (and problematic) label (Brett Zamir)
* [b34458f](https://github.com/eslint/eslint/commit/b34458f) Docs: Rearrange rules for better categories (and improve rule summaries) (Brett Zamir)
* [1198b26](https://github.com/eslint/eslint/commit/1198b26) Docs: Minor README clarifications (Brett Zamir)
* [9b8e04b](https://github.com/eslint/eslint/commit/9b8e04b) Docs: Replace all node references to Node.js which is the official name (Brett Zamir)
* [cc1f2f0](https://github.com/eslint/eslint/commit/cc1f2f0) Docs: Minor fixes in no-new-func (Brett Zamir)
* [6ab81d4](https://github.com/eslint/eslint/commit/6ab81d4) Docs: Distinguish examples in rules under Best Practices part 1 (Mark Pedrotti)
* [979c096](https://github.com/eslint/eslint/commit/979c096) Docs: Document linebreak-style as fixable. (Afnan Fahim)
* [5d9a798](https://github.com/eslint/eslint/commit/5d9a798) Docs: README.md, prefer-const; change modified to reassigned (Michiel de Bruijne)
