---
layout: post
title: ESLint v2.3.0 released
teaser: "We just pushed ESLint v2.3.0, which is a minor release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - ilyavolodin
categories:
  - Release Notes
---

## Highlights
Here are some highlights of changes in this release.

### Support for string severity in configs
v2.3.0 introduces ability to use strings as severity level in configuration files. Before you had to use number 0, 1 and 2 to configure rules. Now we also added ability to use strings. You can now use:

* `off` - 0
* `warn` - 1
* `error` - 2

Both string and int values will work the same way

### EcmaScript version 7 Support
We recently updated our parser [Espree](https://github.com/eslint/espree) with support for new exponentiation operator. You can now set `ecmaVersion` to 7 under `parserOptions`. We also updated [space-infix-ops](https://eslint.org/docs/rules/space-infix-ops) to support new `**` operator.

### Improved error messaging for plugins
If ESLint fails to find a plugin required by the config file, we will now print a clear message explaining to user what needs to be done to fix this issue.


## Features


* [9e9daab](https://github.com/eslint/eslint/commit/9e9daab) New: newline-before-return rule (fixes [#5009](https://github.com/eslint/eslint/issues/5009)) (Kai Cataldo)
* [560c0d9](https://github.com/eslint/eslint/commit/560c0d9) New: no-restricted-globals rule implementation (fixes [#3966](https://github.com/eslint/eslint/issues/3966)) (Benoît Zugmeyer)




## Enhancements


* [1b2c6e0](https://github.com/eslint/eslint/commit/1b2c6e0) Update: Proposed no-magic-numbers option: ignoreJSXNumbers (fixes [#5348](https://github.com/eslint/eslint/issues/5348)) (Brandon Beeks)
* [0547072](https://github.com/eslint/eslint/commit/0547072) Update: Replace getLast() with lodash.last() (fixes [#5456](https://github.com/eslint/eslint/issues/5456)) (Jordan Eldredge)
* [4a67b9a](https://github.com/eslint/eslint/commit/4a67b9a) Update: Add ES7 support (fixes [#5401](https://github.com/eslint/eslint/issues/5401)) (Brandon Mills)
* [4f82b2b](https://github.com/eslint/eslint/commit/4f82b2b) Update: Support classes in `padded-blocks` (fixes [#5092](https://github.com/eslint/eslint/issues/5092)) (alberto)
* [70e3a02](https://github.com/eslint/eslint/commit/70e3a02) Update: Allow string severity in config (fixes [#3626](https://github.com/eslint/eslint/issues/3626)) (Nicholas C. Zakas)
* [13c7c19](https://github.com/eslint/eslint/commit/13c7c19) Update: Exclude ES5 constructors from consistent-return (fixes [#5379](https://github.com/eslint/eslint/issues/5379)) (Kevin Locke)
* [6280b2d](https://github.com/eslint/eslint/commit/6280b2d) Update: Support switch statements in padded-blocks (fixes [#5056](https://github.com/eslint/eslint/issues/5056)) (alberto)
* [8f6c2e7](https://github.com/eslint/eslint/commit/8f6c2e7) Update: Better error message for plugins (refs [#5221](https://github.com/eslint/eslint/issues/5221)) (Nicholas C. Zakas)
* [972d41b](https://github.com/eslint/eslint/commit/972d41b) Update: Improve error message for rule-tester (fixes [#5369](https://github.com/eslint/eslint/issues/5369)) (Jeroen Engels)
* [1f9fd10](https://github.com/eslint/eslint/commit/1f9fd10) Update: no-invalid-regexp allows custom flags (fixes [#5249](https://github.com/eslint/eslint/issues/5249)) (Afnan Fahim)
* [6aa2380](https://github.com/eslint/eslint/commit/6aa2380) Update: prefer-const; change modified to reassigned (fixes [#5350](https://github.com/eslint/eslint/issues/5350)) (Michiel de Bruijne)




## Bug Fixes


* [50f4d5a](https://github.com/eslint/eslint/commit/50f4d5a) Fix: extends chain (fixes [#5411](https://github.com/eslint/eslint/issues/5411)) (Toru Nagashima)
* [1da2420](https://github.com/eslint/eslint/commit/1da2420) Fix: crash when SourceCode object was reused (fixes [#5007](https://github.com/eslint/eslint/issues/5007)) (Toru Nagashima)
* [e1bbe45](https://github.com/eslint/eslint/commit/e1bbe45) Fix: Check space after anonymous generator star (fixes [#5435](https://github.com/eslint/eslint/issues/5435)) (alberto)
* [905c049](https://github.com/eslint/eslint/commit/905c049) Fix: `no-undef` false positive at new.target (fixes [#5420](https://github.com/eslint/eslint/issues/5420)) (Toru Nagashima)
* [de0a4ef](https://github.com/eslint/eslint/commit/de0a4ef) Fix: `getFormatter` throws an error when called as static (fixes [#5378](https://github.com/eslint/eslint/issues/5378)) (cowchimp)
* [78f7ca9](https://github.com/eslint/eslint/commit/78f7ca9) Fix: Prevent crash from swallowing console.log (fixes [#5381](https://github.com/eslint/eslint/issues/5381)) (Ian VanSchooten)
* [34b648d](https://github.com/eslint/eslint/commit/34b648d) Fix: remove tests which have invalid syntax (fixes [#5405](https://github.com/eslint/eslint/issues/5405)) (Toru Nagashima)
* [cf14c71](https://github.com/eslint/eslint/commit/cf14c71) Fix: `no-useless-constructor` rule crashes sometimes (fixes [#5290](https://github.com/eslint/eslint/issues/5290)) (Burak Yigit Kaya)
* [784d3bf](https://github.com/eslint/eslint/commit/784d3bf) Fix: Location info in `dot-notation` rule (fixes [#5397](https://github.com/eslint/eslint/issues/5397)) (Gyandeep Singh)
* [25a5b2c](https://github.com/eslint/eslint/commit/25a5b2c) Fix: Allow irregular whitespace in comments (fixes [#5368](https://github.com/eslint/eslint/issues/5368)) (Christophe Porteneuve)
* [c5bb478](https://github.com/eslint/eslint/commit/c5bb478) Fix: `constructor-super` false positive after a loop (fixes [#5394](https://github.com/eslint/eslint/issues/5394)) (Toru Nagashima)
* [1170e67](https://github.com/eslint/eslint/commit/1170e67) Fix: indent rule doesn't handle constructor instantiation (fixes [#5384](https://github.com/eslint/eslint/issues/5384)) (Nate Cavanaugh)
* [6bc9932](https://github.com/eslint/eslint/commit/6bc9932) Fix: Avoid magic numbers in rule options (fixes [#4182](https://github.com/eslint/eslint/issues/4182)) (Brandon Beeks)
* [694e1c1](https://github.com/eslint/eslint/commit/694e1c1) Fix: Add tests to cover default magic number tests (fixes [#5385](https://github.com/eslint/eslint/issues/5385)) (Brandon Beeks)
* [0b5349d](https://github.com/eslint/eslint/commit/0b5349d) Fix: .eslintignore paths should be absolute (fixes [#5362](https://github.com/eslint/eslint/issues/5362)) (alberto)
* [fe3f6bd](https://github.com/eslint/eslint/commit/fe3f6bd) Fix: `no-self-assign` false positive at shorthand (fixes [#5371](https://github.com/eslint/eslint/issues/5371)) (Toru Nagashima)
* [f1eab9b](https://github.com/eslint/eslint/commit/f1eab9b) Fix: Support for dash and slash in `valid-jsdoc` (fixes [#1598](https://github.com/eslint/eslint/issues/1598)) (Gyandeep Singh)
* [cd12a4b](https://github.com/eslint/eslint/commit/cd12a4b) Fix:`newline-per-chained-call` should only warn on methods (fixes [#5289](https://github.com/eslint/eslint/issues/5289)) (Burak Yigit Kaya)
* [d1d62c6](https://github.com/eslint/eslint/commit/d1d62c6) Fix: indent check for else keyword with Stroustrup style (fixes [#5218](https://github.com/eslint/eslint/issues/5218)) (Gyandeep Singh)
* [1c347f5](https://github.com/eslint/eslint/commit/1c347f5) Fix: Cleanup temp files from tests (fixes [#5338](https://github.com/eslint/eslint/issues/5338)) (Nick)




## Documentation


* [63c0b7d](https://github.com/eslint/eslint/commit/63c0b7d) Docs: Fix incorrect environment ref. in Rules in Plugins. (fixes [#5421](https://github.com/eslint/eslint/issues/5421)) (Jesse McCarthy)
* [0d3831b](https://github.com/eslint/eslint/commit/0d3831b) Docs: Add RuleTester parserOptions migration steps (Kevin Partington)
* [8c29946](https://github.com/eslint/eslint/commit/8c29946) Docs: Distinguish examples in rules under Possible Errors part 1 (Mark Pedrotti)
* [5319b4a](https://github.com/eslint/eslint/commit/5319b4a) Docs: Distinguish examples in rules under Possible Errors part 2 (Mark Pedrotti)
* [119e0ed](https://github.com/eslint/eslint/commit/119e0ed) Docs: Distinguish examples in rules under Variables (Mark Pedrotti)
* [89c757d](https://github.com/eslint/eslint/commit/89c757d) Docs: Replace ecmaFeatures with parserOptions in working-with-rules (Kevin Partington)
* [804c08e](https://github.com/eslint/eslint/commit/804c08e) Docs: Add parserOptions to RuleTester section of working-with-rules (Kevin Partington)
* [1982c50](https://github.com/eslint/eslint/commit/1982c50) Docs: Document string option for `no-unused-vars`. (alberto)
* [ed5564f](https://github.com/eslint/eslint/commit/ed5564f) Docs: Specify results of `no-unused-var` with `args` (fixes [#5334](https://github.com/eslint/eslint/issues/5334)) (chinesedfan)
* [7de5ae4](https://github.com/eslint/eslint/commit/7de5ae4) Docs: Missing allow option in  docs (Scott O'Hara)
* [6c0c4aa](https://github.com/eslint/eslint/commit/6c0c4aa) Docs: Add Issue template (fixes [#5313](https://github.com/eslint/eslint/issues/5313)) (Kai Cataldo)
* [2376291](https://github.com/eslint/eslint/commit/2376291) Docs: Missing space in `no-fallthrough` doc. (alberto)
* [5aedb87](https://github.com/eslint/eslint/commit/5aedb87) Docs: Add mysticatea as reviewer (Nicholas C. Zakas)
* [0d1377d](https://github.com/eslint/eslint/commit/0d1377d) Docs: Add missing `symbol` type into valid list (Plusb Preco)
* [36f40c2](https://github.com/eslint/eslint/commit/36f40c2) Docs: Achieve consistent order of h2 in rule pages (Mark Pedrotti)






## Build Related


* [124c447](https://github.com/eslint/eslint/commit/124c447) Build: Add additional linebreak to docs (fixes [#5464](https://github.com/eslint/eslint/issues/5464)) (Ilya Volodin)
* [7932f78](https://github.com/eslint/eslint/commit/7932f78) Build: Fix commit message validation (fixes [#5340](https://github.com/eslint/eslint/issues/5340)) (Nicholas C. Zakas)
* [2f3e1ae](https://github.com/eslint/eslint/commit/2f3e1ae) Build: Change rules to warnings in perf test (fixes [#5330](https://github.com/eslint/eslint/issues/5330)) (Brandon Mills)
