---
layout: post
title: ESLint v2.0.0-rc.0 released
teaser: "We just pushed ESLint v2.0.0-rc.0, which is a preview release upgrade of ESLint. As such, we have duplicated some of the content from the previous blog posts to make it easier to understand the differences between v1.10.3 and this version."
image: release-notes-beta.png
tags:
  - release
  - major
authors:
  - nzakas
categories:
  - Release Notes
---

**Note:** This version of ESLint is not ready for production use and is provided to gather feedback from the community before releasing the final version. Please let us know if you having any problems or feedback by [creating issues](https://github.com/eslint/eslint/issues/new?body=I%27m%20using%20ESLint%20v2.0.0-rc.0%20and%20I%20(have%20some%20feedback%7Cfound%20a%20bug).%20I%20used%20this%20code%0A%0A(include%20full%20code)%0A%0Aand%20this%20configuration%0A%0A(include%20full%20configuration)%0A%0AAnd%20got%20this%20output%3A%0A%0A(include%20full%20ESLint%20output)%0A%0AI%20expected%20this%20instead%3A%0A%0A(describe%20what%20you%20thought%20should%20happen%20or%20what%20you%27d%20like%20to%20happen)).

## Highlights

This is a summary of the major changes you need to know about for this version of ESLint.

### Installing

Since this is a pre-release version, you will not automatically be upgraded by npm. You must specify the `next` tag when installing:

```
npm i eslint@next --save-dev
```

You can also specify the version directly:

```
npm i eslint@2.0.0-rc.0 --save-dev
```

### Migration Guide

As there are a lot of changes, we've created a [migration guide](/docs/2.0.0/user-guide/migrating-to-2.0.0) describing the changes in great detail along with the steps you should take to address them. Not all ESLint users will be affected by the changes, however, the changes are big enough that we recommend everyone read the migration thoroughly.

### Code Path Analysis

ESLint v2.0.0 formally introduces [code path analysis](/docs/2.0.0/developer-guide/code-path-analysis.html). While we've tried to make best guesses at how execution flowed through code, there were several instances where we just couldn't get everything correct. For instance, trying to guarantee that every code path contained a `return` statement. Fully implementing code path analysis means that we (and you, through custom rules) can now correctly understand how execution is proceeding through code. Several rules have been updated to make use of code path analysis, fixing some longtime bugs in existing rules. As a result, ESLint is even better at picking up certain types of errors.

## Configuration Cascading Changes

Prior to 2.0.0, if a directory contained both an `.eslintrc` file and a `package.json` file with ESLint configuration information, the settings from the two files would be merged together. In 2.0.0, only the settings from the `.eslintrc.*` file are used and the ones in `package.json` are ignored when both are present. Otherwise, `package.json` can still be used with ESLint configuration, but only if no other `.eslintrc.*` files are present.

Read more in the [migration guide](/docs/2.0.0/user-guide/migrating-to-2.0.0).

## Language Options

Prior to 2.0.0, the way to enable language options was by using `ecmaFeatures` in your configuration. In 2.0.0:

* The `ecmaFeatures` property is now under a top-level `parserOptions` property.
* All ECMAScript 6 `ecmaFeatures` flags have been removed in favor of a `ecmaVersion` property under `parserOptions` that can be set to 3, 5 (default), or 6.
* The `ecmaFeatures.modules` flag has been replaced by a `sourceType` property under `parserOptions` which can be set to `"script"` (default) or `"module"` for ES6 modules.

Read more in the [migration guide](/docs/2.0.0/user-guide/migrating-to-2.0.0).

## Plugin Changes

This version of ESLint introduces several changes to plugins (see [documentation](/docs/2.0.0/developer-guide/working-with-plugins) for details):

1. `rulesConfig` is no longer supported. We had received complaints from users who didn't know that plugins could automatically turn on certain rules, and that functionality doesn't make sense because ESLint rules are supposed to be off by default. As such, `rulesConfig` will no longer set rules to be on or off by default.
1. Plugins can now export environments. Environments are used to group global variables and parser options together, and now plugins can define custom environments.
1. Plugins can now export shareable configs. Instead of needing to have a separate package for a shareable config, they can be bundled directly with the plugin.

## Autoconfiguration

The `--init` option has been enhanced with a new ability: autoconfiguration. Now, in addition to answering a questionnaire or using a popular shareable config, you can also specify files to inspect to generate your configuration. This will create a configuration file that is based on the most common patterns found in your code.  Read more about this feature in [IanVS's blog post](http://devnull.guru/adding-eslint-to-your-project-is-easier-than-ever/).

## Shareable Config Changes

Shareable configs now evaluate both the `parser` and `extends` fields as relative to the location of the config file itself. So you can use relative paths in both fields, and references to npm packages first check the `node_modules` directory in the same directory as the shareable config.

## Unicode BOM Support

If your files use a Unicode BOM, ESLint now properly handles parsing and evaluating your code and won't get confused by its presence.

## Built-In Global Variables

Prior to 2.0.0, new global variables that were standardized as part of ES6 such as `Promise`, `Map`, `Set`, and `Symbol` were included in the built-in global environment. This could lead to potential issues when, for example, `no-undef` permitted use of the `Promise` constructor even in ES5 code where promises are unavailable. In 2.0.0, the built-in environment only includes the standard ES5 global variables, and the new ES6 global variables have been moved to the `es6` environment.

Read more in the [migration guide](/docs/2.0.0/user-guide/migrating-to-2.0.0).

## eslint:recommended Updated

We've updated the rules we recommend as a starting point. If you're extending `eslint:recommended`, then you should double-check your code after upgrading as there are new recommended rules (all of the added rules help identify errors, no stylistic rules were added).

## Removing `no-arrow-condition`, Adding `no-confusing-arrow`

In looking at our rules, we discovered that `no-arrow-condition` actually overlapped with `no-constant-condition`, so we have removed `no-arrow-condition` as a core rule. The `no-constant-condition` will pick up the same errors as `no-arrow-condition`.

There was an additional condition that had been part of `no-arrow-condition` incorrectly, which checked for the use of arrow functions in conditional expressions. This functionality is now in the `no-confusing-arrow` rule.

## New Visual Studio Formatter

We've added a new formatter called `visualstudio`, which formats the results into a format that Visual Studio understands. If you use Visual Studio with ESLint, this new formatter makes the console output interactive, so you can click on a warning and be taken straight to the location in the file.

### New Rules

There are several new rules for this release:

* [`array-callback-return`](https://eslint.org/docs/2.0.0/rules/array-callback-return)
* [`id-blacklist`](https://eslint.org/docs/2.0.0/rules/id-blacklist)
* [`keyword-spacing`](https://eslint.org/docs/2.0.0/rules/keyword-spacing)
* [`newline-per-chained-call`](https://eslint.org/docs/2.0.0/rules/newline-per-chained-call)
* [`no-confusing-arrow`](https://eslint.org/docs/2.0.0/rules/no-confusing-arrow)
* [`no-extra-label`](https://eslint.org/docs/2.0.0/rules/no-extra-label)
* [`no-implicit-globals`](https://eslint.org/docs/2.0.0/rules/no-implicit-globals)
* [`no-new-symbol`](https://eslint.org/docs/2.0.0/rules/no-new-symbol)
* [`no-restricted-imports`](https://eslint.org/docs/2.0.0/rules/no-restricted-imports)
* [`no-self-assign`](https://eslint.org/docs/2.0.0/rules/no-self-assign)
* [`no-unmodified-loop-condition`](https://eslint.org/docs/2.0.0/rules/no-unmodified-loop-condition)
* [`no-unused-labels`](https://eslint.org/docs/2.0.0/rules/no-unused-labels)
* [`no-useless-constructor`](https://eslint.org/docs/2.0.0/rules/no-useless-constructor)
* [`no-whitespace-before-property`](https://eslint.org/docs/2.0.0/rules/no-whitespace-before-property)
* [`one-var-declaration-per-line`](https://eslint.org/docs/2.0.0/rules/one-var-declaration-per-line)
* [`prefer-rest-params`](https://eslint.org/docs/2.0.0/rules/prefer-rest-params)
* [`sort-imports`](https://eslint.org/docs/2.0.0/rules/sort-imports)
* [`template-curly-spacing`](https://eslint.org/docs/2.0.0/rules/template-curly-spacing)
* [`yield-star-spacing`](https://eslint.org/docs/2.0.0/rules/yield-star-spacing)


## Breaking Changes (v2.0.0-rc.0)


* [e64b2c2](https://github.com/eslint/eslint/commit/e64b2c2) Breaking: remove `no-empty-label` (fixes [#5042](https://github.com/eslint/eslint/issues/5042)) (Toru Nagashima)
* [79ebbc9](https://github.com/eslint/eslint/commit/79ebbc9) Breaking: update `eslint:recommended` (fixes [#5103](https://github.com/eslint/eslint/issues/5103)) (Toru Nagashima)

## Breaking Changes (v2.0.0-beta.3)


* [519f39f](https://github.com/eslint/eslint/commit/519f39f) Breaking: Remove deprecated rules (fixes [#5032](https://github.com/eslint/eslint/issues/5032)) (Gyandeep Singh)

## Breaking Changes (v2.0.0-beta.2)


* [b28a19d](https://github.com/eslint/eslint/commit/b28a19d) Breaking: Plugins envs and config removal (fixes [#4782](https://github.com/eslint/eslint/issues/4782), fixes [#4952](https://github.com/eslint/eslint/issues/4952)) (Nicholas C. Zakas)
* [3e6a24e](https://github.com/eslint/eslint/commit/3e6a24e) Breaking: Change `strict` default mode to "safe" (fixes [#4961](https://github.com/eslint/eslint/issues/4961)) (alberto)
* [5b96265](https://github.com/eslint/eslint/commit/5b96265) Breaking: Update eslint:recommended (fixes [#4953](https://github.com/eslint/eslint/issues/4953)) (alberto)
* [12fe803](https://github.com/eslint/eslint/commit/12fe803) Breaking: Supports Unicode BOM (fixes [#4878](https://github.com/eslint/eslint/issues/4878)) (Toru Nagashima)

## Breaking Changes (v2.0.0-beta.1)


* [19a9fbb](https://github.com/eslint/eslint/commit/19a9fbb) Breaking: `space-before-blocks` ignores after keywords (fixes [#1338](https://github.com/eslint/eslint/issues/1338)) (Toru Nagashima)
* [b795850](https://github.com/eslint/eslint/commit/b795850) Breaking: don't load ~/.eslintrc when using --config flag (fixes [#4881](https://github.com/eslint/eslint/issues/4881)) (alberto)
* [e2f2b66](https://github.com/eslint/eslint/commit/e2f2b66) Breaking: Remove defaults from `eslint:recommended` (fixes [#4809](https://github.com/eslint/eslint/issues/4809)) (Ian VanSchooten)
* [d43f26c](https://github.com/eslint/eslint/commit/d43f26c) Breaking: migrate from minimatch to node-ignore (fixes [#2365](https://github.com/eslint/eslint/issues/2365)) (Stefan Grönke)
* [c07ca39](https://github.com/eslint/eslint/commit/c07ca39) Breaking: merges keyword spacing rules (fixes [#3869](https://github.com/eslint/eslint/issues/3869)) (Toru Nagashima)

## Breaking Changes (v2.0.0-alpha-2)

* Breaking: deprecate `no-arrow-condition` rule (fixes [#4417](https://github.com/eslint/eslint/issues/4417)) (Luke Karrys)

## Breaking Changes (v2.0.0-alpha-1)

* Breaking: Correct links between variables and references (fixes [#4615](https://github.com/eslint/eslint/issues/4615)) (Toru Nagashima)
* Breaking: Implement parserOptions (fixes [#4641](https://github.com/eslint/eslint/issues/4641)) (Nicholas C. Zakas)
* Breaking: Remove space-after-keyword newline check (fixes [#4149](https://github.com/eslint/eslint/issues/4149)) (Nicholas C. Zakas)
* Breaking: Treat package.json like the rest of configs (fixes [#4451](https://github.com/eslint/eslint/issues/4451)) (Ilya Volodin)
* Breaking: Remove autofix from eqeqeq (fixes [#4578](https://github.com/eslint/eslint/issues/4578)) (Ilya Volodin)
* Breaking: Remove ES6 global variables from builtins (fixes [#4085](https://github.com/eslint/eslint/issues/4085)) (Brandon Mills)
* Breaking: Simplify rule schemas (fixes [#3625](https://github.com/eslint/eslint/issues/3625)) (Nicholas C. Zakas)
* Breaking: added bower_components to default ignore (fixes [#3550](https://github.com/eslint/eslint/issues/3550)) (Julian Laval)
* Breaking: Switch to Espree 3.0.0 (fixes [#4334](https://github.com/eslint/eslint/issues/4334)) (Nicholas C. Zakas)
* Breaking: Freeze context object (fixes [#4495](https://github.com/eslint/eslint/issues/4495)) (Nicholas C. Zakas)
* Breaking: Remove warnings of readonly from `no-undef` (fixes [#4504](https://github.com/eslint/eslint/issues/4504)) (Toru Nagashima)
* Breaking: Implement yield-star-spacing rule (fixes [#4115](https://github.com/eslint/eslint/issues/4115)) (Bryan Smith)
* Breaking: Default no-magic-numbers to none. (fixes [#4193](https://github.com/eslint/eslint/issues/4193)) (alberto)
* Breaking: Allow empty arrow body (fixes [#4411](https://github.com/eslint/eslint/issues/4411)) (alberto)




## Features (v2.0.0-rc.0)


* [e1d7368](https://github.com/eslint/eslint/commit/e1d7368) New: `no-extra-label` rule (fixes [#5059](https://github.com/eslint/eslint/issues/5059)) (Toru Nagashima)
* [e96ffd2](https://github.com/eslint/eslint/commit/e96ffd2) New: `template-curly-spacing` rule (fixes [#5049](https://github.com/eslint/eslint/issues/5049)) (Toru Nagashima)
* [1e791a2](https://github.com/eslint/eslint/commit/1e791a2) New: `no-self-assign` rule (fixes [#4729](https://github.com/eslint/eslint/issues/4729)) (Toru Nagashima)
* [b2aedfe](https://github.com/eslint/eslint/commit/b2aedfe) New: Rule to enforce newline after each call in the chain (fixes [#4538](https://github.com/eslint/eslint/issues/4538)) (Rajendra Patil)
* [d67bfdd](https://github.com/eslint/eslint/commit/d67bfdd) New: `no-unused-labels` rule (fixes [#5052](https://github.com/eslint/eslint/issues/5052)) (Toru Nagashima)

## Features (v2.0.0-beta.3)


* [4fea752](https://github.com/eslint/eslint/commit/4fea752) New: Autoconfiguration from source inspection (fixes [#3567](https://github.com/eslint/eslint/issues/3567)) (Ian VanSchooten)
* [c75ee4a](https://github.com/eslint/eslint/commit/c75ee4a) New: Add support for configs in plugins (fixes [#3659](https://github.com/eslint/eslint/issues/3659)) (Ilya Volodin)
* [79e8a0b](https://github.com/eslint/eslint/commit/79e8a0b) New: `one-var-declaration-per-line` rule (fixes [#1622](https://github.com/eslint/eslint/issues/1622)) (alberto)

## Features (v2.0.0-beta.2)


* [29392f8](https://github.com/eslint/eslint/commit/29392f8) New: allow-multiline option on comma-dangle (fixes [#4967](https://github.com/eslint/eslint/issues/4967)) (Alberto Gimeno)
* [8470474](https://github.com/eslint/eslint/commit/8470474) New: Add metadata to few test rules (fixes [#4494](https://github.com/eslint/eslint/issues/4494)) (Ilya Volodin)
* [5e4841e](https://github.com/eslint/eslint/commit/5e4841e) New: 'id-blacklist' rule (fixes [#3358](https://github.com/eslint/eslint/issues/3358)) (Keith Cirkel)
* [bbf7f27](https://github.com/eslint/eslint/commit/bbf7f27) New: provide config.parser via `parserName` on RuleContext (fixes [#3670](https://github.com/eslint/eslint/issues/3670)) (Ben Mosher)

## Features (v2.0.0-beta.1)


* [#d5c9435](https://github.com/eslint/eslint/commit/d5c9435) New: 'sort-imports' rule (refs [#3143](https://github.com/eslint/eslint/issues/3143)) (Christian Schuller)
* [ceaf324](https://github.com/eslint/eslint/commit/ceaf324) New: Add no-new-symbol rule (fixes [#4862](https://github.com/eslint/eslint/issues/4862)) (alberto)
* [4665256](https://github.com/eslint/eslint/commit/4665256) New: Add no-whitespace-before-property rule (fixes [#1086](https://github.com/eslint/eslint/issues/1086)) (Kai Cataldo)
* [5ab564e](https://github.com/eslint/eslint/commit/5ab564e) New: 'ignoreArrayIndexes' option for 'no-magic-numbers' (fixes [#4370](https://github.com/eslint/eslint/issues/4370)) (Christian Schuller)
* [97cdb95](https://github.com/eslint/eslint/commit/97cdb95) New: Add no-useless-constructor rule (fixes [#4785](https://github.com/eslint/eslint/issues/4785)) (alberto)

## Features (v2.0.0-alpha-2)

* New: `no-unmodified-loop-condition` rule (fixes [#4523](https://github.com/eslint/eslint/issues/4523)) (Toru Nagashima)
* New: Add a comment length option to the max-len rule (fixes [#4665](https://github.com/eslint/eslint/issues/4665)) (Ian)
* New: Add greasemonkey environment (fixes [#4715](https://github.com/eslint/eslint/issues/4715)) (silverwind)
* New: Add no-confusing-arrow rule (refs [#4417](https://github.com/eslint/eslint/issues/4417)) (Luke Karrys)
* New: Visual Studio compatible formatter (fixes [#4708](https://github.com/eslint/eslint/issues/4708)) (rhpijnacker)

## Features (v2.0.0-alpha-1)


* New: Add no-implicit-globals rule (fixes [#4542](https://github.com/eslint/eslint/issues/4542)) (Joshua Peek)
* New: `array-callback-return` rule (fixes [#1128](https://github.com/eslint/eslint/issues/1128)) (Toru Nagashima)
* New: Add no-restricted-imports rule (fixes [#3196](https://github.com/eslint/eslint/issues/3196)) (Guy Ellis)
* New: `prefer-rest-params` rule (fixes [#4108](https://github.com/eslint/eslint/issues/4108)) (Toru Nagashima)
* New: Code Path Analysis (fixes [#3530](https://github.com/eslint/eslint/issues/3530)) (Toru Nagashima)




## Enhancements (v2.0.0-rc.0)


* [4b02902](https://github.com/eslint/eslint/commit/4b02902) Update: Extended no-console rule (fixes [#5095](https://github.com/eslint/eslint/issues/5095)) (EricHenry)
* [3275e86](https://github.com/eslint/eslint/commit/3275e86) Update: Add extra aliases to consistent-this rule (fixes [#4492](https://github.com/eslint/eslint/issues/4492)) (Zachary Alexander Belford)

## Enhancements (v2.0.0-beta.3)


* [86a3e3d](https://github.com/eslint/eslint/commit/86a3e3d) Update: Remove blank lines at beginning of files (fixes [#5045](https://github.com/eslint/eslint/issues/5045)) (Jared Sohn)
* [bcca69b](https://github.com/eslint/eslint/commit/bcca69b) Update: add int32Hint option to `no-bitwise` rule (fixes [#4873](https://github.com/eslint/eslint/issues/4873)) (Maga D. Zandaqo)
* [e3f2683](https://github.com/eslint/eslint/commit/e3f2683) Update: config extends dependency lookup (fixes [#5023](https://github.com/eslint/eslint/issues/5023)) (Nicholas C. Zakas)
* [c1fad4f](https://github.com/eslint/eslint/commit/c1fad4f) Update: add autofix support for spaced-comment (fixes [#4969](https://github.com/eslint/eslint/issues/4969), fixes [#5030](https://github.com/eslint/eslint/issues/5030)) (Maga D. Zandaqo)
* [505f1a6](https://github.com/eslint/eslint/commit/505f1a6) Update: Allow parser to be relative to config (fixes [#4985](https://github.com/eslint/eslint/issues/4985)) (Nicholas C. Zakas)
* [654e6e1](https://github.com/eslint/eslint/commit/654e6e1) Update: Check extra Boolean calls in no-extra-boolean-cast (fixes [#3650](https://github.com/eslint/eslint/issues/3650)) (Andrew Sutton)

## Enhancements (v2.0.0-beta.2)


* [2b33c74](https://github.com/eslint/eslint/commit/2b33c74) Update: valid-jsdoc to not require @return in constructors (fixes [#4976](https://github.com/eslint/eslint/issues/4976)) (Maga D. Zandaqo)
* [05b8cb3](https://github.com/eslint/eslint/commit/05b8cb3) Update: Module overrides all 'strict' rule options (fixes [#4936](https://github.com/eslint/eslint/issues/4936)) (Nick Evans)
* [e0a9024](https://github.com/eslint/eslint/commit/e0a9024) Update: Report newline between template tag and literal (fixes [#4210](https://github.com/eslint/eslint/issues/4210)) (Rajendra Patil)
* [da3336c](https://github.com/eslint/eslint/commit/da3336c) Update: Rules should get `sourceType` from Program node (fixes [#4960](https://github.com/eslint/eslint/issues/4960)) (Nick Evans)
* [a2ac359](https://github.com/eslint/eslint/commit/a2ac359) Update: Make jsx-quotes fixable (refs [#4377](https://github.com/eslint/eslint/issues/4377)) (Gabriele Petronella)
* [700b8bc](https://github.com/eslint/eslint/commit/700b8bc) Update: Add "allow" option to allow specific operators (fixes [#3308](https://github.com/eslint/eslint/issues/3308)) (Rajendra Patil)
* [d82eeb1](https://github.com/eslint/eslint/commit/d82eeb1) Update: Add describe around rule tester blocks (fixes [#4907](https://github.com/eslint/eslint/issues/4907)) (Ilya Volodin)
* [2967402](https://github.com/eslint/eslint/commit/2967402) Update: Add minimum value to integer values in schema (fixes [#4941](https://github.com/eslint/eslint/issues/4941)) (Ilya Volodin)
* [b1360da](https://github.com/eslint/eslint/commit/b1360da) Update: Support multiLine and singleLine options (fixes [#4697](https://github.com/eslint/eslint/issues/4697)) (Rajendra Patil)
* [d487013](https://github.com/eslint/eslint/commit/d487013) Update: Option to allow extra parens for cond assign (fixes [#3317](https://github.com/eslint/eslint/issues/3317)) (alberto)
* [c2dee27](https://github.com/eslint/eslint/commit/c2dee27) Update: Add module tests to no-extra-semi (fixes [#4915](https://github.com/eslint/eslint/issues/4915)) (Nicholas C. Zakas)
* [5a633bf](https://github.com/eslint/eslint/commit/5a633bf) Update: Add `preferType` option to `valid-jsdoc` rule (fixes [#3056](https://github.com/eslint/eslint/issues/3056)) (Gyandeep Singh)

## Enhancements (v2.0.0-beta.1)


* [186e8f0](https://github.com/eslint/eslint/commit/186e8f0) Update: Ignore camelcase in object destructuring (fixes [#3185](https://github.com/eslint/eslint/issues/3185)) (alberto)
* [1569695](https://github.com/eslint/eslint/commit/1569695) Update: Adds default 'that' for consistent-this (fixes [#4833](https://github.com/eslint/eslint/issues/4833)) (alberto)
* [82d4cd9](https://github.com/eslint/eslint/commit/82d4cd9) Update: Add atomtest env (fixes [#4848](https://github.com/eslint/eslint/issues/4848)) (Andres Suarez)
* [9c9beb5](https://github.com/eslint/eslint/commit/9c9beb5) Update: Add "ignore" override for operator-linebreak (fixes [#4294](https://github.com/eslint/eslint/issues/4294)) (Rajendra Patil)
* [9c03abc](https://github.com/eslint/eslint/commit/9c03abc) Update: Add "allowCall" option (fixes [#4011](https://github.com/eslint/eslint/issues/4011)) (Rajendra Patil)
* [1288ba4](https://github.com/eslint/eslint/commit/1288ba4) Update: Add default limit to `complexity` (fixes [#4808](https://github.com/eslint/eslint/issues/4808)) (Ian VanSchooten)
* [5050768](https://github.com/eslint/eslint/commit/5050768) Update: Ask for `commonjs` under config init (fixes [#3553](https://github.com/eslint/eslint/issues/3553)) (Gyandeep Singh)
* [9ea6b36](https://github.com/eslint/eslint/commit/9ea6b36) Update: Ignore case in jsdoc tags (fixes [#4576](https://github.com/eslint/eslint/issues/4576)) (alberto)
* [4931f56](https://github.com/eslint/eslint/commit/4931f56) Update: optionally allow bitwise operators (fixes [#4742](https://github.com/eslint/eslint/issues/4742)) (Swaagie)

## Enhancements (v2.0.0-alpha-2)

* Update: Add "safe" mode to strict (fixes [#3306](https://github.com/eslint/eslint/issues/3306)) (Brandon Mills)
* Update: Add cwd option for cli-engine (fixes [#4472](https://github.com/eslint/eslint/issues/4472)) (Ilya Volodin)
* Update: Allow to omit semi for one-line blocks (fixes [#4385](https://github.com/eslint/eslint/issues/4385)) (alberto)
* Update: configuration for classes in space-before-blocks (fixes [#4089](https://github.com/eslint/eslint/issues/4089)) (alberto)
* Update: Implement auto fix for semi-spacing rule (fixes [#3829](https://github.com/eslint/eslint/issues/3829)) (alberto)
* Update: option to ignore top-level max statements (fixes [#4309](https://github.com/eslint/eslint/issues/4309)) (alberto)

## Enhancements (v2.0.0-alpha-1)

* Update: `no-use-before-define` checks invalid initializer (fixes [#4280](https://github.com/eslint/eslint/issues/4280)) (Toru Nagashima)
* Update: Add class body support to `indent` rule (fixes [#4372](https://github.com/eslint/eslint/issues/4372)) (Gyandeep Singh)
* Update: Add 'method' option to no-empty (fixes [#4605](https://github.com/eslint/eslint/issues/4605)) (Kai Cataldo)
* Update: Option to ignore constructor Fns object-shorthand (fixes [#4487](https://github.com/eslint/eslint/issues/4487)) (Kai Cataldo)
* Update: add class option to `no-use-before-define` (fixes [#3944](https://github.com/eslint/eslint/issues/3944)) (Toru Nagashima)
* Update: allowAfterThis option in no-underscore-dangle (fixes [#3435](https://github.com/eslint/eslint/issues/3435)) (just-boris)
* Update: `prefer-const` begins to cover separating init (fixes [#4474](https://github.com/eslint/eslint/issues/4474)) (Toru Nagashima)




## Bug Fixes (v2.0.0-rc.0)


* [973c499](https://github.com/eslint/eslint/commit/973c499) Fix: `sort-imports` crash (fixes [#5130](https://github.com/eslint/eslint/issues/5130)) (Toru Nagashima)
* [c83b48c](https://github.com/eslint/eslint/commit/c83b48c) Fix: find ignore file only in cwd (fixes [#5087](https://github.com/eslint/eslint/issues/5087)) (Nicholas C. Zakas)
* [c706eb9](https://github.com/eslint/eslint/commit/c706eb9) Fix: reduced `no-loop-func` false positive (fixes [#5044](https://github.com/eslint/eslint/issues/5044)) (Toru Nagashima)

## Bug Fixes (v2.0.0-beta.3)


* [361377f](https://github.com/eslint/eslint/commit/361377f) Fix: `prefer-const` false positive reading before writing (fixes [#5074](https://github.com/eslint/eslint/issues/5074)) (Toru Nagashima)
* [a327a06](https://github.com/eslint/eslint/commit/a327a06) Fix: Indent rule for allman brace style scenario (fixes [#5064](https://github.com/eslint/eslint/issues/5064)) (Gyandeep Singh)
* [afdff6d](https://github.com/eslint/eslint/commit/afdff6d) Fix: `no-extra-bind` false positive (fixes [#5058](https://github.com/eslint/eslint/issues/5058)) (Toru Nagashima)
* [b0f21a0](https://github.com/eslint/eslint/commit/b0f21a0) Fix: `keyword-spacing` false positive in template strings (fixes [#5043](https://github.com/eslint/eslint/issues/5043)) (Toru Nagashima)
* [53fa5d1](https://github.com/eslint/eslint/commit/53fa5d1) Fix: `prefer-const` false positive in a loop condition (fixes [#5024](https://github.com/eslint/eslint/issues/5024)) (Toru Nagashima)

## Bug Fixes (v2.0.0-beta.2)


* [b8fbaa0](https://github.com/eslint/eslint/commit/b8fbaa0) Fix: multiple message in TAP formatter (fixes [#4975](https://github.com/eslint/eslint/issues/4975)) (Simon Degraeve)
* [990f8da](https://github.com/eslint/eslint/commit/990f8da) Fix: `getNodeByRangeIndex` performance issue (fixes [#4989](https://github.com/eslint/eslint/issues/4989)) (Toru Nagashima)
* [5cd5429](https://github.com/eslint/eslint/commit/5cd5429) Fix: function expression doc in call expression (fixes [#4964](https://github.com/eslint/eslint/issues/4964)) (Tim Schaub)
* [4173baa](https://github.com/eslint/eslint/commit/4173baa) Fix: `no-dupe-class-members` false positive (fixes [#4981](https://github.com/eslint/eslint/issues/4981)) (Toru Nagashima)
* [ee1014d](https://github.com/eslint/eslint/commit/ee1014d) Fix: Incorrect error location for object-curly-spacing (fixes [#4957](https://github.com/eslint/eslint/issues/4957)) (alberto)
* [b52ed17](https://github.com/eslint/eslint/commit/b52ed17) Fix: Incorrect error location for space-in-parens (fixes [#4956](https://github.com/eslint/eslint/issues/4956)) (alberto)
* [9c1bafb](https://github.com/eslint/eslint/commit/9c1bafb) Fix: Columns of parse errors are off by 1 (fixes [#4896](https://github.com/eslint/eslint/issues/4896)) (alberto)
* [86e6e57](https://github.com/eslint/eslint/commit/86e6e57) Fix: Incorrect error at EOF for no-multiple-empty-lines (fixes [#4917](https://github.com/eslint/eslint/issues/4917)) (alberto)
* [7f058f3](https://github.com/eslint/eslint/commit/7f058f3) Fix: Incorrect location for padded-blocks (fixes [#4913](https://github.com/eslint/eslint/issues/4913)) (alberto)
* [b3de8f7](https://github.com/eslint/eslint/commit/b3de8f7) Fix: Do not show ignore messages for default ignored files (fixes [#4931](https://github.com/eslint/eslint/issues/4931)) (Gyandeep Singh)
* [0f469b4](https://github.com/eslint/eslint/commit/0f469b4) Fix: JSDoc for function expression on object property (fixes [#4900](https://github.com/eslint/eslint/issues/4900)) (Tim Schaub)
* [c4c4139](https://github.com/eslint/eslint/commit/c4c4139) Fix: global-require no longer warns if require is shadowed (fixes [#4812](https://github.com/eslint/eslint/issues/4812)) (Kevin Partington)

## Bug Fixes (v2.0.0-beta.1)


* [a8cfd56](https://github.com/eslint/eslint/commit/a8cfd56) Fix: remove duplicate of eslint-config-eslint (fixes [#4909](https://github.com/eslint/eslint/issues/4909)) (Toru Nagashima)
* [c275b41](https://github.com/eslint/eslint/commit/c275b41) Fix: no-extra-parens ExpressionStatement restricted prods (fixes [#4902](https://github.com/eslint/eslint/issues/4902)) (Michael Ficarra)
* [e5e06f8](https://github.com/eslint/eslint/commit/e5e06f8) Fix: Jsdoc comment for multi-line function expressions (fixes [#4889](https://github.com/eslint/eslint/issues/4889)) (Gyandeep Singh)
* [7c9be60](https://github.com/eslint/eslint/commit/7c9be60) Fix: Fix path errors in windows (fixes [#4888](https://github.com/eslint/eslint/issues/4888)) (Gyandeep Singh)
* [a1840e7](https://github.com/eslint/eslint/commit/a1840e7) Fix: gray text was invisible on Solarized Dark theme (fixes [#4886](https://github.com/eslint/eslint/issues/4886)) (Jack Leigh)
* [688f277](https://github.com/eslint/eslint/commit/688f277) Fix: Set proper exit code for Node > 0.10 (fixes [#4691](https://github.com/eslint/eslint/issues/4691)) (Nicholas C. Zakas)
* [58715e9](https://github.com/eslint/eslint/commit/58715e9) Fix: Use single quotes in context.report messages (fixes [#4845](https://github.com/eslint/eslint/issues/4845)) (Joe Lencioni)
* [5b7586b](https://github.com/eslint/eslint/commit/5b7586b) Fix: do not require a @return tag for @interface (fixes [#4860](https://github.com/eslint/eslint/issues/4860)) (Tim Schaub)
* [d3e8179](https://github.com/eslint/eslint/commit/d3e8179) Fix: env is rewritten by modules (fixes [#4814](https://github.com/eslint/eslint/issues/4814)) (Toru Nagashima)
* [315f272](https://github.com/eslint/eslint/commit/315f272) Fix: Change max-warnings type to Int (fixes [#4660](https://github.com/eslint/eslint/issues/4660)) (George Zahariev)
* [f500d7d](https://github.com/eslint/eslint/commit/f500d7d) Fix: allow extending @scope/eslint/file (fixes [#4800](https://github.com/eslint/eslint/issues/4800)) (André Cruz)
* [b9bcbaf](https://github.com/eslint/eslint/commit/b9bcbaf) Fix: Bug in no-extra-bind (fixes [#4806](https://github.com/eslint/eslint/issues/4806)) (Andres Kalle)
* [acdda24](https://github.com/eslint/eslint/commit/acdda24) Fix: ignore argument parens in no-unexpected-multiline (fixes [#4658](https://github.com/eslint/eslint/issues/4658)) (alberto)

## Bug Fixes (v2.0.0-alpha-2)

* Fix: `no-invalid-this` allows this in static method (fixes [#4669](https://github.com/eslint/eslint/issues/4669)) (Toru Nagashima)
* Fix: Add source property for fatal errors (fixes [#3325](https://github.com/eslint/eslint/issues/3325)) (Gyandeep Singh)
* Fix: always-multiline for comma-dangle import (fixes [#4704](https://github.com/eslint/eslint/issues/4704)) (Nicholas C. Zakas)
* Fix: Apply environment configs last (fixes [#3915](https://github.com/eslint/eslint/issues/3915)) (Nicholas C. Zakas)
* Fix: Backtick behavior in quotes rule (fixes [#3090](https://github.com/eslint/eslint/issues/3090)) (Nicholas C. Zakas)
* Fix: Check 1tbs non-block else (fixes [#4692](https://github.com/eslint/eslint/issues/4692)) (Nicholas C. Zakas)
* Fix: Comma first issue in `indent` (fixes [#4739](https://github.com/eslint/eslint/issues/4739), fixes [#3456](https://github.com/eslint/eslint/issues/3456)) (Gyandeep Singh)
* Fix: Empty schemas forbid any options (fixes [#4789](https://github.com/eslint/eslint/issues/4789)) (Brandon Mills)
* Fix: ensure `ConfigOps.merge` do a deep copy (fixes [#4682](https://github.com/eslint/eslint/issues/4682)) (Toru Nagashima)
* Fix: Export class syntax for `require-jsdoc` rule (fixes [#4667](https://github.com/eslint/eslint/issues/4667)) (Gyandeep Singh)
* Fix: Handle getters and setters in key-spacing (fixes [#4792](https://github.com/eslint/eslint/issues/4792)) (Brandon Mills)
* Fix: no-constant-condition false positive (fixes [#4737](https://github.com/eslint/eslint/issues/4737)) (alberto)
* Fix: ObjectRestSpread throws error in key-spacing rule (fixes [#4763](https://github.com/eslint/eslint/issues/4763)) (Ziad El Khoury Hanna)
* Fix: Remove `isMarkedAsUsed` function name (fixes [#4783](https://github.com/eslint/eslint/issues/4783)) (Gyandeep Singh)
* Fix: Remove path analysis from debug log (fixes [#4631](https://github.com/eslint/eslint/issues/4631)) (Ilya Volodin)
* Fix: RuleTester to show parsing errors (fixes [#4779](https://github.com/eslint/eslint/issues/4779)) (Nicholas C. Zakas)
* Fix: Set null to property ruleId when fatal is true (fixes [#4722](https://github.com/eslint/eslint/issues/4722)) (Sébastien Règne)
* Fix: small typos in code examples (Plusb Preco)
* Fix: support arrow functions in no-return-assign (fixes [#4743](https://github.com/eslint/eslint/issues/4743)) (alberto)


## Bug Fixes (v2.0.0-alpha-1)


* Fix: Update rule tests for parser options (fixes [#4673](https://github.com/eslint/eslint/issues/4673)) (Nicholas C. Zakas)
* Fix: max-len rule overestimates the width of some tabs (fixes [#4661](https://github.com/eslint/eslint/issues/4661)) (Nick Evans)
* Fix: Use oneValuePerFlag for --ignore-pattern option (fixes [#4507](https://github.com/eslint/eslint/issues/4507)) (George Zahariev)
* Fix: Handle forbidden LineTerminators in no-extra-parens (fixes [#4229](https://github.com/eslint/eslint/issues/4229)) (Brandon Mills)
* Fix: Check YieldExpression argument in no-extra-parens (fixes [#4608](https://github.com/eslint/eslint/issues/4608)) (Brandon Mills)
* Fix: Do not cache `package.json` (fixes [#4611](https://github.com/eslint/eslint/issues/4611)) (Spain)
* Fix: `consistent-return` checks the last (refs [#3530](https://github.com/eslint/eslint/issues/3530), fixes [#3373](https://github.com/eslint/eslint/issues/3373)) (Toru Nagashima)
* Fix: `no-unreachable` with the code path (refs [#3530](https://github.com/eslint/eslint/issues/3530), fixes [#3939](https://github.com/eslint/eslint/issues/3939)) (Toru Nagashima)
* Fix: `no-this-before-super` with the code path analysis (refs [#3530](https://github.com/eslint/eslint/issues/3530)) (Toru Nagashima)
* Fix: `no-fallthrough` with the code path analysis (refs [#3530](https://github.com/eslint/eslint/issues/3530)) (Toru Nagashima)
* Fix: `constructor-super` with the code path analysis (refs [#3530](https://github.com/eslint/eslint/issues/3530)) (Toru Nagashima)
* Fix: Adding options unit tests for --ignore-pattern (refs [#4507](https://github.com/eslint/eslint/issues/4507)) (Kevin Partington)
* Fix: `no-eval` come to catch indirect eval (fixes [#4399](https://github.com/eslint/eslint/issues/4399), fixes [#4441](https://github.com/eslint/eslint/issues/4441)) (Toru Nagashima)



## Documentation (v2.0.0-rc.0)


* [3a24240](https://github.com/eslint/eslint/commit/3a24240) Docs: Fix jsdoc param names to match function param names (Thanos Lefteris)
* [1d79746](https://github.com/eslint/eslint/commit/1d79746) Docs: Replace ecmaFeatures setting with link to config page (Thanos Lefteris)
* [757651e](https://github.com/eslint/eslint/commit/757651e) Docs: Remove reference to rules enabled by default (fixes [#5100](https://github.com/eslint/eslint/issues/5100)) (Brandon Mills)
* [0d87f5d](https://github.com/eslint/eslint/commit/0d87f5d) Docs: Clarify eslint-disable comments only affect rules (fixes [#5005](https://github.com/eslint/eslint/issues/5005)) (Brandon Mills)
* [a227360](https://github.com/eslint/eslint/commit/a227360) Docs: Replace joyent org with nodejs (Thanos Lefteris)

## Documentation (v2.0.0-beta.3)


* [889b942](https://github.com/eslint/eslint/commit/889b942) Revert "Docs: Update readme for legend describing rules icons (refs [#4355](https://github.com/eslint/eslint/issues/4355))" (Nicholas C. Zakas)
* [385d399](https://github.com/eslint/eslint/commit/385d399) Docs: Update readme for legend describing rules icons (Kai Cataldo)

## Documentation (v2.0.0-beta.2)


* [3fa834f](https://github.com/eslint/eslint/commit/3fa834f) Docs: Fix formatter links (fixes [#5006](https://github.com/eslint/eslint/issues/5006)) (Gyandeep Singh)
* [54b1bc8](https://github.com/eslint/eslint/commit/54b1bc8) Docs: Fix link in strict.md (fixes [#5026](https://github.com/eslint/eslint/issues/5026)) (Nick Evans)
* [69f149d](https://github.com/eslint/eslint/commit/69f149d) Docs: language tweaks (Andres Kalle)
* [6ac2e01](https://github.com/eslint/eslint/commit/6ac2e01) Docs: Fix description of exported comment (Mickael Jeanroy)
* [ba11c1b](https://github.com/eslint/eslint/commit/ba11c1b) Docs: Add Algolia as sponsor to README (Nicholas C. Zakas)
* [a456077](https://github.com/eslint/eslint/commit/a456077) Docs: newline-after-var doesn't allow invalid options. (alberto)
* [82fbe09](https://github.com/eslint/eslint/commit/82fbe09) Docs: Small semantic issue in documentation example (fixes [#4937](https://github.com/eslint/eslint/issues/4937)) (Marcelo Zarate)
* [13a4e30](https://github.com/eslint/eslint/commit/13a4e30) Docs: Formatting inconsistencies (fixes [#4912](https://github.com/eslint/eslint/issues/4912)) (alberto)
* [2d626a3](https://github.com/eslint/eslint/commit/2d626a3) Docs: Fix typo in changelog (Nicholas C. Zakas)

## Documentation (v2.0.0-beta.1)


* [6390862](https://github.com/eslint/eslint/commit/6390862) Docs: Fix missing footnote (Yoshiya Hinosawa)
* [fc9f528](https://github.com/eslint/eslint/commit/fc9f528) Docs: Modify unnecessary flag docs in quote-props (Matija Marohnić)
* [0b3c01e](https://github.com/eslint/eslint/commit/0b3c01e) Docs: Specify default for func-style (fixes [#4834](https://github.com/eslint/eslint/issues/4834)) (Ian VanSchooten)
* [008ea39](https://github.com/eslint/eslint/commit/008ea39) Docs: Document default for operator assignment (fixes [#4835](https://github.com/eslint/eslint/issues/4835)) (alberto)
* [b566f56](https://github.com/eslint/eslint/commit/b566f56) Docs: no-new-func typo (alberto)
* [f7b28b7](https://github.com/eslint/eslint/commit/f7b28b7) Docs: clarify `requireReturn` option for valid-jsdoc rule (fixes [#4859](https://github.com/eslint/eslint/issues/4859)) (Tim Schaub)
* [29516f1](https://github.com/eslint/eslint/commit/29516f1) Docs: fix migration guide for no-arrow-condition rule (Peter Newnham)
* [2ef7549](https://github.com/eslint/eslint/commit/2ef7549) Docs: clarify remedy to some prefer-const errors (Turadg Aleahmad)
* [fd72aba](https://github.com/eslint/eslint/commit/fd72aba) Docs: Example fix for `no-extra-parens` rule (fixes [#3527](https://github.com/eslint/eslint/issues/3527)) (Gyandeep Singh)
* [246a6d2](https://github.com/eslint/eslint/commit/246a6d2) Docs: Documentation fix (Andres Kalle)

## Documentation (v2.0.0-alpha-2)

* Docs: Add license header to Working with Rules guide (Brandon Mills)
* Docs: Add section on file extensions to user-guide/configuring (adam)
* Docs: Escape underscores in no-path-concat (alberto)
* Docs: fix typos, suggests (molee1905)
* Docs: RuleTester doesn't require any tests (fixes [#4681](https://github.com/eslint/eslint/issues/4681)) (alberto)
* Docs: Typo in generator-star (alberto)
* Docs: Typo in no-unexpected-multiline (fixes [#4756](https://github.com/eslint/eslint/issues/4756)) (alberto)
* Docs: Typo in no-useless-concat (alberto)
* Docs: Typos in space-before-keywords and space-unary-ops (fixes [#4771](https://github.com/eslint/eslint/issues/4771)) (alberto)



## Documentation (v2.0.0-alpha-1)


* Docs: writing mistake (molee1905)
* Docs: no-extra-semi no longer refers to deprecated rule (fixes [#4598](https://github.com/eslint/eslint/issues/4598)) (Kevin Partington)
* Docs: Update docs/rules/no-plusplus.md (Xiangyun Chi)
* Docs: Add Code of Conduct (fixes [#3095](https://github.com/eslint/eslint/issues/3095)) (Nicholas C. Zakas)





## Dependency Upgrades (v2.0.0-beta.2)


* [e0c5cf7](https://github.com/eslint/eslint/commit/e0c5cf7) Upgrade: Espree to 3.0.0 (fixes [#5018](https://github.com/eslint/eslint/issues/5018)) (Ilya Volodin)
* [7457a4e](https://github.com/eslint/eslint/commit/7457a4e) Upgrade: glob to 6.x (fixes [#4991](https://github.com/eslint/eslint/issues/4991)) (Gyandeep Singh)
* [7b632f8](https://github.com/eslint/eslint/commit/7b632f8) Upgrade: Globals to ^8.18.0 (fixes [#4728](https://github.com/eslint/eslint/issues/4728)) (Gyandeep Singh)

## Dependency Upgrades (v2.0.0-beta.1)


* [7c97201](https://github.com/eslint/eslint/commit/7c97201) Upgrade: doctrine version to 1.1.0 (fixes [#4854](https://github.com/eslint/eslint/issues/4854)) (Tim Schaub)
* [871f534](https://github.com/eslint/eslint/commit/871f534) Upgrade: Optionator version to 0.8.1 (fixes [#4851](https://github.com/eslint/eslint/issues/4851)) (Eric Johnson)

## Dependency Upgrades (v2.0.0-alpha-2)

* Upgrade: beefy to ^2.0.0, fixes installation errors (fixes [#4760](https://github.com/eslint/eslint/issues/4760)) (Kai Cataldo)

## Dependency Upgrades (v2.0.0-alpha-1)

* Upgrade: Handlebars to >= 4.0.5 for security reasons (fixes [#4642](https://github.com/eslint/eslint/issues/4642)) (Jacques Favreau)




## Build Related (v2.0.0-beta.3)


* [ff2551d](https://github.com/eslint/eslint/commit/ff2551d) Build: Improve `npm run perf` command (fixes [#5028](https://github.com/eslint/eslint/issues/5028)) (Toru Nagashima)


## Build Related (v2.0.0-beta.2)


* [d3f4bdd](https://github.com/eslint/eslint/commit/d3f4bdd) Build: Cleanup for code coverage (fixes [#4983](https://github.com/eslint/eslint/issues/4983)) (Gyandeep Singh)
* [8ac1dac](https://github.com/eslint/eslint/commit/8ac1dac) Build: Update markdownlint dependency to 0.1.0 (fixes [#4988](https://github.com/eslint/eslint/issues/4988)) (David Anson)
* [1fc80e9](https://github.com/eslint/eslint/commit/1fc80e9) Build: Increment eslint-config-eslint (Nicholas C. Zakas)
* [ebd01b7](https://github.com/eslint/eslint/commit/ebd01b7) Build: Fix version number on release (fixes [#4921](https://github.com/eslint/eslint/issues/4921)) (Nicholas C. Zakas)

## Build Related (v2.0.0-beta.1)


* [6c70d84](https://github.com/eslint/eslint/commit/6c70d84) Build: Fix prerelease script (fixes [#4919](https://github.com/eslint/eslint/issues/4919)) (Nicholas C. Zakas)
* [3906481](https://github.com/eslint/eslint/commit/3906481) Build: Add AppVeyor CI (fixes [#4894](https://github.com/eslint/eslint/issues/4894)) (Gyandeep Singh)
* [407f329](https://github.com/eslint/eslint/commit/407f329) Build: Fix prerelease script (Nicholas C. Zakas)


## Build-Related (v2.0.0-alpha-2)

* Build: Add prerelease script (Nicholas C. Zakas)

## Build Related (v2.0.0-alpha-1)

* Build: Consume no-underscore-dangle allowAfterThis option (fixes [#4599](https://github.com/eslint/eslint/issues/4599)) (Kevin Partington)
