---
layout: post
title: ESLint v2.0.0-alpha-2 released
teaser: "We just pushed ESLint v2.0.0-alpha-2, which is a preview release upgrade of ESLint. As such, we have duplicated some of the content from the v2.0.0-alpha-1 announcement to make it easier to understand the differences between v1.10.3 and this version."
image: release-notes-beta.png
tags:
  - release
  - major
authors:
  - nzakas
categories:
  - Release Notes
---

**Note:** This version of ESLint is not ready for production use and is provided to gather feedback from the community before releasing the final version. Please let us know if you having any problems or feedback by [creating issues](https://github.com/eslint/eslint/issues/new?body=I%27m%20using%20ESLint%20v2.0.0-alpha-2%20and%20I%20(have%20some%20feedback%7Cfound%20a%20bug).%20I%20used%20this%20code%0A%0A(include%20full%20code)%0A%0Aand%20this%20configuration%0A%0A(include%20full%20configuration)%0A%0AAnd%20got%20this%20output%3A%0A%0A(include%20full%20ESLint%20output)%0A%0AI%20expected%20this%20instead%3A%0A%0A(describe%20what%20you%20thought%20should%20happen%20or%20what%20you%27d%20like%20to%20happen)).

## Highlights

This is a summary of the major changes you need to know about for this version of ESLint.

### Installing

Since this is a pre-release version, you will not automatically be upgraded by npm. You must specify the `next` tag when installing:

```
npm i eslint@next --save-dev
```

You can also specify the version directly:

```
npm i eslint@2.0.0-alpha-2 --save-dev
```

### Code Path Analysis

ESLint v2.0.0 formally introduces [code path analysis](/docs/2.0.0/developer-guide/code-path-analysis.html). While we've tried to make best guesses at how execution flowed through code, there were several instances where we just couldn't get everything correct. For instance, trying to guarantee that every code path contained a `return` statement. Fully implementing code path analysis means that we (and you, through custom rules) can now correctly understand how execution is proceeding through code. Several rules have been updated to make use of code path analysis, fixing some longtime bugs in existing rules. As a result, ESLint is even better at picking up certain types of errors.

### Migration Guide

As there are a lot of changes, we've created a [migration guide](/docs/2.0.0/user-guide/migrating-to-2.0.0) describing the changes in great detail along with the steps you should take to address them. Not all ESLint users will be affected by the changes, however, the changes are big enough that we recommend everyone read the migration thoroughly.

## Configuration Cascading Changes

Prior to 2.0.0, if a directory contained both an `.eslintrc` file and a `package.json` file with ESLint configuration information, the settings from the two files would be merged together. In 2.0.0, only the settings from the `.eslintrc.*` file are used and the ones in `package.json` are ignored when both are present. Otherwise, `package.json` can still be used with ESLint configuration, but only if no other `.eslintrc.*` files are present.

Read more in the [migration guide](/docs/2.0.0/user-guide/migrating-to-2.0.0).

## Language Options

Prior to 2.0.0, the way to enable language options was by using `ecmaFeatures` in your configuration. In 2.0.0:

* The `ecmaFeatures` property is now under a top-level `parserOptions` property.
* All ECMAScript 6 `ecmaFeatures` flags have been removed in favor of a `ecmaVersion` property under `parserOptions` that can be set to 3, 5 (default), or 6.
* The `ecmaFeatures.modules` flag has been replaced by a `sourceType` property under `parserOptions` which can be set to `"script"` (default) or `"module"` for ES6 modules.

Read more in the [migration guide](/docs/2.0.0/user-guide/migrating-to-2.0.0).

## Built-In Global Variables

Prior to 2.0.0, new global variables that were standardized as part of ES6 such as `Promise`, `Map`, `Set`, and `Symbol` were included in the built-in global environment. This could lead to potential issues when, for example, `no-undef` permitted use of the `Promise` constructor even in ES5 code where promises are unavailable. In 2.0.0, the built-in environment only includes the standard ES5 global variables, and the new ES6 global variables have been moved to the `es6` environment.

Read more in the [migration guide](/docs/2.0.0/user-guide/migrating-to-2.0.0).

## Removing `no-arrow-condition`, Adding `no-confusing-arrow`

In looking at our rules, we discovered that `no-arrow-condition` actually overlapped with `no-constant-condition`, so we have removed `no-arrow-condition` as a core rule. The `no-constant-condition` will pick up the same errors as `no-arrow-condition`.

There was an additional condition that had been part of `no-arrow-condition` incorrectly, which checked for the use of arrow functions in conditional expressions. This functionality is now in the `no-confusing-arrow` rule.

## New Visual Studio Formatter

We've added a new formatter called `visualstudio`, which formats the results into a format that Visual Studio understands. If you use Visual Studio with ESLint, this new formatter makes the console output interactive, so you can click on a warning and be taken straight to the location in the file.

### New Rules

There are several new rules for this release:

* [`array-callback-return`](https://eslint.org/docs/2.0.0/rules/array-callback-return)
* [`no-implicit-globals`](https://eslint.org/docs/2.0.0/rules/no-implicit-globals)
* [`no-restricted-imports`](https://eslint.org/docs/2.0.0/rules/no-restricted-imports)
* [`prefer-rest-params`](https://eslint.org/docs/2.0.0/rules/prefer-rest-params)
* [`yield-star-spacing`](https://eslint.org/docs/2.0.0/rules/yield-star-spacing)
* [`no-unmodified-loop-condition`](https://eslint.org/docs/2.0.0/rules/no-unmodified-loop-condition)
* [`no-confusing-arrow`](https://eslint.org/docs/2.0.0/rules/no-confusing-arrow)

## Breaking Changes (v2.0.0-alpha-2)

* Breaking: deprecate `no-arrow-condition` rule (fixes [#4417](https://github.com/eslint/eslint/issues/4417)) (Luke Karrys)

## Breaking Changes (v2.0.0-alpha-1)

* Breaking: Correct links between variables and references (fixes [#4615](https://github.com/eslint/eslint/issues/4615)) (Toru Nagashima)
* Breaking: Implement parserOptions (fixes [#4641](https://github.com/eslint/eslint/issues/4641)) (Nicholas C. Zakas)
* Breaking: Remove space-after-keyword newline check (fixes [#4149](https://github.com/eslint/eslint/issues/4149)) (Nicholas C. Zakas)
* Breaking: Treat package.json like the rest of configs (fixes [#4451](https://github.com/eslint/eslint/issues/4451)) (Ilya Volodin)
* Breaking: Remove autofix from eqeqeq (fixes [#4578](https://github.com/eslint/eslint/issues/4578)) (Ilya Volodin)
* Breaking: Remove ES6 global variables from builtins (fixes [#4085](https://github.com/eslint/eslint/issues/4085)) (Brandon Mills)
* Breaking: Simplify rule schemas (fixes [#3625](https://github.com/eslint/eslint/issues/3625)) (Nicholas C. Zakas)
* Breaking: added bower_components to default ignore (fixes [#3550](https://github.com/eslint/eslint/issues/3550)) (Julian Laval)
* Breaking: Switch to Espree 3.0.0 (fixes [#4334](https://github.com/eslint/eslint/issues/4334)) (Nicholas C. Zakas)
* Breaking: Freeze context object (fixes [#4495](https://github.com/eslint/eslint/issues/4495)) (Nicholas C. Zakas)
* Breaking: Remove warnings of readonly from `no-undef` (fixes [#4504](https://github.com/eslint/eslint/issues/4504)) (Toru Nagashima)
* Breaking: Implement yield-star-spacing rule (fixes [#4115](https://github.com/eslint/eslint/issues/4115)) (Bryan Smith)
* Breaking: Default no-magic-numbers to none. (fixes [#4193](https://github.com/eslint/eslint/issues/4193)) (alberto)
* Breaking: Allow empty arrow body (fixes [#4411](https://github.com/eslint/eslint/issues/4411)) (alberto)

## Features (v2.0.0-alpha-2)

* New: `no-unmodified-loop-condition` rule (fixes [#4523](https://github.com/eslint/eslint/issues/4523)) (Toru Nagashima)
* New: Add a comment length option to the max-len rule (fixes [#4665](https://github.com/eslint/eslint/issues/4665)) (Ian)
* New: Add greasemonkey environment (fixes [#4715](https://github.com/eslint/eslint/issues/4715)) (silverwind)
* New: Add no-confusing-arrow rule (refs [#4417](https://github.com/eslint/eslint/issues/4417)) (Luke Karrys)
* New: Visual Studio compatible formatter (fixes [#4708](https://github.com/eslint/eslint/issues/4708)) (rhpijnacker)

## Features (v2.0.0-alpha-1)


* New: Add no-implicit-globals rule (fixes [#4542](https://github.com/eslint/eslint/issues/4542)) (Joshua Peek)
* New: `array-callback-return` rule (fixes [#1128](https://github.com/eslint/eslint/issues/1128)) (Toru Nagashima)
* New: Add no-restricted-imports rule (fixes [#3196](https://github.com/eslint/eslint/issues/3196)) (Guy Ellis)
* New: `prefer-rest-params` rule (fixes [#4108](https://github.com/eslint/eslint/issues/4108)) (Toru Nagashima)
* New: Code Path Analysis (fixes [#3530](https://github.com/eslint/eslint/issues/3530)) (Toru Nagashima)




## Enhancements (v2.0.0-alpha-2)

* Update: Add "safe" mode to strict (fixes [#3306](https://github.com/eslint/eslint/issues/3306)) (Brandon Mills)
* Update: Add cwd option for cli-engine (fixes [#4472](https://github.com/eslint/eslint/issues/4472)) (Ilya Volodin)
* Update: Allow to omit semi for one-line blocks (fixes [#4385](https://github.com/eslint/eslint/issues/4385)) (alberto)
* Update: configuration for classes in space-before-blocks (fixes [#4089](https://github.com/eslint/eslint/issues/4089)) (alberto)
* Update: Implement auto fix for semi-spacing rule (fixes [#3829](https://github.com/eslint/eslint/issues/3829)) (alberto)
* Update: option to ignore top-level max statements (fixes [#4309](https://github.com/eslint/eslint/issues/4309)) (alberto)

## Enhancements (v2.0.0-alpha-1)

* Update: `no-use-before-define` checks invalid initializer (fixes [#4280](https://github.com/eslint/eslint/issues/4280)) (Toru Nagashima)
* Update: Add class body support to `indent` rule (fixes [#4372](https://github.com/eslint/eslint/issues/4372)) (Gyandeep Singh)
* Update: Add 'method' option to no-empty (fixes [#4605](https://github.com/eslint/eslint/issues/4605)) (Kai Cataldo)
* Update: Option to ignore constructor Fns object-shorthand (fixes [#4487](https://github.com/eslint/eslint/issues/4487)) (Kai Cataldo)
* Update: add class option to `no-use-before-define` (fixes [#3944](https://github.com/eslint/eslint/issues/3944)) (Toru Nagashima)
* Update: allowAfterThis option in no-underscore-dangle (fixes [#3435](https://github.com/eslint/eslint/issues/3435)) (just-boris)
* Update: `prefer-const` begins to cover separating init (fixes [#4474](https://github.com/eslint/eslint/issues/4474)) (Toru Nagashima)


## Bug Fixes (v2.0.0-alpha-2)

* Fix: `no-invalid-this` allows this in static method (fixes [#4669](https://github.com/eslint/eslint/issues/4669)) (Toru Nagashima)
* Fix: Add source property for fatal errors (fixes [#3325](https://github.com/eslint/eslint/issues/3325)) (Gyandeep Singh)
* Fix: always-multiline for comma-dangle import (fixes [#4704](https://github.com/eslint/eslint/issues/4704)) (Nicholas C. Zakas)
* Fix: Apply environment configs last (fixes [#3915](https://github.com/eslint/eslint/issues/3915)) (Nicholas C. Zakas)
* Fix: Backtick behavior in quotes rule (fixes [#3090](https://github.com/eslint/eslint/issues/3090)) (Nicholas C. Zakas)
* Fix: Check 1tbs non-block else (fixes [#4692](https://github.com/eslint/eslint/issues/4692)) (Nicholas C. Zakas)
* Fix: Comma first issue in `indent` (fixes [#4739](https://github.com/eslint/eslint/issues/4739), fixes [#3456](https://github.com/eslint/eslint/issues/3456)) (Gyandeep Singh)
* Fix: Empty schemas forbid any options (fixes [#4789](https://github.com/eslint/eslint/issues/4789)) (Brandon Mills)
* Fix: ensure `ConfigOps.merge` do a deep copy (fixes [#4682](https://github.com/eslint/eslint/issues/4682)) (Toru Nagashima)
* Fix: Export class syntax for `require-jsdoc` rule (fixes [#4667](https://github.com/eslint/eslint/issues/4667)) (Gyandeep Singh)
* Fix: Handle getters and setters in key-spacing (fixes [#4792](https://github.com/eslint/eslint/issues/4792)) (Brandon Mills)
* Fix: no-constant-condition false positive (fixes [#4737](https://github.com/eslint/eslint/issues/4737)) (alberto)
* Fix: ObjectRestSpread throws error in key-spacing rule (fixes [#4763](https://github.com/eslint/eslint/issues/4763)) (Ziad El Khoury Hanna)
* Fix: Remove `isMarkedAsUsed` function name (fixes [#4783](https://github.com/eslint/eslint/issues/4783)) (Gyandeep Singh)
* Fix: Remove path analysis from debug log (fixes [#4631](https://github.com/eslint/eslint/issues/4631)) (Ilya Volodin)
* Fix: RuleTester to show parsing errors (fixes [#4779](https://github.com/eslint/eslint/issues/4779)) (Nicholas C. Zakas)
* Fix: Set null to property ruleId when fatal is true (fixes [#4722](https://github.com/eslint/eslint/issues/4722)) (Sébastien Règne)
* Fix: small typos in code examples (Plusb Preco)
* Fix: support arrow functions in no-return-assign (fixes [#4743](https://github.com/eslint/eslint/issues/4743)) (alberto)


## Bug Fixes (v2.0.0-alpha-1)


* Fix: Update rule tests for parser options (fixes [#4673](https://github.com/eslint/eslint/issues/4673)) (Nicholas C. Zakas)
* Fix: max-len rule overestimates the width of some tabs (fixes [#4661](https://github.com/eslint/eslint/issues/4661)) (Nick Evans)
* Fix: Use oneValuePerFlag for --ignore-pattern option (fixes [#4507](https://github.com/eslint/eslint/issues/4507)) (George Zahariev)
* Fix: Handle forbidden LineTerminators in no-extra-parens (fixes [#4229](https://github.com/eslint/eslint/issues/4229)) (Brandon Mills)
* Fix: Check YieldExpression argument in no-extra-parens (fixes [#4608](https://github.com/eslint/eslint/issues/4608)) (Brandon Mills)
* Fix: Do not cache `package.json` (fixes [#4611](https://github.com/eslint/eslint/issues/4611)) (Spain)
* Fix: `consistent-return` checks the last (refs [#3530](https://github.com/eslint/eslint/issues/3530), fixes [#3373](https://github.com/eslint/eslint/issues/3373)) (Toru Nagashima)
* Fix: `no-unreachable` with the code path (refs [#3530](https://github.com/eslint/eslint/issues/3530), fixes [#3939](https://github.com/eslint/eslint/issues/3939)) (Toru Nagashima)
* Fix: `no-this-before-super` with the code path analysis (refs [#3530](https://github.com/eslint/eslint/issues/3530)) (Toru Nagashima)
* Fix: `no-fallthrough` with the code path analysis (refs [#3530](https://github.com/eslint/eslint/issues/3530)) (Toru Nagashima)
* Fix: `constructor-super` with the code path analysis (refs [#3530](https://github.com/eslint/eslint/issues/3530)) (Toru Nagashima)
* Fix: Adding options unit tests for --ignore-pattern (refs [#4507](https://github.com/eslint/eslint/issues/4507)) (Kevin Partington)
* Fix: `no-eval` come to catch indirect eval (fixes [#4399](https://github.com/eslint/eslint/issues/4399), fixes [#4441](https://github.com/eslint/eslint/issues/4441)) (Toru Nagashima)

## Documentation (v2.0.0-alpha-2)

* Docs: Add license header to Working with Rules guide (Brandon Mills)
* Docs: Add section on file extensions to user-guide/configuring (adam)
* Docs: Escape underscores in no-path-concat (alberto)
* Docs: fix typos, suggests (molee1905)
* Docs: RuleTester doesn't require any tests (fixes [#4681](https://github.com/eslint/eslint/issues/4681)) (alberto)
* Docs: Typo in generator-star (alberto)
* Docs: Typo in no-unexpected-multiline (fixes [#4756](https://github.com/eslint/eslint/issues/4756)) (alberto)
* Docs: Typo in no-useless-concat (alberto)
* Docs: Typos in space-before-keywords and space-unary-ops (fixes [#4771](https://github.com/eslint/eslint/issues/4771)) (alberto)



## Documentation (v2.0.0-alpha-1)


* Docs: writing mistake (molee1905)
* Docs: no-extra-semi no longer refers to deprecated rule (fixes [#4598](https://github.com/eslint/eslint/issues/4598)) (Kevin Partington)
* Docs: Update docs/rules/no-plusplus.md (Xiangyun Chi)
* Docs: Add Code of Conduct (fixes [#3095](https://github.com/eslint/eslint/issues/3095)) (Nicholas C. Zakas)


## Dependency Upgrades (v2.0.0-alpha-2)

* Upgrade: beefy to ^2.0.0, fixes installation errors (fixes [#4760](https://github.com/eslint/eslint/issues/4760)) (Kai Cataldo)

## Dependency Upgrades (v2.0.0-alpha-1)

* Upgrade: Handlebars to >= 4.0.5 for security reasons (fixes [#4642](https://github.com/eslint/eslint/issues/4642)) (Jacques Favreau)

## Build-Related (v2.0.0-alpha-2)

* Build: Add prerelease script (Nicholas C. Zakas)

## Build Related (v2.0.0-alpha-1)

* Build: Consume no-underscore-dangle allowAfterThis option (fixes [#4599](https://github.com/eslint/eslint/issues/4599)) (Kevin Partington)
