---
layout: post
title: ESLint v2.0.0-alpha-1 released
teaser: "We just pushed ESLint v2.0.0-alpha-1, which is a preview release upgrade of ESLint. This release adds some new features, including some breaking changes, and fixes several bugs found in the previous release."
image: release-notes-beta.png
tags:
  - release
  - major
authors:
  - nzakas
categories:
  - Release Notes
---

**Note:** This version of ESLint is not ready for production use and is provided to gather feedback from the community before releasing the final version. Please let us know if you having any problems or feedback by [creating issues](https://github.com/eslint/eslint/issues/new?body=I%27m%20using%20ESLint%20v2.0.0-alpha-1%20and%20I%20(have%20some%20feedback%7Cfound%20a%20bug).%20I%20used%20this%20code%0A%0A(include%20full%20code)%0A%0Aand%20this%20configuration%0A%0A(include%20full%20configuration)%0A%0AAnd%20got%20this%20output%3A%0A%0A(include%20full%20ESLint%20output)%0A%0AI%20expected%20this%20instead%3A%0A%0A(describe%20what%20you%20thought%20should%20happen%20or%20what%20you%27d%20like%20to%20happen)).

## Highlights

This is a summary of the major changes you need to know about for this version of ESLint.

### Installing

Since this is a pre-release version, you will not automatically be upgraded by npm. You must specify the `next` tag when installing:

```
npm i eslint@next --save-dev
```

You can also specify the version directly:

```
npm i eslint@2.0.0-alpha-1 --save-dev
```

### Code Path Analysis

ESLint v2.0.0 formally introduces [code path analysis](/docs/2.0.0/developer-guide/code-path-analysis.html). While we've tried to make best guesses at how execution flowed through code, there were several instances where we just couldn't get everything correct. For instance, trying to guarantee that every code path contained a `return` statement. Fully implementing code path analysis means that we (and you, through custom rules) can now correctly understand how execution is proceeding through code. Several rules have been updated to make use of code path analysis, fixing some longtime bugs in existing rules. As a result, ESLint is even better at picking up certain types of errors.

### Migration Guide

As there are a lot of changes, we've created a [migration guide](/docs/2.0.0/user-guide/migrating-to-2.0.0) describing the changes in great detail along with the steps you should take to address them. Not all ESLint users will be affected by the changes, however, the changes are big enough that we recommend everyone read the migration thoroughly.

## Configuration Cascading Changes

Prior to 2.0.0, if a directory contained both an `.eslintrc` file and a `package.json` file with ESLint configuration information, the settings from the two files would be merged together. In 2.0.0, only the settings from the `.eslintrc.*` file are used and the ones in `package.json` are ignored when both are present. Otherwise, `package.json` can still be used with ESLint configuration, but only if no other `.eslintrc.*` files are present.

Read more in the [migration guide](/docs/2.0.0/user-guide/migrating-to-2.0.0).

## Language Options

Prior to 2.0.0, the way to enable language options was by using `ecmaFeatures` in your configuration. In 2.0.0:

* The `ecmaFeatures` property is now under a top-level `parserOptions` property.
* All ECMAScript 6 `ecmaFeatures` flags have been removed in favor of a `ecmaVersion` property under `parserOptions` that can be set to 3, 5 (default), or 6.
* The `ecmaFeatures.modules` flag has been replaced by a `sourceType` property under `parserOptions` which can be set to `"script"` (default) or `"module"` for ES6 modules.

Read more in the [migration guide](/docs/2.0.0/user-guide/migrating-to-2.0.0).

## Built-In Global Variables

Prior to 2.0.0, new global variables that were standardized as part of ES6 such as `Promise`, `Map`, `Set`, and `Symbol` were included in the built-in global environment. This could lead to potential issues when, for example, `no-undef` permitted use of the `Promise` constructor even in ES5 code where promises are unavailable. In 2.0.0, the built-in environment only includes the standard ES5 global variables, and the new ES6 global variables have been moved to the `es6` environment.

Read more in the [migration guide](/docs/2.0.0/user-guide/migrating-to-2.0.0).

### New Rules

There are several new rules for this release:

* [`array-callback-return`](https://eslint.org/docs/2.0.0/rules/array-callback-return)
* [`no-implicit-globals`](https://eslint.org/docs/2.0.0/rules/no-implicit-globals)
* [`no-restricted-imports`](https://eslint.org/docs/2.0.0/rules/no-restricted-imports)
* [`prefer-rest-params`](https://eslint.org/docs/2.0.0/rules/prefer-rest-params)
* [`yield-star-spacing`](https://eslint.org/docs/2.0.0/rules/yield-star-spacing)


## Breaking Changes


* Breaking: Correct links between variables and references (fixes [#4615](https://github.com/eslint/eslint/issues/4615)) (Toru Nagashima)
* Breaking: Implement parserOptions (fixes [#4641](https://github.com/eslint/eslint/issues/4641)) (Nicholas C. Zakas)
* Breaking: Remove space-after-keyword newline check (fixes [#4149](https://github.com/eslint/eslint/issues/4149)) (Nicholas C. Zakas)
* Breaking: Treat package.json like the rest of configs (fixes [#4451](https://github.com/eslint/eslint/issues/4451)) (Ilya Volodin)
* Breaking: Remove autofix from eqeqeq (fixes [#4578](https://github.com/eslint/eslint/issues/4578)) (Ilya Volodin)
* Breaking: Remove ES6 global variables from builtins (fixes [#4085](https://github.com/eslint/eslint/issues/4085)) (Brandon Mills)
* Breaking: Simplify rule schemas (fixes [#3625](https://github.com/eslint/eslint/issues/3625)) (Nicholas C. Zakas)
* Breaking: added bower_components to default ignore (fixes [#3550](https://github.com/eslint/eslint/issues/3550)) (Julian Laval)
* Breaking: Switch to Espree 3.0.0 (fixes [#4334](https://github.com/eslint/eslint/issues/4334)) (Nicholas C. Zakas)
* Breaking: Freeze context object (fixes [#4495](https://github.com/eslint/eslint/issues/4495)) (Nicholas C. Zakas)
* Breaking: Remove warnings of readonly from `no-undef` (fixes [#4504](https://github.com/eslint/eslint/issues/4504)) (Toru Nagashima)
* Breaking: Implement yield-star-spacing rule (fixes [#4115](https://github.com/eslint/eslint/issues/4115)) (Bryan Smith)
* Breaking: Default no-magic-numbers to none. (fixes [#4193](https://github.com/eslint/eslint/issues/4193)) (alberto)
* Breaking: Allow empty arrow body (fixes [#4411](https://github.com/eslint/eslint/issues/4411)) (alberto)




## Features


* New: Add no-implicit-globals rule (fixes [#4542](https://github.com/eslint/eslint/issues/4542)) (Joshua Peek)
* New: `array-callback-return` rule (fixes [#1128](https://github.com/eslint/eslint/issues/1128)) (Toru Nagashima)
* New: Add no-restricted-imports rule (fixes [#3196](https://github.com/eslint/eslint/issues/3196)) (Guy Ellis)
* New: `prefer-rest-params` rule (fixes [#4108](https://github.com/eslint/eslint/issues/4108)) (Toru Nagashima)
* New: Code Path Analysis (fixes [#3530](https://github.com/eslint/eslint/issues/3530)) (Toru Nagashima)




## Enhancements


* Update: `no-use-before-define` checks invalid initializer (fixes [#4280](https://github.com/eslint/eslint/issues/4280)) (Toru Nagashima)
* Update: Add class body support to `indent` rule (fixes [#4372](https://github.com/eslint/eslint/issues/4372)) (Gyandeep Singh)
* Update: Add 'method' option to no-empty (fixes [#4605](https://github.com/eslint/eslint/issues/4605)) (Kai Cataldo)
* Update: Option to ignore constructor Fns object-shorthand (fixes [#4487](https://github.com/eslint/eslint/issues/4487)) (Kai Cataldo)
* Update: add class option to `no-use-before-define` (fixes [#3944](https://github.com/eslint/eslint/issues/3944)) (Toru Nagashima)
* Update: allowAfterThis option in no-underscore-dangle (fixes [#3435](https://github.com/eslint/eslint/issues/3435)) (just-boris)
* Update: `prefer-const` begins to cover separating init (fixes [#4474](https://github.com/eslint/eslint/issues/4474)) (Toru Nagashima)




## Bug Fixes


* Fix: Update rule tests for parser options (fixes [#4673](https://github.com/eslint/eslint/issues/4673)) (Nicholas C. Zakas)
* Fix: max-len rule overestimates the width of some tabs (fixes [#4661](https://github.com/eslint/eslint/issues/4661)) (Nick Evans)
* Fix: Use oneValuePerFlag for --ignore-pattern option (fixes [#4507](https://github.com/eslint/eslint/issues/4507)) (George Zahariev)
* Fix: Handle forbidden LineTerminators in no-extra-parens (fixes [#4229](https://github.com/eslint/eslint/issues/4229)) (Brandon Mills)
* Fix: Check YieldExpression argument in no-extra-parens (fixes [#4608](https://github.com/eslint/eslint/issues/4608)) (Brandon Mills)
* Fix: Do not cache `package.json` (fixes [#4611](https://github.com/eslint/eslint/issues/4611)) (Spain)
* Fix: `consistent-return` checks the last (refs [#3530](https://github.com/eslint/eslint/issues/3530), fixes [#3373](https://github.com/eslint/eslint/issues/3373)) (Toru Nagashima)
* Fix: `no-unreachable` with the code path (refs [#3530](https://github.com/eslint/eslint/issues/3530), fixes [#3939](https://github.com/eslint/eslint/issues/3939)) (Toru Nagashima)
* Fix: `no-this-before-super` with the code path analysis (refs [#3530](https://github.com/eslint/eslint/issues/3530)) (Toru Nagashima)
* Fix: `no-fallthrough` with the code path analysis (refs [#3530](https://github.com/eslint/eslint/issues/3530)) (Toru Nagashima)
* Fix: `constructor-super` with the code path analysis (refs [#3530](https://github.com/eslint/eslint/issues/3530)) (Toru Nagashima)
* Fix: Adding options unit tests for --ignore-pattern (refs [#4507](https://github.com/eslint/eslint/issues/4507)) (Kevin Partington)
* Fix: `no-eval` come to catch indirect eval (fixes [#4399](https://github.com/eslint/eslint/issues/4399), fixes [#4441](https://github.com/eslint/eslint/issues/4441)) (Toru Nagashima)




## Documentation


* Docs: writing mistake (molee1905)
* Docs: no-extra-semi no longer refers to deprecated rule (fixes [#4598](https://github.com/eslint/eslint/issues/4598)) (Kevin Partington)
* Docs: Update docs/rules/no-plusplus.md (Xiangyun Chi)
* Docs: Add Code of Conduct (fixes [#3095](https://github.com/eslint/eslint/issues/3095)) (Nicholas C. Zakas)




## Dependency Upgrades


* Upgrade: Handlebars to >= 4.0.5 for security reasons (fixes [#4642](https://github.com/eslint/eslint/issues/4642)) (Jacques Favreau)




## Build Related


* Build: Consume no-underscore-dangle allowAfterThis option (fixes [#4599](https://github.com/eslint/eslint/issues/4599)) (Kevin Partington)
