---
layout: post
title: ESLint v1.10.0 released
teaser: "We just pushed ESLint v1.10.0, which is a minor release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - nzakas
categories:
  - Release Notes
---

**Note:** This is the last scheduled release prior to v2.0.0. In the coming weeks, we will be focusing specifically on v2.0.0 and will be regularly releasing alpha versions for testing. These alpha versions *are not* suitable for use in a production environment and are provided primarily for getting early feedback.

## Highlights

Here are some highlights of changes in this release.

### Configuration File Formats

v1.10.0 introduces the ability to use configuration files in different formats. Instead of the regular `.eslintrc` file, you can use a JavaScript (`.eslintrc.js`), a YAML file (`.eslintrc.yml` or `.eslintrc.yaml`), or a JSON file (`.eslintrc.json`). We are formally deprecating use of the `.eslintrc` extensionless configuration file format in favor the format-specific versions. Don't worry, we'll still support `.eslintrc` files for a long time, but we'd like to encourage everyone to move to the new file formats as you'll get advantages such as syntax highlighting and error detection with many editors. Read more in the [documentation](https://eslint.org/docs/user-guide/configuring#configuration-file-formats).

### Improvements to --init

The `--init` command, which is used to bootstrap a configuration file, now has an additional option: use a popular style guide. When running `--init`, you can still choose to answer the questionnaire we've always had, or you can choose to use the Google, Airbnb, or Standard style guides. The correct shareable config will automatically be installed in your project when using one of these style guides. We will look to add more popular style guides as the shareable configs become available.

Additionally, `--init` will now create a configuration file in one of the new formats. It will ask you which format you prefer and will generate the file in that format.

### Disabling Inline Configurations

The new [`--no-inline-config`](https://eslint.org/docs/user-guide/command-line-interface.html#no-inline-config) command makes ESLint skip all inline configuration comments (such as `/*eslint semi:2*/`) so that you can only configure ESLint uses the command line and configuration files.





## Features


* New: Disable comment config option (fixes [#3901](https://github.com/eslint/eslint/issues/3901)) (Matthew Riley MacPherson)
* New: Config files with extensions (fixes [#4045](https://github.com/eslint/eslint/issues/4045), fixes [#4263](https://github.com/eslint/eslint/issues/4263)) (Nicholas C. Zakas)




## Enhancements


* Update: --init to create extensioned files (fixes [#4476](https://github.com/eslint/eslint/issues/4476)) (Nicholas C. Zakas)
* Update: Add class support to `require-jsdoc` rule (fixes [#4268](https://github.com/eslint/eslint/issues/4268)) (Gyandeep Singh)
* Update: return type error in `valid-jsdoc` rule (fixes [#4443](https://github.com/eslint/eslint/issues/4443)) (Gyandeep Singh)
* Update: Display errors at the place where fix should go (fixes [#4470](https://github.com/eslint/eslint/issues/4470)) (nightwing)
* Update: Accept array for `ignorePattern` (fixes [#3982](https://github.com/eslint/eslint/issues/3982)) (Jesse McCarthy)
* Update: replace label and break with IIFE and return (fixes [#4459](https://github.com/eslint/eslint/issues/4459)) (Ilya Panasenko)
* Update: Allow empty arrow body (fixes [#4411](https://github.com/eslint/eslint/issues/4411)) (alberto)
* Update: Refactor eslint.verify args (fixes [#4395](https://github.com/eslint/eslint/issues/4395)) (Nicholas C. Zakas)
* Update: Add Popular Style Guides (fixes [#4320](https://github.com/eslint/eslint/issues/4320)) (Jamund Ferguson)
* Update: no-implicit-coercion validate AssignmentExpression (fixes [#4348](https://github.com/eslint/eslint/issues/4348)) (Ilya Panasenko)




## Bug Fixes


* Fix: Handle comments in block-spacing (fixes [#4387](https://github.com/eslint/eslint/issues/4387)) (alberto)
* Fix: space-before-keywords false positive (fixes [#4449](https://github.com/eslint/eslint/issues/4449)) (alberto)
* Fix: Improves performance (refs [#3530](https://github.com/eslint/eslint/issues/3530)) (Toru Nagashima)
* Fix: Autofix quotes produces invalid javascript (fixes [#4380](https://github.com/eslint/eslint/issues/4380)) (nightwing)
* Fix: `no-extend-native` crashed at empty defineProperty (fixes [#4438](https://github.com/eslint/eslint/issues/4438)) (Toru Nagashima)
* Fix: Support empty if blocks in lines-around-comment (fixes [#4339](https://github.com/eslint/eslint/issues/4339)) (alberto)
* Fix: `curly` warns wrong location for `else` (fixes [#4362](https://github.com/eslint/eslint/issues/4362)) (Toru Nagashima)
* Fix: `id-length` properties never option (fixes [#4347](https://github.com/eslint/eslint/issues/4347)) (Toru Nagashima)
* Fix: eqeqeq autofix avoids clashes with space-infix-ops (fixes [#4423](https://github.com/eslint/eslint/issues/4423)) (Kevin Partington)
* Fix: Handle comments in comma-spacing (fixes [#4389](https://github.com/eslint/eslint/issues/4389)) (alberto)
* Fix: no-undef-init should ignore const (fixes [#4284](https://github.com/eslint/eslint/issues/4284)) (Nicholas C. Zakas)
* Fix: Add the missing "as-needed" docs to the radix rule (fixes [#4364](https://github.com/eslint/eslint/issues/4364)) (Michał Gołębiowski)
* Fix: Display singular/plural version of "line" in message (fixes [#4359](https://github.com/eslint/eslint/issues/4359)) (Marius Schulz)
* Fix: eslint.report can be called w/o node if loc provided (fixes [#4220](https://github.com/eslint/eslint/issues/4220)) (Kevin Partington)




## Documentation


* Docs: Remove dupes from changelog (Nicholas C. Zakas)
* Docs: Update description of exported comment (fixes [#3916](https://github.com/eslint/eslint/issues/3916)) (Nicholas C. Zakas)
* Docs: Move legacy rules to stylistic (files [#4111](https://github.com/eslint/eslint/issues/4111)) (Nicholas C. Zakas)
* Docs: Clean up description of recommended rules (fixes [#4365](https://github.com/eslint/eslint/issues/4365)) (Nicholas C. Zakas)
* Docs: Fix home directory config description (fixes [#4398](https://github.com/eslint/eslint/issues/4398)) (Nicholas C. Zakas)
* Docs: Fix typo in default `cacheLocation` value (Andrew Hutchings)
* Docs: Update indent.md (Nathan Brown)
* Docs: Replace link to deprecated rule with newer rule (Andrew Marshall)
* Docs: missing close rbracket in example (@storkme)
* Docs: Document semi-spacing behaviour (fixes [#4404](https://github.com/eslint/eslint/issues/4404)) (alberto)
