---
layout: post
title: ESLint v1.9.0 released
teaser: "We just pushed ESLint v1.9.0, which is a minor release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - nzakas
categories:
  - Release Notes
---

## Highlights

Here are some highlights of changes in this release.

### New Rules

* [`no-case-declarations`](https://eslint.org/docs/rules/no-case-declarations)

### Better npm 3 Support

Due to the changes in dependency management in npm 3, some users were getting errors when attempting to run ESLint. We've updated our dependencies and ESLint should now work correctly for users of npm 3.


## Features


* New: Add no-case-declarations rule (fixes [#4278](https://github.com/eslint/eslint/issues/4278)) (Erik Arvidsson)




## Enhancements


* Update: Make radix accept a "as-needed" option (fixes [#4048](https://github.com/eslint/eslint/issues/4048)) (Michał Gołębiowski)
* Update: Add default to `max-nested-callbacks` (fixes [#4297](https://github.com/eslint/eslint/issues/4297)) (alberto)
* Update: Add quotes to error messages to improve clarity (fixes [#4313](https://github.com/eslint/eslint/issues/4313)) (alberto)
* Update: Extract glob and filesystem logic from cli-engine (fixes [#4305](https://github.com/eslint/eslint/issues/4305)) (Ian VanSchooten)
* Update: Detect and fix wrong linebreaks (fixes [#3981](https://github.com/eslint/eslint/issues/3981)) (alberto)




## Bug Fixes


* Fix: Update the message to include number of lines (fixes [#4342](https://github.com/eslint/eslint/issues/4342)) (Brian Delahunty)
* Fix: Fixer to not overlap ranges among fix objects (fixes [#4321](https://github.com/eslint/eslint/issues/4321)) (Gyandeep Singh)
* Fix: Check comments in space-in-parens (fixes [#4302](https://github.com/eslint/eslint/issues/4302)) (alberto)
* Fix: tests failing due to differences in temporary paths (fixes [#4324](https://github.com/eslint/eslint/issues/4324)) (alberto)
* Fix: Make tests compatible with Windows (fixes [#4315](https://github.com/eslint/eslint/issues/4315)) (Ian VanSchooten)
* Fix: ensure using correct estraverse (fixes [#3951](https://github.com/eslint/eslint/issues/3951)) (Toru Nagashima)




## Documentation


* Docs: ASI causes problem whether semicolons are used or not (Thai Pangsakulyanont)
* Docs: update docs about using gitignore (Mateusz Derks)




## Dependency Upgrades


* Upgrade: Upgrade various dependencies (fixes [#4303](https://github.com/eslint/eslint/issues/4303)) (Gyandeep Singh)




## Build Related


* Build: Clarify commit-check messages (fixes [#4256](https://github.com/eslint/eslint/issues/4256)) (Ian VanSchooten)
* Build: Add node 5 to travis build (fixes [#4310](https://github.com/eslint/eslint/issues/4310)) (Gyandeep Singh)
