---
layout: post
title: ESLint v1.8.0 released
teaser: "We just pushed ESLint v1.8.0, which is a minor release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - nzakas
categories:
  - Release Notes
---

## Highlights

Here are some highlights of changes in this release.

### New Rules

* [`no-arrow-condition`](https://eslint.org/docs/rules/no-arrow-condition)
* [`arrow-body-style`](https://eslint.org/docs/rules/arrow-body-style)

### Autofixing

The following rules have been updated to include autofixing:

* [`comma-spacing`](https://eslint.org/docs/rules/comma-spacing)

### Caching Enhancements

If you've been using the `--cache` feature, it will now optionally create a directory for your cache instead of a file. This change means that it's possible to use a single cache for every project you work on rather than one cache per project.

To facilitate this change, we are deprecating `--cache-file` in favor of `--cache-location`, which can accept either a file path or a directory (be sure to include the trailing slash to indicate a directory). The `--cache-file` flag will be removed in v2.0.0.

Read more in the [documentation](https://eslint.org/docs/user-guide/command-line-interface#caching).

### RuleTester Enhancement

The `RuleTester` just got a bit smarter. It will now verify that the AST was not modified during execution of a rule. This was added as it's possible for rules to accidentally modify the AST during execution, and that modification can negatively affect other rules. The `RuleTester` will now fail any test that modifies the AST.


## Features


* New: Add rule no-arrow-condition (fixes [#3280](https://github.com/eslint/eslint/issues/3280)) (Luke Karrys)
* New: arrow-body-style rule (fixes [#4109](https://github.com/eslint/eslint/issues/4109)) (alberto)




## Enhancements


* Update: Add support for class in `valid-jsdoc` rule (fixes [#4279](https://github.com/eslint/eslint/issues/4279)) (Gyandeep Singh)
* Update: cache-file accepts a directory. (fixes [#4241](https://github.com/eslint/eslint/issues/4241)) (royriojas)
* Update: Add `maxEOF` to no-multiple-empty-lines (fixes [#4235](https://github.com/eslint/eslint/issues/4235)) (Adrien Vergé)
* Update: fix option for comma-spacing (fixes [#4232](https://github.com/eslint/eslint/issues/4232)) (HIPP Edgar (PRESTA EXT))
* Update: RuleTester come to check AST was not modified (fixes [#4156](https://github.com/eslint/eslint/issues/4156)) (Toru Nagashima)
* Update: Add `allow` option to `no-shadow` rule (fixes [#3035](https://github.com/eslint/eslint/issues/3035)) (Gyandeep Singh)
* Update: Option to exclude afterthoughts from no-plusplus (fixes [#4093](https://github.com/eslint/eslint/issues/4093)) (Brody McKee)
* Update: Add linebreak style option to eol-last (fixes [#4148](https://github.com/eslint/eslint/issues/4148)) (alberto)




## Bug Fixes


* Fix: Check for node property before testing type (fixes [#4298](https://github.com/eslint/eslint/issues/4298)) (Ian VanSchooten)
* Fix: Missing errors in space-in-parens (fixes [#4257](https://github.com/eslint/eslint/issues/4257), fixes [#3996](https://github.com/eslint/eslint/issues/3996)) (alberto)
* Fix: `cacheLocation` handles paths in windows style. (fixes [#4285](https://github.com/eslint/eslint/issues/4285)) (royriojas)
* Fix: Prepare config before verifying SourceCode (fixes [#4230](https://github.com/eslint/eslint/issues/4230)) (Ian VanSchooten)
* Fix: wrong count for 'no-multiple-empty-lines' on last line (fixes [#4228](https://github.com/eslint/eslint/issues/4228)) (alberto)
* Fix: Check node exists before checking type (fixes [#4231](https://github.com/eslint/eslint/issues/4231)) (Ian VanSchooten)




## Documentation


* Docs: Specify 'double' as default for quotes (fixes [#4270](https://github.com/eslint/eslint/issues/4270)) (Ian VanSchooten)
* Docs: fixed typo (Mathieu M-Gosselin)
* Docs: fixed typo (mpal9000)
* Docs: Fix use of wrong word in configuration doc (Jérémie Astori)
* Docs: Add alberto as a committer (Gyandeep Singh)






## Build Related


* Build: Do not stub console in testing (fixes [#1328](https://github.com/eslint/eslint/issues/1328)) (Gyandeep Singh)
