---
layout: post
title: ESLint v1.7.0 released
teaser: "We just pushed ESLint v1.7.0, which is a minor release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - nzakas
categories:
  - Release Notes
---

## Highlights

Here are some highlights of changes in this release.

### New Rules

* [`no-empty-pattern`](https://eslint.org/docs/rules/no-empty-pattern)
* [`no-magic-numbers`](https://eslint.org/docs/rules/no-magic-numbers)

### Extending JavaScript configs

You've always been able to use npm packages in the `extends` field of your configuration file. Now, you can directly link to JavaScript files in `extends`, allowing you to reference JavaScript configuration files directly even when they are not part of an npm package.


## Features


* New: Create eslint-config-eslint (fixes [#3525](https://github.com/eslint/eslint/issues/3525)) (Nicholas C. Zakas)
* New: add "consistent" option to the "curly" rule (fixes [#2390](https://github.com/eslint/eslint/issues/2390)) (Benoît Zugmeyer)
* New: no-empty-pattern rule (fixes [#3668](https://github.com/eslint/eslint/issues/3668)) (alberto)
* New: no-magic-numbers rule (fixes [#4027](https://github.com/eslint/eslint/issues/4027)) (Vincent Lemeunier)




## Enhancements


* Update: Support .js files for config (fixes [#3102](https://github.com/eslint/eslint/issues/3102)) (Gyandeep Singh)
* Update: RuleTester allows string errors in invalid cases (fixes [#4117](https://github.com/eslint/eslint/issues/4117)) (Kevin Partington)
* Update: added exceptions to `lines-around-comment` rule. (fixes [#2965](https://github.com/eslint/eslint/issues/2965)) (Mathieu M-Gosselin)
* Update: Add `matchDescription` option to `valid-jsdoc` (fixes [#2449](https://github.com/eslint/eslint/issues/2449)) (Gyandeep Singh)
* Update: Add `allow` option for `no-underscore-dangle` rule (fixes [#2135](https://github.com/eslint/eslint/issues/2135)) (Gyandeep Singh)
* Update: `allowArrowFunctions` option for `func-style` rule (fixes [#1897](https://github.com/eslint/eslint/issues/1897)) (Gyandeep Singh)
* Update: Ignore end of function in newline-after-var (fixes [#3682](https://github.com/eslint/eslint/issues/3682)) (alberto)
* Update: Option to ignore for loops in init-declarations (fixes [#3641](https://github.com/eslint/eslint/issues/3641)) (alberto)
* Update: Add webextensions environment (fixes [#4051](https://github.com/eslint/eslint/issues/4051)) (Blake Winton)




## Bug Fixes


* Fix: array-bracket-spacing for empty array (fixes [#4141](https://github.com/eslint/eslint/issues/4141)) (alberto)
* Fix: `indent` arrow function check fix (fixes [#4142](https://github.com/eslint/eslint/issues/4142)) (Gyandeep Singh)
* Fix: Make eslint-config-eslint work (fixes [#4145](https://github.com/eslint/eslint/issues/4145)) (Nicholas C. Zakas)
* Fix: `prefer-arrow-callback` had been wrong at arguments (fixes [#4095](https://github.com/eslint/eslint/issues/4095)) (Toru Nagashima)
* Fix: check for objects or arrays in array-bracket-spacing (fixes [#4083](https://github.com/eslint/eslint/issues/4083)) (alberto)
* Fix: message templates fail when no parameters are passed (fixes [#4080](https://github.com/eslint/eslint/issues/4080)) (Ilya Volodin)
* Fix: `indent` multi-line function call (fixes [#4073](https://github.com/eslint/eslint/issues/4073), fixes [#4075](https://github.com/eslint/eslint/issues/4075)) (Gyandeep Singh)
* Fix: no-mixed-tabs-and-spaces fails with some comments (fixes [#4086](https://github.com/eslint/eslint/issues/4086)) (alberto)
* Fix: `semi` to check for do-while loops (fixes [#4090](https://github.com/eslint/eslint/issues/4090)) (Gyandeep Singh)
* Fix: `no-unused-vars` had been missing some parameters (fixes [#4047](https://github.com/eslint/eslint/issues/4047)) (Toru Nagashima)
* Fix: no-mixed-spaces-and-tabs with comments and templates (fixes [#4077](https://github.com/eslint/eslint/issues/4077)) (alberto)
* Fix: Ignore template literals in no-mixed-tabs-and-spaces (fixes [#4054](https://github.com/eslint/eslint/issues/4054)) (Nicholas C. Zakas)
* Fix: `no-cond-assign` had needed double parens in `for` (fixes [#4023](https://github.com/eslint/eslint/issues/4023)) (Toru Nagashima)
* Fix: id-match bug incorrectly errors on `NewExpression` (fixes [#4042](https://github.com/eslint/eslint/issues/4042)) (Burak Yigit Kaya)
* Fix: `no-trailing-spaces` autofix to handle linebreaks (fixes [#4050](https://github.com/eslint/eslint/issues/4050)) (Gyandeep Singh)
* Fix: renamed no-magic-number to no-magic-numbers (fixes [#4053](https://github.com/eslint/eslint/issues/4053)) (Vincent Lemeunier)
* Fix: no-cond-assign should report assignment location (fixes [#4040](https://github.com/eslint/eslint/issues/4040)) (alberto)
* Fix: `no-redeclare` and `no-sahadow` for builtin globals (fixes [#3971](https://github.com/eslint/eslint/issues/3971)) (Toru Nagashima)




## Documentation


* Docs: Update various rules docs (Nicholas C. Zakas)
* Docs: Reference no-unexpected-multiline in semi (fixes [#4114](https://github.com/eslint/eslint/issues/4114)) (alberto)
* Docs: Alphabetize Rules lists (Kenneth Chung)
* Docs: Improve comma-dangle documentation (Gilad Peleg)
* Docs: Re-tag JSX code fences (fixes [#4020](https://github.com/eslint/eslint/issues/4020)) (Brandon Mills)
* Docs: Remove list of users from README (fixes [#3881](https://github.com/eslint/eslint/issues/3881)) (Brandon Mills)




## Dependency Upgrades


* Upgrade: Upgrade globals to 8.11.0 (fixes [#3599](https://github.com/eslint/eslint/issues/3599)) (Burak Yigit Kaya)




## Build Related


* Build: Fix path related failures on Windows in tests (fixes [#4061](https://github.com/eslint/eslint/issues/4061)) (Burak Yigit Kaya)
* Build: Enable CodeClimate (fixes [#4068](https://github.com/eslint/eslint/issues/4068)) (Nicholas C. Zakas)
* Build: Performance perf to not ignore jshint file (refs [#3765](https://github.com/eslint/eslint/issues/3765)) (Gyandeep Singh)
* Build: Add `.eslintignore` file for the project (fixes [#3765](https://github.com/eslint/eslint/issues/3765)) (Gyandeep Singh)
