---
layout: post
title: ESLint v1.6.0 released
teaser: "We just pushed ESLint v1.6.0, which is a minor release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - nzakas
categories:
  - Release Notes
---

## Highlights

Here are some highlights of changes in this release.

### Autofixing of more rules

ESLint v1.6.0 introduces several more autofixing rules to use with the `--fix` command line argument. In this release, we have implemented autofixing in these rules:

* `space-unary-ops`
* `computed-property-spacing`
* `no-multi-spaces`
* `object-curly-spacing`
* `array-bracket-spacing`
* `generator-star-spacing`
* `arrow-spacing`
* `block-spacing`
*

When you run ESLint on the command line with the `--fix` flag, it will automatically fix any problems that it can (not all problems are fixable at once) and will not report the problems that were fixed.

This feature is still considered experimental but is backed up by a lot of unit tests verifying correctness. Still, we expect to find some edge cases that we didn't anticipate, so we'd appreciate your feedback.

**Limitations:** the `--fix` flag does not work for piped-in text and has no effect on code that uses ESLint processors.





## Features


* New: no-negated-condition rule (fixes [#3740](https://github.com/eslint/eslint/issues/3740)) (alberto)




## Enhancements


* Update: Implement auto fix for space-unary-ops rule (fixes [#3976](https://github.com/eslint/eslint/issues/3976)) (alberto)
* Update: Implement auto fix for computed-property-spacing (fixes [#3975](https://github.com/eslint/eslint/issues/3975)) (alberto)
* Update: Implement auto fix for no-multi-spaces rule (fixes [#3979](https://github.com/eslint/eslint/issues/3979)) (alberto)
* Update: ESLint reports parsing errors with clear prefix. (fixes [#3555](https://github.com/eslint/eslint/issues/3555)) (Kevin Partington)
* Update: `no-mixed-require` to have non boolean option (fixes [#3922](https://github.com/eslint/eslint/issues/3922)) (Gyandeep Singh)
* Update: Add `typeof` option to `no-undef` rule (fixes [#3684](https://github.com/eslint/eslint/issues/3684)) (Gyandeep Singh)
* Update: Implement auto fix for object-curly-spacing (fixes [#3857](https://github.com/eslint/eslint/issues/3857)) (alberto)
* Update: Implement auto fix for array-bracket-spacing rule (fixes [#3858](https://github.com/eslint/eslint/issues/3858)) (alberto)
* Update: Apply lazy loading for rules (fixes [#3930](https://github.com/eslint/eslint/issues/3930)) (Gyandeep Singh)
* Update:warn message use @return when prefer.returns=return (fixes [#3889](https://github.com/eslint/eslint/issues/3889)) (闲耘™)
* Update: Implement auto fix for generator-star-spacing rule (fixes [#3873](https://github.com/eslint/eslint/issues/3873)) (alberto)
* Update: Implement auto fix for arrow-spacing rule (fixes [#3860](https://github.com/eslint/eslint/issues/3860)) (alberto)
* Update: Implement auto fix for block-spacing rule (fixes [#3859](https://github.com/eslint/eslint/issues/3859)) (alberto)
* Update: Add env 'nashorn' to support Java 8 Nashorn Engine (fixes [#3874](https://github.com/eslint/eslint/issues/3874)) (Benjamin Winterberg)




## Bug Fixes


* Fix: cache is basically not working (fixes [#4008](https://github.com/eslint/eslint/issues/4008)) (Richard Hansen)
* Fix: a test failure on Windows (fixes [#3968](https://github.com/eslint/eslint/issues/3968)) (Toru Nagashima)
* Fix: `no-invalid-this` had been missing globals in node (fixes [#3961](https://github.com/eslint/eslint/issues/3961)) (Toru Nagashima)
* Fix: `curly` with `multi` had false positive (fixes [#3856](https://github.com/eslint/eslint/issues/3856)) (Toru Nagashima)
* Fix: space-before-keywords fails with super keyword (fixes [#3946](https://github.com/eslint/eslint/issues/3946)) (alberto)
* Fix: CLI should not fail on account of ignored files (fixes [#3978](https://github.com/eslint/eslint/issues/3978)) (Dominic Barnes)
* Fix: brace-style rule incorrectly flagging switch (fixes [#4002](https://github.com/eslint/eslint/issues/4002)) (Aparajita Fishman)
* Fix: Report shorthand method names in complexity rule (fixes [#3955](https://github.com/eslint/eslint/issues/3955)) (Tijn Kersjes)
* Fix: trailing spaces auto fix to check for line breaks (fixes [#3940](https://github.com/eslint/eslint/issues/3940)) (Gyandeep Singh)
* Fix: Add schema to `global-require` rule (fixes [#3923](https://github.com/eslint/eslint/issues/3923)) (Gyandeep Singh)
* Fix: no-trailing-spaces autofix to account for blank lines (fixes [#3912](https://github.com/eslint/eslint/issues/3912)) (Gyandeep Singh)
* Fix: Support allman style for switch statement (fixes [#3903](https://github.com/eslint/eslint/issues/3903)) (Gyandeep Singh)




## Documentation


* Docs: Add note about typeof check for isNaN (fixes [#3985](https://github.com/eslint/eslint/issues/3985)) (Daniel Lo Nigro)
* Docs: Fix explanation and typos for accessor-pairs (alberto)
* Docs: Fix typos for camelcase (alberto)
* Docs: Fix typos for max-statements (Danny Guo)
* Docs: Fix typo for arrow-spacing (Danny Guo)
* Docs: Fix typos for wrap-regex (Danny Guo)
* Docs: Fix explanation for space-before-keywords (Danny Guo)
* Docs: Fix typos for operator-linebreak (Danny Guo)
* Docs: Fix typos for callback-return (Danny Guo)
* Docs: Fix example in no-negated-condition.md (fixes [#3908](https://github.com/eslint/eslint/issues/3908)) (alberto)
* Docs: Fix typo in blog post template (Nicholas C. Zakas)
* Docs: Prepare for rule doc linting (refs [#2271](https://github.com/eslint/eslint/issues/2271)) (Ian VanSchooten)






## Build Related


* Build: Add load performance check inside perf function (fixes [#3994](https://github.com/eslint/eslint/issues/3994)) (Gyandeep Singh)
* Build: Update markdownlint dependency (fixes [#3954](https://github.com/eslint/eslint/issues/3954)) (David Anson)
