---
layout: post
title: ESLint v1.5.0 released
teaser: "We just pushed ESLint v1.5.0, which is a minor release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - nzakas
categories:
  - Release Notes
---

## Highlights

Here are some highlights of changes in this release.

### Autofixing of more rules

ESLint v1.5.0 introduces several more autofixing rules to use with the `--fix` command line argument. In this release, we have implemented autofixing in these rules:

1. `eol-last`
1. `indent`
1. `no-extra-semi`
1. `no-spaced-func`
1. `no-trailing-spaces`
1. `space-after-keywords`
1. `space-before-blocks`
1. `space-before-keywords`
1. `space-infix-ops`
1. `space-return-throw-case`
1. `space-before-function-paren`

When you run ESLint on the command line with the `--fix` flag, it will automatically fix any problems that it can (not all problems are fixable at once) and will not report the problems that were fixed.

This feature is still considered experimental but is backed up by a lot of unit tests verifying correctness. Still, we expect to find some edge cases that we didn't anticipate, so we'd appreciate your feedback.

**Limitations:** the `--fix` flag does not work for piped-in text and has no effect on code that uses ESLint processors.

### --debug Flag

Sometimes ESLint doesn't do what it's supposed to do, and in that case, the new `--debug` flag can help. When using this flag, the command line will output debug information to the console, allowing you to see what ESLint is doing and providing valuable information to determine if there's a bug. We may ask for the debug information when you report a possible bug.


## Features


* New: Add --debug flag to CLI (fixes [#2692](https://github.com/eslint/eslint/issues/2692)) (Nicholas C. Zakas)



## Enhancements


* Update: `key-spacing` should allow 1+ around colon (fixes [#3363](https://github.com/eslint/eslint/issues/3363)) (Burak Yigit Kaya)
* Update: Add configuration option to `space-before-blocks` (fixes [#3758](https://github.com/eslint/eslint/issues/3758)) (Phil Vargas)
* Update: auto fix for space-before-function-paren rule (fixes [#3766](https://github.com/eslint/eslint/issues/3766)) (alberto)
* Update: Implement auto fix for `eol-last` rule (fixes [#3725](https://github.com/eslint/eslint/issues/3725)) (Gyandeep Singh)
* Update: Implement auto fix for `indent` rule (fixes [#3734](https://github.com/eslint/eslint/issues/3734)) (Gyandeep Singh)
* Update: Implement auto fix for `no-extra-semi` rule (fixes [#3745](https://github.com/eslint/eslint/issues/3745)) (Gyandeep Singh)
* Update: Implement auto fix for `no-spaced-func` rule (fixes [#3728](https://github.com/eslint/eslint/issues/3728)) (Gyandeep Singh)
* Update: Implement auto fix for `no-trailing-spaces` rule (fixes [#3723](https://github.com/eslint/eslint/issues/3723)) (Gyandeep Singh)
* Update: Implement auto fix for `space-after-keywords` rule (fixes [#3773](https://github.com/eslint/eslint/issues/3773)) (Gyandeep Singh)
* Update: Implement auto fix for `space-before-blocks` rule (fixes [#3776](https://github.com/eslint/eslint/issues/3776)) (Gyandeep Singh)
* Update: Implement auto fix for `space-before-keywords` rule (fixes [#3771](https://github.com/eslint/eslint/issues/3771)) (Gyandeep Singh)
* Update: Implement auto fix for `space-infix-ops` rule (fixes [#3801](https://github.com/eslint/eslint/issues/3801)) (Gyandeep Singh)
* Update: Implement auto fix for `space-return-throw-case` (fixes [#3732](https://github.com/eslint/eslint/issues/3732)) (Gyandeep Singh)
* Update: Refactors the traversing logic (refs [#3530](https://github.com/eslint/eslint/issues/3530)) (Toru Nagashima)


## Bug Fixes


* Fix: `comma-dangle` had not been checking imports/exports (fixes [#3794](https://github.com/eslint/eslint/issues/3794)) (Toru Nagashima)
* Fix: `no-warning-comments` can't be set via config comment (fixes [#3619](https://github.com/eslint/eslint/issues/3619)) (Burak Yigit Kaya)
* Fix: `semi-spacing` had conflicted with `block-spacing` (fixes [#3721](https://github.com/eslint/eslint/issues/3721)) (Toru Nagashima)
* Fix: `space-before-blocks` had conflicted `arrow-spacing` (fixes [#3769](https://github.com/eslint/eslint/issues/3769)) (Toru Nagashima)
* Fix: `space-before-keywords` fails to handle some cases (fixes [#3756](https://github.com/eslint/eslint/issues/3756)) (Marko Raatikka)
* Fix: Directory ignoring should work (fixes [#3812](https://github.com/eslint/eslint/issues/3812)) (Nicholas C. Zakas)
* Fix: Ensure **/node_modules works in ignore files (fixes [#3788](https://github.com/eslint/eslint/issues/3788)) (Nicholas C. Zakas)
* Fix: Ensure ./ works correctly with CLI (fixes [#3792](https://github.com/eslint/eslint/issues/3792)) (Nicholas C. Zakas)
* Fix: env-specified ecmaFeatures had been wrong (fixes [#3735](https://github.com/eslint/eslint/issues/3735)) (Toru Nagashima)
* Fix: false alarm of semi-spacing with semi set to never (fixes [#1983](https://github.com/eslint/eslint/issues/1983)) (Chen Yicai)
* Fix: function body indent issues (fixes [#3614](https://github.com/eslint/eslint/issues/3614), fixes [#3799](https://github.com/eslint/eslint/issues/3799)) (Gyandeep Singh)
* Fix: invalidate cache when config changes. (fixes [#3770](https://github.com/eslint/eslint/issues/3770)) (royriojas)
* Fix: jsx-quotes exception for attributes without value (fixes [#3793](https://github.com/eslint/eslint/issues/3793)) (Mathias Schreck)
* Fix: space checking between tokens (fixes [#2211](https://github.com/eslint/eslint/issues/2211)) (Nicholas C. Zakas)
* Fix: tests fail due to differences in temporary paths. (fixes [#3778](https://github.com/eslint/eslint/issues/3778)) (royriojas)



## Documentation

* Docs: Add if-else example (fixes [#3722](https://github.com/eslint/eslint/issues/3722)) (Ian VanSchooten)
* Docs: add more examples + tests for block-scoped-var (fixes [#3791](https://github.com/eslint/eslint/issues/3791)) (JT)
* Docs: Change example wording from warnings to problems (fixes [#3676](https://github.com/eslint/eslint/issues/3676)) (Ian VanSchooten)
* Docs: Clarify node types in no-multi-spaces (fixes [#3781](https://github.com/eslint/eslint/issues/3781)) (Nicholas C. Zakas)
* Docs: Fix closing code fence on cli docs (Ian VanSchooten)
* Docs: Update new-cap docs (fixes [#3798](https://github.com/eslint/eslint/issues/3798)) (Nicholas C. Zakas)
* Docs: Update no-undef-init docs (fixes [#3170](https://github.com/eslint/eslint/issues/3170)) (Nicholas C. Zakas)
* Docs: Update no-unused-expressions docs (fixes [#3685](https://github.com/eslint/eslint/issues/3685)) (Nicholas C. Zakas)






## Build Related

* Build: Generate formatter example docs (fixes [#3560](https://github.com/eslint/eslint/issues/3560)) (Ian VanSchooten)
