---
layout: post
title: ESLint v1.4.0 released
teaser: "We just pushed ESLint v1.4.0, which is a minor release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - nzakas
categories:
  - Release Notes
---

## Highlights

This release contains some exciting new features!

### Autofixing of some rules

ESLint v1.4.0 introduces the `--fix` command line argument to automatically fix some rules. In this first release, we have implemented autofixing in three rules:

1. `semi`
1. `eqeqeq`
1. `quotes`

When you run ESLint on the command line with the `--fix` flag, it will automatically fix any problems that it can (not all problems are fixable at once) and will not report the problems that were fixed.

This feature is still considered experimental but is backed up by a lot of unit tests verifying correctness. Still, we expect to find some edge cases that we didn't anticipate, so we'd appreciate your feedback.

**Limitations:** the `--fix` flag does not work for piped-in text and has no effect on code that uses ESLint processors.

### Cached results

If you're running ESLint on a large codebase, you may find it can take a significant amount of time. To help in those situations, we've introduced the `--cache` flag. When `--cache` is present, ESLint will cache the results of the run in `.eslintcache`. The next time you run ESLint with the `--cache` flag, it will skip over any files that had no problems in the previous run unless they have been modified.

The cache is deleted the next time you run ESLint without `--cache`, so you can't accidentally use it.

### Command line globs

You can pass glob patterns to ESLint on the command line:

```
$ eslint lib/**/*.js
```



### New rules

This release features several new rules:

* [`jsx-quotes`](https://eslint.org/docs/rules/jsx-quotes)
* [`require-jsdoc`](https://eslint.org/docs/rules/require-jsdoc)
* [`global-require`](https://eslint.org/docs/rules/global-require)
* [`no-restricted-syntax`](https://eslint.org/docs/rules/no-restricted-syntax)
* [`space-before-keywords`](https://eslint.org/docs/rules/space-before-keywords)

## Features


* New: Implement autofixing (fixes [#3134](https://github.com/eslint/eslint/issues/3134)) (Nicholas C. Zakas)
* New: `jsx-quotes` rule (fixes [#2011](https://github.com/eslint/eslint/issues/2011)) (Mathias Schreck)
* New: Implement cache in order to only operate on changed files since previous run. (fixes [#2998](https://github.com/eslint/eslint/issues/2998)) (Roy Riojas)
* New: `require-jsdoc` rule (fixes [#1842](https://github.com/eslint/eslint/issues/1842)) (Gyandeep Singh)
* New: Support glob path on command line (fixes [#3402](https://github.com/eslint/eslint/issues/3402)) (Burak Yigit Kaya)
* New: `no-restricted-syntax` rule to forbid certain syntax (fixes [#2422](https://github.com/eslint/eslint/issues/2422)) (Burak Yigit Kaya)
* New: Add --max-warnings flag to CLI (fixes [#2769](https://github.com/eslint/eslint/issues/2769)) (Kevin Partington)
* New: Add `parser` as an option (fixes [#3127](https://github.com/eslint/eslint/issues/3127)) (Gyandeep Singh)
* New: `space-before-keywords` rule (fixes [#1631](https://github.com/eslint/eslint/issues/1631)) (Marko Raatikka)
* New: global-require rule (fixes [#2318](https://github.com/eslint/eslint/issues/2318)) (Jamund Ferguson)




## Enhancements


* Update: Add Node 4 to travis builds (fixes [#3697](https://github.com/eslint/eslint/issues/3697)) (Ian VanSchooten)
* Update: Check for default assignment in no-unneeded-ternary (fixes [#3232](https://github.com/eslint/eslint/issues/3232)) (cjihrig)
* Update: Grouping related CLI options. (fixes [#3612](https://github.com/eslint/eslint/issues/3612)) (Kevin Partington)
* Update: Using @override does not require @param or @returns (fixes [#3629](https://github.com/eslint/eslint/issues/3629)) (Whitney Young)
* Update: Short circuit and ternary support in no-unused-expressions (fixes [#2733](https://github.com/eslint/eslint/issues/2733)) (David Warkentin)
* Update: Use `globals` module for the `commonjs` globals (fixes [#3606](https://github.com/eslint/eslint/issues/3606)) (Sindre Sorhus)
* Update: Allowing inline comments to disable eslint rules (fixes [#3472](https://github.com/eslint/eslint/issues/3472)) (Whitney Young)
* Update: Add quotes around the label in `no-redeclare` error messages (fixes [#3583](https://github.com/eslint/eslint/issues/3583)) (Ian VanSchooten)




## Bug Fixes


* Fix: Remove temporary `"allow-null"` (fixes [#3705](https://github.com/eslint/eslint/issues/3705)) (Toru Nagashima)
* Fix: `no-unused-vars` had been crashed at `/*global $foo*/` (fixes [#3714](https://github.com/eslint/eslint/issues/3714)) (Toru Nagashima)
* Fix: make getScope acquire innermost scope (fixes [#3700](https://github.com/eslint/eslint/issues/3700)) (voideanvalue)
* Fix: Allow whitespace in rule message parameters. (fixes [#3690](https://github.com/eslint/eslint/issues/3690)) (Kevin Partington)
* Fix: Eqeqeq rule with no option does not warn on 'a == null' (fixes [#3699](https://github.com/eslint/eslint/issues/3699)) (fediev)
* Fix: `no-unused-expressions` with `allowShortCircuit` false positive if left has no effect (fixes [#3675](https://github.com/eslint/eslint/issues/3675)) (Toru Nagashima)
* Fix: Not check for punctuator if on same line as last var (fixes [#3694](https://github.com/eslint/eslint/issues/3694)) (Gyandeep Singh)
* Fix: `no-extra-bind` to flag all arrow funcs (fixes [#3672](https://github.com/eslint/eslint/issues/3672)) (Nicholas C. Zakas)
* Fix: `object-curly-spacing` had been crashing on an empty object pattern (fixes [#3658](https://github.com/eslint/eslint/issues/3658)) (Toru Nagashima)
* Fix: `no-extra-parens` false positive at IIFE with member accessing (fixes [#3653](https://github.com/eslint/eslint/issues/3653)) (Toru Nagashima)
* Fix: `comma-dangle` with `"always"`/`"always-multiline"` false positive after a rest element (fixes [#3627](https://github.com/eslint/eslint/issues/3627)) (Toru Nagashima)
* Fix: `no-unused-vars` had not shown correct locations for `/*global` (fixes [#3617](https://github.com/eslint/eslint/issues/3617)) (Toru Nagashima)
* Fix: `space-after-keywords` not working for `catch` (fixes [#3654](https://github.com/eslint/eslint/issues/3654)) (Burak Yigit Kaya)
* Fix: Incorrectly warning about ignored files (fixes [#3649](https://github.com/eslint/eslint/issues/3649)) (Burak Yigit Kaya)
* Fix: Indent rule VariableDeclarator doesn't apply to arrow functions (fixes [#3661](https://github.com/eslint/eslint/issues/3661)) (Burak Yigit Kaya)
* Fix: Invalid env keys would cause an unhandled exception.(fixes [#3265](https://github.com/eslint/eslint/issues/3265)) (Ray Booysen)
* Fix: `consistent-as-needed` mode with `keyword: true` (fixes [#3636](https://github.com/eslint/eslint/issues/3636)) (Alex Guerrero)
* Fix: `indent` should only indent chain calls if the first call is single line (fixes [#3591](https://github.com/eslint/eslint/issues/3591)) (Burak Yigit Kaya)
* Fix: `quote-props` should not crash for object rest spread syntax (fixes [#3595](https://github.com/eslint/eslint/issues/3595)) (Joakim Carlstein)
* Fix: `no-useless-concat` false positive at numbers (fixes [#3575](https://github.com/eslint/eslint/issues/3575), fixes [#3589](https://github.com/eslint/eslint/issues/3589)) (Toru Nagashima)
* Fix: line number for duplicate object keys error (fixes [#3573](https://github.com/eslint/eslint/issues/3573)) (Elliot Lynde)




## Documentation


* Docs: Add new formatters to API docs (Ian VanSchooten)
* Docs: Fix spelling mistake (domharrington)
* Docs: Make `quotes` docs clearer (fixes [#3646](https://github.com/eslint/eslint/issues/3646)) (Nicholas C. Zakas)
* Docs: Update README with release and sponsor info (Nicholas C. Zakas)
* Docs: Add linting for second half of rule docs (refs [#2271](https://github.com/eslint/eslint/issues/2271)) (Ian VanSchooten)
* Docs: Fixing typos in plugin processor section. (fixes [#3648](https://github.com/eslint/eslint/issues/3648)) (Kevin Partington)
* Docs: Fixing broken link in documentation (Ilya Volodin)
* Docs: Use eslint-env in no-undef (fixes [#3616](https://github.com/eslint/eslint/issues/3616)) (Ian VanSchooten)
* Docs: Replace to npmjs.com (Ryuichi Okumura)
* Docs: Including for(;;) as valid case in no-constant-condition (Kevin Partington)
* Docs: correct contributing URL (Dieter Luypaert)




## Dependency Upgrades


* Upgrade: Consuming handlebars@^4.0.0 (fixes [#3632](https://github.com/eslint/eslint/issues/3632)) (Kevin Partington)




## Build Related


* Build: check-commit now checks commit message length. (fixes [#3706](https://github.com/eslint/eslint/issues/3706)) (Kevin Partington)
* Build: Increase mocha timeout (fixes [#3692](https://github.com/eslint/eslint/issues/3692)) (Nicholas C. Zakas)
