---
layout: post
title: ESLint v1.3.0 released
teaser: "We just pushed ESLint v1.3.0, which is a minor release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - nzakas
categories:
  - Release Notes
---

## Highlights

This is a summary of the major changes you need to know about for this version of ESLint.

### Using ASTs with the Node.js API

A long-requested feature was finally added for those using the [Node.js API](https://eslint.org/docs/developer-guide/nodejs-api): the ability to pass ESLint an AST and retrieve an AST once ESLint is finished. There's a new [`SourceCode`](https://eslint.org/docs/developer-guide/nodejs-api#sourcecode) type that encapsulates already-processed code, and a `SourceCode` object can now be passed to `linter.verify()` instead of text. For example:

```js
var linter = require("eslint").linter,
    SourceCode = require("eslint").SourceCode;


var sourceCode = new SourceCode(someText, anAST),
    messages = linter.verify(sourceCode, config);
```

Additionally, you can retrieve a `SourceCode` object from `linter` after linting is complete:

```
var messages = linter.verify("var foo = bar"),
    sourceCode = linter.getSourceCode();

sourceCode.ast;     // the AST
sourceCode.text;    // the original text
```

This should make it easier for tools using the Node.js API to avoid double-parsing of JavaScript code if they are already creating an AST.

### HTML Formatter

An exciting addition from Julian Laval, who contributed an [HTML formatter](https://github.com/eslint/eslint/issues/3505). Designed and implemented by Julian, you can now pass `-f html` on the command line to generate a beautiful HTML report of your ESLint results.

## Features


* New: `no-useless-concat` rule (fixes [#3506](https://github.com/eslint/eslint/issues/3506)) (Henry Zhu)
* New: Added HTML formatter (fixes [#3505](https://github.com/eslint/eslint/issues/3505)) (Julian Laval)
* New: Protractor environment (fixes [#3457](https://github.com/eslint/eslint/issues/3457)) (James Whitney)




## Enhancements


* Update: Add `keywords` flag to `consistent-as-needed` mode in `quote-props` (fixes [#3532](https://github.com/eslint/eslint/issues/3532)) (Burak Yigit Kaya)
* Update: adds `numbers` option  to quote-props (fixes [#2914](https://github.com/eslint/eslint/issues/2914)) (Jose Roberto Vidal)
* Update: Return to accept `undefined` type (fixes [#3382](https://github.com/eslint/eslint/issues/3382)) (Gyandeep Singh)
* Update: Quote var name in `no-unused-vars` error messages (refs [#3526](https://github.com/eslint/eslint/issues/3526)) (Burak Yigit Kaya)
* Update: Move methods to SourceCode (fixes [#3516](https://github.com/eslint/eslint/issues/3516)) (Nicholas C. Zakas)
* Update: Add quotes around the label in  `no-empty-label` error reports (fixes [#3526](https://github.com/eslint/eslint/issues/3526)) (Burak Yigit Kaya)
* Update: `newline-after-var` Allow comment + blank after var (fixes [#2852](https://github.com/eslint/eslint/issues/2852)) (Ian VanSchooten)
* Update: Add `unnecessary` option to `quote-props` (fixes [#3381](https://github.com/eslint/eslint/issues/3381)) (Burak Yigit Kaya)
* Update: separate options for block and line comments in `spaced-comment` rule (fixes [#2897](https://github.com/eslint/eslint/issues/2897)) (Burak Yigit Kaya)
* Update: Added "properties" option to `id-length` rule to ignore property names. (fixes [#3450](https://github.com/eslint/eslint/issues/3450)) (Mathieu M-Gosselin)
* Update: add new ignore pattern options to no-unused-vars (fixes [#2321](https://github.com/eslint/eslint/issues/2321)) (Mathias Schreck)
* Update: Allow pre-parsed code (fixes [#1025](https://github.com/eslint/eslint/issues/1025), fixes [#948](https://github.com/eslint/eslint/issues/948)) (Nicholas C. Zakas)




## Bug Fixes


* Fix: `quote-props` rule should ignore computed and shorthand properties (fixes [#3557](https://github.com/eslint/eslint/issues/3557)) (fixes [#3544](https://github.com/eslint/eslint/issues/3544)) (Burak Yigit Kaya)
* Fix: check space after yield keyword in space-unary-ops (fixes [#2707](https://github.com/eslint/eslint/issues/2707)) (Mathias Schreck)
* Fix: Don't try too hard to find fault in `no-implicit-coercion` (refs [#3402](https://github.com/eslint/eslint/issues/3402)) (Burak Yigit Kaya)
* Fix: Detect ternary operator in operator-linebreak rule (fixes [#3274](https://github.com/eslint/eslint/issues/3274)) (Burak Yigit Kaya)
* Fix: ASI indentation issue (fixes [#3514](https://github.com/eslint/eslint/issues/3514)) (Burak Yigit Kaya)
* Fix: Make `no-implicit-coercion` smarter about numerical expressions (fixes [#3510](https://github.com/eslint/eslint/issues/3510)) (Burak Yigit Kaya)
* Fix: `prefer-template` had not been handling TemplateLiteral as literal node (fixes [#3507](https://github.com/eslint/eslint/issues/3507)) (Toru Nagashima)
* Fix: `indent` shouldn't check the last line unless it is a punctuator (fixes [#3498](https://github.com/eslint/eslint/issues/3498)) (Burak Yigit Kaya)
* Fix: `indent` rule does not indent when doing multi-line chain calls (fixes [#3279](https://github.com/eslint/eslint/issues/3279)) (Burak Yigit Kaya)
* Fix: sort-vars rule fails when memo is undefined (fixes [#3474](https://github.com/eslint/eslint/issues/3474)) (Burak Yigit Kaya)
* Fix: `brace-style` doesn't report some closing brace errors (fixes [#3486](https://github.com/eslint/eslint/issues/3486)) (Burak Yigit Kaya)
* Fix: `indent` does not check FunctionDeclaration nodes properly (fixes [#3173](https://github.com/eslint/eslint/issues/3173)) (Burak Yigit Kaya)




## Documentation


* Docs: Add config comments for rule examples 'accessor-pairs' to 'no-extra-semi' (refs [#2271](https://github.com/eslint/eslint/issues/2271)) (Ian VanSchooten)
* Docs: (curly) Fix broken code in example (Kent C. Dodds)
* Docs: Clearer plugin rule configuration (fixes [#2022](https://github.com/eslint/eslint/issues/2022)) (Nicholas C. Zakas)
* Docs: Turn off Liquid in example (Nicholas C. Zakas)
* Docs: Mention CommonJS along with Node.js (fixes [#3388](https://github.com/eslint/eslint/issues/3388)) (Nicholas C. Zakas)
* Docs: Make it clear which rules are recommended (fixes [#3398](https://github.com/eslint/eslint/issues/3398)) (Nicholas C. Zakas)
* Docs: Add links to JSON Schema resources (fixes [#3411](https://github.com/eslint/eslint/issues/3411)) (Nicholas C. Zakas)
* Docs: Add more info to migration guide (fixes [#3439](https://github.com/eslint/eslint/issues/3439)) (Nicholas C. Zakas)
* Docs: Added section to shareable config (Gregory Waxman)






## Build Related


* Build: Autogenerate release blog post (fixes [#3562](https://github.com/eslint/eslint/issues/3562)) (Nicholas C. Zakas)
