---
layout: post
title: ESLint 1.2.0 released
teaser: "We just pushed ESLint v1.2.0, which is a minor release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
authors:
  - nzakas
categories:
  - Release Notes
---

## Features

* New: `block-spacing` rule (fixes [#3303](https://github.com/eslint/eslint/issues/3303)) (Toru Nagashima)
* New: `no-dupe-class-members` rule (fixes [#3294](https://github.com/eslint/eslint/issues/3294)) (Toru Nagashima)
* New: `prefer-arrow-callback` rule (fixes [#3140](https://github.com/eslint/eslint/issues/3140)) (Toru Nagashima)
* New: `prefer-template` rule (fixes [#3014](https://github.com/eslint/eslint/issues/3014)) (Toru Nagashima)
* New: Add commonjs environment (fixes [#3377](https://github.com/eslint/eslint/issues/3377)) (Nicholas C. Zakas)
* New: enable `-c` flag to accept a shareable config (fixes [#2543](https://github.com/eslint/eslint/issues/2543)) (Shinnosuke Watanabe)

## Enhancements

* Update: Add support for Allman to brace-style rule, brackets on newline (fixes [#3347](https://github.com/eslint/eslint/issues/3347)) (Burak Yigit Kaya)
* Update: add support for semicolon in comma-first setup in indent rule  (fixes [#3423](https://github.com/eslint/eslint/issues/3423)) (Burak Yigit Kaya)
* Update: allow disabling new-cap on object methods (fixes [#3172](https://github.com/eslint/eslint/issues/3172)) (Burak Yigit Kaya)
* Update: Clean up tests for CLI config support (refs [#2543](https://github.com/eslint/eslint/issues/2543)) (Gyandeep Singh)
* Update: Improve checkstyle format (fixes [#3183](https://github.com/eslint/eslint/issues/3183)) (Burak Yigit Kaya)
* Update: Improve error message for `indent` rule violation (fixes [#3340](https://github.com/eslint/eslint/issues/3340)) (Burak Yigit Kaya)
* Update: Improve validation error messages (fixes [#3193](https://github.com/eslint/eslint/issues/3193)) (Burak Yigit Kaya)
* Update: Make `baseConfig` to behave as other config options (fixes [#3371](https://github.com/eslint/eslint/issues/3371)) (Gyandeep Singh)
* Update: Make it clear that `space-infix-ops` support `const` (fixes [#3299](https://github.com/eslint/eslint/issues/3299)) (Burak Yigit Kaya)
* Update: Separate indent options for var, let and const (fixes [#3339](https://github.com/eslint/eslint/issues/3339)) (Burak Yigit Kaya)

## Bug Fixes

* Fix: `id-length` does not work for most of the new ES6 patterns (fixes [#3286](https://github.com/eslint/eslint/issues/3286)) (Burak Yigit Kaya)
* Fix: `indent` rule to check for last line correctly (fixes [#3327](https://github.com/eslint/eslint/issues/3327)) (Gyandeep Singh)
* Fix: `key-spacing.align` doesn't pay attention to non-whitespace before key (fixes [#3267](https://github.com/eslint/eslint/issues/3267)) (Burak Yigit Kaya)
* Fix: `valid-jsdoc` test does not recognize aliases for `@param` (fixes [#3399](https://github.com/eslint/eslint/issues/3399)) (Burak Yigit Kaya)
* Fix: Add AssignmentPattern to space-infix-ops (fixes [#3380](https://github.com/eslint/eslint/issues/3380)) (Burak Yigit Kaya)
* Fix: Apply plugin given in CLI (fixes [#3383](https://github.com/eslint/eslint/issues/3383)) (Ian VanSchooten)
* Fix: arrow-parens & destructuring/default params (fixes [#3353](https://github.com/eslint/eslint/issues/3353)) (Jamund Ferguson)
* Fix: exclude `AssignmentExpression` and `Property` nodes from extra indentation on first line (fixes [#3391](https://github.com/eslint/eslint/issues/3391)) (Burak Yigit Kaya)
* Fix: false positive on switch 'no duplicate case', (fixes [#3408](https://github.com/eslint/eslint/issues/3408)) (Cristian Carlesso)
* Fix: Inconsistent off-by-one errors with column numbers (fixes [#3231](https://github.com/eslint/eslint/issues/3231)) (Burak Yigit Kaya)
* Fix: Indent rule errors if an array literal starts a new statement (fixes [#3328](https://github.com/eslint/eslint/issues/3328)) (Burak Yigit Kaya)
* Fix: Indent rule errors with array of objects (fixes [#3329](https://github.com/eslint/eslint/issues/3329)) (Burak Yigit Kaya)
* Fix: Keyword "else" must not be followed by a newline (fixes [#3226](https://github.com/eslint/eslint/issues/3226)) (Burak Yigit Kaya)
* Fix: object curly spacing incorrectly warning for import with default and multiple named specifiers (fixes [#3370](https://github.com/eslint/eslint/issues/3370)) (Luke Karrys)
* Fix: radix rule does not apply for Number.parseInt (ES6) (fixes [#3364](https://github.com/eslint/eslint/issues/3364)) (Burak Yigit Kaya)
* Fix: Regression no-catch-shadow (1.1.0) (fixes [#3322](https://github.com/eslint/eslint/issues/3322)) (Burak Yigit Kaya)
* Fix: Spaced Comment Exceptions Not Working (fixes [#3276](https://github.com/eslint/eslint/issues/3276)) (Jamund Ferguson)
* Fix: trailing commas in object-curly-spacing for import/export (fixes [#3324](https://github.com/eslint/eslint/issues/3324)) (Henry Zhu)

## Documentation

* Docs: Add "Compatibility" section to linebreak-style (Vitor Balocco)
* Docs: better JSDoc for indent rule (Burak Yigit Kaya)
* Docs: Clarify `no-process-env` docs (fixes [#3318](https://github.com/eslint/eslint/issues/3318)) (Nicholas C. Zakas)
* Docs: Clarify what an unused var is (fixes [#2342](https://github.com/eslint/eslint/issues/2342)) (Nicholas C. Zakas)
* Docs: Document the second argument of `CLIEngine.executeOnText()` (Sindre Sorhus)
* Docs: Fix arrow name typo (fixes [#3309](https://github.com/eslint/eslint/issues/3309)) (Nicholas C. Zakas)
* Docs: fix syntax error in space-before-function-paren (Fabrício Matté)
* Docs: Fix typo: exception label (tienslebien)
* Docs: Mention double-byte character limitation in max-len (fixes [#2370](https://github.com/eslint/eslint/issues/2370)) (Nicholas C. Zakas)
* Docs: remove note outdated in 1.0.0 (Denis Sokolov)
* Docs: Update docs for no-iterator (fixes [#3405](https://github.com/eslint/eslint/issues/3405)) (Nicholas C. Zakas)
* Docs: Update no-unused-var docs (Nicholas C. Zakas)

## Dependency Upgrades

* Upgrade: bump `espree` dependency to `2.2.4` (fixes [#3403](https://github.com/eslint/eslint/issues/3403)) (Burak Yigit Kaya)

## Build Related

* Build: automatically convert line endings in release script (fixes [#2642](https://github.com/eslint/eslint/issues/2642)) (Burak Yigit Kaya)
