---
layout: post
title: ESLint 1.1.0 released
teaser: "We just pushed ESLint v1.1.0, which is a minor release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
authors:
  - nzakas
categories:
  - Release Notes
---

## Features

* New: Added grep-style formatter (fixes [#2991](https://github.com/eslint/eslint/issues/2991)) (Nobody Really)
* New: Jest environment (fixes [#3212](https://github.com/eslint/eslint/issues/3212)) (Darshak Parikh)

## Enhancements

* Update: add new `multi-or-nest` option for the `curly` rule (fixes [#1806](https://github.com/eslint/eslint/issues/1806)) (Ivan Nikulin)
* Update: Added as-needed option to arrow-parens (fixes [#3277](https://github.com/eslint/eslint/issues/3277)) (Jamund Ferguson)
* Update: Expose `getErrorResults` as a static method on `CLIEngine` (fixes [#3242](https://github.com/eslint/eslint/issues/3242)) (Gyandeep Singh)
* Update: Expose `getFormatter` as a static method on `CLIEngine` (fixes [#3239](https://github.com/eslint/eslint/issues/3239)) (Gyandeep Singh)
* Update: Split out generic AST methods into utility (fixes [#962](https://github.com/eslint/eslint/issues/962)) (Gyandeep Singh)

## Bug Fixes

* Fix: `accessor-pairs` false positive (fixes [#3262](https://github.com/eslint/eslint/issues/3262)) (Toru Nagashima)
* Fix: `context.getScope()` returns correct scope in blockBindings (fixes [#3254](https://github.com/eslint/eslint/issues/3254)) (Toru Nagashima)
* Fix: `es6` env had been missing `spread` and `newTarget` (fixes [#3281](https://github.com/eslint/eslint/issues/3281)) (Toru Nagashima)
* Fix: `eslint-env` in comments had not been setting `ecmaFeatures` (fixes [#2134](https://github.com/eslint/eslint/issues/2134)) (Toru Nagashima)
* Fix: `indent` rule for multi-line objects and arrays (fixes [#3236](https://github.com/eslint/eslint/issues/3236)) (Gyandeep Singh)
* Fix: `indent` rule for objects and nested one line blocks (fixes [#3238](https://github.com/eslint/eslint/issues/3238), fixes [#3237](https://github.com/eslint/eslint/issues/3237)) (Gyandeep Singh)
* Fix: `indent` to not error on same line nodes (fixes [#3228](https://github.com/eslint/eslint/issues/3228)) (Gyandeep Singh)
* Fix: `no-cond-assign` had been missing simplest pattern (fixes [#3249](https://github.com/eslint/eslint/issues/3249)) (Toru Nagashima)
* Fix: `no-invalid-this` had been missing jsdoc comment (fixes [#3287](https://github.com/eslint/eslint/issues/3287)) (Toru Nagashima)
* Fix: Check for null elements in indent rule (fixes [#3272](https://github.com/eslint/eslint/issues/3272)) (Gyandeep Singh)
* Fix: curly-spacing missing import case (fixes [#3302](https://github.com/eslint/eslint/issues/3302)) (Jamund Ferguson)
* Fix: id-length rule doesn't catch violations in arrow function parameters (fixes [#3275](https://github.com/eslint/eslint/issues/3275)) (Burak Yigit Kaya)
* Fix: Report no-spaced-func on last token before paren (fixes [#3289](https://github.com/eslint/eslint/issues/3289)) (Benjamin Woodruff)

## Dependency Upgrades

* Upgrade: inquirer dependency (fixes [#3241](https://github.com/eslint/eslint/issues/3241)) (Gyandeep Singh)

## Documentation

* Docs: Adds missing "not" to semi.md (Marius Schulz)
* Docs: Fix typo in object-shorthand docs (Gunnar Lium)
* Docs: Fix wrong options in examples of key-spacing (keik)
* Docs: place id-match rule at correct place in README.md (fixes [#3245](https://github.com/eslint/eslint/issues/3245)) (Matthieu Larcher)
* Docs: Update no-multi-spaces.md (Kenneth Powers)
* Docs: Update no-proto.md (Joe Zimmerman)
* Docs: Use backticks for option heading (Gyandeep Singh)
* Docs: use correct encoding for id-match.md (fixes [#3246](https://github.com/eslint/eslint/issues/3246)) (Matthieu Larcher)
