---
layout: post
title: ESLint 1.0.0-rc-2 released
teaser: "We just pushed ESLint 1.0.0-rc-2, which is the second release candidate for 1.0.0. As such, we have duplicated some of the content from the 1.0.0-rc-1 announcement to make it easier to understand the differences between 0.24.1 and this version."
image: release-notes-beta.png
tags:
  - release
authors:
  - nzakas
categories:
  - Release Notes
---

**Note:** This version of ESLint is not ready for production use and is provided to gather feedback from the community before releasing the final version. Please let us know if you having any problems or feedback by [creating issues](https://github.com/eslint/eslint/issues/new?body=I%27m%20using%20ESLint%20v1.0.0-rc-2%20and%20I%20(have%20some%20feedback%7Cfound%20a%20bug).%20I%20used%20this%20code%0A%0A(include%20full%20code)%0A%0Aand%20this%20configuration%0A%0A(include%20full%20configuration)%0A%0AAnd%20got%20this%20output%3A%0A%0A(include%20full%20ESLint%20output)%0A%0AI%20expected%20this%20instead%3A%0A%0A(describe%20what%20you%20thought%20should%20happen%20or%20what%20you%27d%20like%20to%20happen)).

## Highlights

This is a summary of the major changes you need to know about for this version of ESLint.

### Installing

Since this is a pre-release version, you will not automatically be upgraded by npm. You must specify the `next` tag when installing:

```
npm i eslint@next --save-dev
```

You can also specify the version directly:

```
npm i eslint@1.0.0-rc-2 --save-dev
```

### Migration Guide

As there are a lot of changes, we've created a [migration guide](/docs/1.0.0/user-guide/migrating-to-1.0.0) describing the changes in great detail along with the steps you should take to address them. Not all ESLint users will be affected by the changes, however, the changes are big enough that we recommend everyone read the migration thoroughly.

### New Language Features

1.0.0-rc-2 has been upgraded to the latest version of Espree, which means you now have access to additional language features:

1. `newTarget` allows you to use `new.target` in your code.
1. `experimentalObjectRestSpread` allows you to use the experimental [object rest/spread](https://github.com/sebmarkbage/ecmascript-rest-spread) in your code.

As special note about object rest/spread: We added this as a result of feedback that this was the only feature missing from ESLint that made many React users switch to `babel-eslint`. We thought it was silly to require React users to load an entirely separate parser for a single language feature, and since it kept being requested, we decided to add it. Keep in mind that this feature is still experimental and as such, the node types reflect that:

* `ExperimentalRestProperty` - represents rest properties in destructured objects
* `ExperimentalSpreadProperty` - represents spread properties in object literals

These are non-standard nodes and may change at any time. We therefore recommend that you don't create rules that used these directly unless you are willing to have those rules break when/if these nodes are standardized.

Keep in mind that this does not mean we will start supporting all experimental features, but we will continue evaluate them on a case-by-case basis.

### --reset is now the default

The `--reset` behavior is now the default behavior for ESLint and the `--reset` flag has been removed. This means there are no rules on by default in ESLint; you must enable the rules that you want. For more information on this change and how it affects you, please see the [migration guide](/docs/1.0.0/user-guide/migrating-to-1.0.0).

### Missing rules handled safely

In previous version, a missing rule would immediately cause ESLint to crash and exit. In this version, ESLint will just warn you about the missing rule, and if the rule has been replaced by something else, will tell you what rule to use instead.

## Deprecating eslint-tester

The `eslint-tester` module, which has long been the primary tester for ESLint rules, has now been moved into the `eslint` module. This was the result of a difficult relationship between these two modules that created circular dependencies and was causing a lot of problems in rule tests. Moving the tester into the `eslint` module fixed a lot of those issues.

**To address:** Update any references to `require("eslint-tester")` to this:

```js
var ESLintTester = require("eslint").ESLintTester;
```

### New Rules

There are several new rules for this release:

* [`arrow-parens`](https://eslint.org/docs/1.0.0/rules/arrow-parens)
* [`arrow-spacing`](https://eslint.org/docs/1.0.0/rules/arrow-spacing)
* [`callback-return`](https://eslint.org/docs/1.0.0/rules/callback-return)
* [`init-declarations`](https://eslint.org/docs/1.0.0/rules/init-declarations)
* [`no-class-assign`](https://eslint.org/docs/1.0.0/rules/no-class-assign)
* [`no-const-assign`](https://eslint.org/docs/1.0.0/rules/no-const-assign)
* [`no-implicit-coercion`](https://eslint.org/docs/1.0.0/rules/no-implicit-coercion)
* [`no-invalid-this`](https://eslint.org/docs/1.0.0/rules/no-invalid-this)
* [`no-useless-call`](https://eslint.org/docs/1.0.0/rules/no-useless-call)
* [`prefer-reflect`](https://eslint.org/docs/1.0.0/rules/prefer-reflect)
* [`prefer-spread`](https://eslint.org/docs/1.0.0/rules/prefer-spread)
* [`require-yield`](https://eslint.org/docs/1.0.0/rules/require-yield)

## Breaking Changes (1.0.0-rc-1)

* Breaking: Create eslint:recommended and add to --init (fixes [#2713](https://github.com/eslint/eslint/issues/2713)) (Greg Cochard)
* Breaking: Default to --reset behavior (fixes [#2100](https://github.com/eslint/eslint/issues/2100)) (Brandon Mills)
* Breaking: Remove deprecated rules (fixes [#1898](https://github.com/eslint/eslint/issues/1898)) (Ian VanSchooten)
* Breaking: Switch to 1-based columns (fixes [#2284](https://github.com/eslint/eslint/issues/2284)) (Nicholas C. Zakas)

## Features (1.0.0-rc-2)

* New: Add ignorePattern, ignoreComments, and ignoreUrls options to max-len (fixes [#2934](https://github.com/eslint/eslint/issues/2934), fixes [#2221](https://github.com/eslint/eslint/issues/2221), fixes [#1661](https://github.com/eslint/eslint/issues/1661)) (Benjamin Woodruff)
* New: Support shared configs named `@scope/eslint-config`, with shortcuts of `@scope` and `@scope/` (fixes [#3123](https://github.com/eslint/eslint/issues/3123)) (Jordan Harband)
* New: the `no-implicit-coercion` rule (fixes [#1621](https://github.com/eslint/eslint/issues/1621)) (Toru Nagashima)
* New: the `no-invalid-this` rule (fixes [#2815](https://github.com/eslint/eslint/issues/2815)) (Toru Nagashima)
* New: the `prefer-reflect` rule (fixes [#2939](https://github.com/eslint/eslint/issues/2939)) (Keith Cirkel)

## Features (1.0.0-rc-1)

* New: `context.getDeclaredVariables(node)` (fixes [#2801](https://github.com/eslint/eslint/issues/2801)) (Toru Nagashima)
* New: `require-yield` rule (fixes [#2822](https://github.com/eslint/eslint/issues/2822)) (Toru Nagashima)
* New: Add arrow-parens and arrow-spacing rule (fixes [#2628](https://github.com/eslint/eslint/issues/2628)) (Jxck)
* New: add callback-return rule (fixes [#994](https://github.com/eslint/eslint/issues/994)) (Jamund Ferguson)
* New: Add exported comment option (fixes [#1200](https://github.com/eslint/eslint/issues/1200)) (Jamund Ferguson)
* New: Add init-declarations rule (fixes [#2606](https://github.com/eslint/eslint/issues/2606)) (cjihrig)
* New: Add serviceworker environment (fixes [#2557](https://github.com/eslint/eslint/issues/2557)) (Gyandeep Singh)
* New: Add support for root: true in config files (fixes [#2736](https://github.com/eslint/eslint/issues/2736)) (Ian VanSchooten)
* New: the `no-class-assign` rule (fixes [#2718](https://github.com/eslint/eslint/issues/2718)) (Toru Nagashima)
* New: the `no-const-assign` rule (fixes [#2719](https://github.com/eslint/eslint/issues/2719)) (Toru Nagashima)
* New: the `no-useless-call` rule (fixes [#1925](https://github.com/eslint/eslint/issues/1925)) (Toru Nagashima)
* New: the `prefer-spread` rule (fixes [#2946](https://github.com/eslint/eslint/issues/2946)) (Toru Nagashima)
* New: Warn on missing rule definition or deprecation (fixes [#1549](https://github.com/eslint/eslint/issues/1549)) (Ian VanSchooten)

## Enhancements (1.0.0-rc-2)

* Update: `props` option of `no-param-reassign` (fixes [#1600](https://github.com/eslint/eslint/issues/1600)) (Toru Nagashima)
* Update: Add qunit to environments (fixes [#2870](https://github.com/eslint/eslint/issues/2870)) (Nicholas C. Zakas)
* Update: added shared builtins list (fixes [#2972](https://github.com/eslint/eslint/issues/2972)) (Jose Roberto Vidal)
* Update: Move eslint-tester into repo (fixes [#3110](https://github.com/eslint/eslint/issues/3110)) (Nicholas C. Zakas)

## Enhancements (1.0.0-rc-1)

* Update: `no-loop-func` allows block-scoped variables (fixes [#2517](https://github.com/eslint/eslint/issues/2517)) (Toru Nagashima)
* Update: Add missing schema to rules (fixes [#2858](https://github.com/eslint/eslint/issues/2858)) (Ilya Volodin)
* Update: adding some tests for no-redeclare to test named functions (fixes [#2953](https://github.com/eslint/eslint/issues/2953)) (Dominic Barnes)
* Update: Attach parent in getNodeByRangeIndex (fixes [#2863](https://github.com/eslint/eslint/issues/2863)) (Brandon Mills)
* Update: Handle CRLF line endings in spaced-comment rule (fixes [#2884](https://github.com/eslint/eslint/issues/2884)) (David Anson)
* Update: Handle CRLF line endings in spaced-comment rule - 2 (fixes [#3005](https://github.com/eslint/eslint/issues/3005)) (Burak Yigit Kaya)
* Update: Loosens regex rules around intentional fall through comments (Fixes [#2811](https://github.com/eslint/eslint/issues/2811)) (greg5green)

## Bug Fixes (1.0.0-rc-2)

* Fix: `arrow-spacing` allow multi-spaces and line-endings (fixes [#3079](https://github.com/eslint/eslint/issues/3079)) (Toru Nagashima)
* Fix: `no-*-assgin` rules support destructuring (fixes [#3029](https://github.com/eslint/eslint/issues/3029)) (Toru Nagashima)
* Fix: `space-before-blocks` to consider classes (fixes [#3062](https://github.com/eslint/eslint/issues/3062)) (Gyandeep Singh)
* Fix: add missing loop scopes to one-var (fixes [#3073](https://github.com/eslint/eslint/issues/3073)) (Jose Roberto Vidal)
* Fix: allow empty loop body in no-extra-semi (fixes [#3075](https://github.com/eslint/eslint/issues/3075)) (Mathias Schreck)
* Fix: block-scoped-var rule incorrectly flagging break/continue with label (fixes [#3082](https://github.com/eslint/eslint/issues/3082)) (Aparajita Fishman)
* Fix: handles blocks in no-use-before-define (fixes [#2960](https://github.com/eslint/eslint/issues/2960)) (Jose Roberto Vidal)
* Fix: Include phantomjs globals (fixes [#3064](https://github.com/eslint/eslint/issues/3064)) (Linus Unnebäck)
* Fix: Make no-implied-eval match more types of strings (fixes [#2898](https://github.com/eslint/eslint/issues/2898)) (Benjamin Woodruff)
* Fix: Multi-line variable declarations indent  (fixes [#3139](https://github.com/eslint/eslint/issues/3139)) (Gyandeep Singh)
* Fix: no-else-return handles multiple else-if blocks (fixes [#3015](https://github.com/eslint/eslint/issues/3015)) (Jose Roberto Vidal)
* Fix: Not load configs outside config with `root: true`  (fixes [#3109](https://github.com/eslint/eslint/issues/3109)) (Gyandeep Singh)
* Fix: Skip rest properties in no-dupe-keys (fixes 3042) (Nicholas C. Zakas)
* Fix: spaces trigger wrong in `no-useless-call` and `prefer-spread` (fixes [#3054](https://github.com/eslint/eslint/issues/3054)) (Toru Nagashima)
* Fix: strict rule supports classes (fixes [#2977](https://github.com/eslint/eslint/issues/2977)) (Toru Nagashima)
* Fix: Update sort-vars to ignore Array and ObjectPattern (fixes [#2954](https://github.com/eslint/eslint/issues/2954)) (Harry Ho)

## Bug Fixes (1.0.0-rc-1)

* Fix: `no-redeclare` checks module scopes (fixes [#2903](https://github.com/eslint/eslint/issues/2903)) (Toru Nagashima)
* Fix: `valid-jsdoc` counts `return` for arrow expressions (fixes [#2952](https://github.com/eslint/eslint/issues/2952)) (Toru Nagashima)
* Fix: add destructuring support to comma-dangle rule (fixes [#2911](https://github.com/eslint/eslint/issues/2911)) (Mathias Schreck)
* Fix: Added missing export syntax support to the block-scoped-var rule. (fixes [#2887](https://github.com/eslint/eslint/issues/2887)) (Mathieu M-Gosselin)
* Fix: Include execScript in no-implied-eval rule (fixes [#2873](https://github.com/eslint/eslint/issues/2873)) (Frederik Braun)
* Fix: Indent rule (fixes [#1797](https://github.com/eslint/eslint/issues/1797), fixes [#1799](https://github.com/eslint/eslint/issues/1799), fixes [#2248](https://github.com/eslint/eslint/issues/2248), fixes [#2343](https://github.com/eslint/eslint/issues/2343), fixes [#2278](https://github.com/eslint/eslint/issues/2278), fixes [#1800](https://github.com/eslint/eslint/issues/1800)) (Gyandeep Singh)
* Fix: Indent rule error on empty block body (fixes [#2999](https://github.com/eslint/eslint/issues/2999)) (Gyandeep Singh)
* Fix: indent rule should recognize single line statements with ASI (fixes [#3001](https://github.com/eslint/eslint/issues/3001), fixes [#3000](https://github.com/eslint/eslint/issues/3000)) (Mathias Schreck)
* Fix: lines-around-comment was crashing in some cases due to a missing check (fixes [#2892](https://github.com/eslint/eslint/issues/2892)) (Mathieu M-Gosselin)
* Fix: max-len to report correct column number (fixes [#2926](https://github.com/eslint/eslint/issues/2926)) (Mathias Schreck)
* Fix: multi-line + fat arrow indent (fixes [#2239](https://github.com/eslint/eslint/issues/2239)) (Gyandeep Singh)
* Fix: object-shorthand computed props (fixes [#2937](https://github.com/eslint/eslint/issues/2937)) (Jamund Ferguson)
* Fix: Remove invalid check inside `getJSDocComment` function (fixes [#2938](https://github.com/eslint/eslint/issues/2938)) (Gyandeep Singh)
* Fix: Shallow cloning issues in eslint config (fixes [#2961](https://github.com/eslint/eslint/issues/2961)) (Gyandeep Singh)
* Fix: Support class syntax for line-around-comment rule (fixes [#2894](https://github.com/eslint/eslint/issues/2894)) (Gyandeep Singh)
* Fix: workaround for leading and trailing comments in padded-block (fixes [#2336](https://github.com/eslint/eslint/issues/2336) and fixes [#2788](https://github.com/eslint/eslint/issues/2788)) (Mathias Schreck)
* Fix: Yoda should ignore comparisons where both sides are constants (fixes [#2867](https://github.com/eslint/eslint/issues/2867)) (cjihrig)

## Documentation (1.0.0-rc-2)

* Docs: Add config information to README (fixes [#3074](https://github.com/eslint/eslint/issues/3074)) (Nicholas C. Zakas)
* Docs: add documentation about custom-formatters. (fixes [#1260](https://github.com/eslint/eslint/issues/1260)) (royriojas)
* Docs: Add IanVS as committer (Nicholas C. Zakas)
* Docs: Add let and const examples for newline-after-var (fixes [#3020](https://github.com/eslint/eslint/issues/3020)) (James Whitney)
* Docs: Add mysticatea as committer (Nicholas C. Zakas)
* docs: additional computed-property-spacing documentation (fixes [#2941](https://github.com/eslint/eslint/issues/2941)) (Jamund Ferguson)
* Docs: Clarify that bot message is automatic (Ian VanSchooten)
* Docs: Fix unmatched paren in rule description (Greg Cochard)
* Docs: Grammar fixes in rule descriptions (refs [#3038](https://github.com/eslint/eslint/issues/3038)) (Greg Cochard)
* Docs: incorrect syntax in the example for rule «one-var» (Alexander Burtsev)
* Docs: make grammar consistent in rules index (Greg Cochard)
* Docs: Mention eslint-tester in migration guide (Nicholas C. Zakas)
* Docs: Mention variables defined in a global comment (fixes [#3137](https://github.com/eslint/eslint/issues/3137)) (William Becker)
* Docs: New issue template (fixes [#3048](https://github.com/eslint/eslint/issues/3048)) (Nicholas C. Zakas)
* Docs: Small typo fix in no-useless-call documentation (Paul O’Shannessy)

## Documentation (1.0.0-rc-1)

* Docs: Add 1.0.0 migration guide (fixes [#2994](https://github.com/eslint/eslint/issues/2994)) (Nicholas C. Zakas)
* Docs: Add space-in-brackets deprecation notice (Brandon Mills)
* Docs: Add spaced-line-comment deprecation notice (Brandon Mills)
* Docs: array-bracket-spacing examples used space-in-brackets (Brandon Mills)
* Docs: clarification in no-unused-vars (Jan Schär)
* Docs: Clarify when not to use space-before-blocks (Ian VanSchooten)
* Docs: fix a typo (bartmichu)
* Docs: Fix typo (Bryan Smith)
* Docs: Fix typo in array-bracket-spacing rule (zallek)
* Docs: Fix typo in the shareable configs doc (Siddharth Kannan)
* Docs: missing quotes in JSON (Jan Schär)
* Docs: remove mistaken "off by default" (Jan Schär)
* Docs: Update changelog for 0.24.1 (fixes [#2976](https://github.com/eslint/eslint/issues/2976)) (Nicholas C. Zakas)

## Build Related (1.0.0-rc-2)

* Build: Check commit message format at end of tests (fixes [#3058](https://github.com/eslint/eslint/issues/3058)) (Ian VanSchooten)
* Build: Increase Windows Mocha timeout (fixes [#3133](https://github.com/eslint/eslint/issues/3133)) (Ian VanSchooten)
* Build: readd phantomjs dependency with locked down version (fixes [#3026](https://github.com/eslint/eslint/issues/3026)) (Mathias Schreck)
* Build: Remove unnecessary phantomjs devDependency (fixes [#3021](https://github.com/eslint/eslint/issues/3021)) (Gyandeep Singh)

## Build Related (1.0.0-rc-1)

* Build: Add appveyor CI system (fixes [#2923](https://github.com/eslint/eslint/issues/2923)) (Gyandeep Singh)
* Build: gensite target supports rule removal (refs [#1898](https://github.com/eslint/eslint/issues/1898)) (Brandon Mills)

## Dependency Upgrades (1.0.0-rc-1)

* Upgrade: Espree to 2.2.0 (fixes [#3011](https://github.com/eslint/eslint/issues/3011)) (Nicholas C. Zakas)
