---
layout: post
title: ESLint 0.24.0 released
teaser: "We just pushed ESLint 0.24.0, which is a minor release upgrade. This release includes new features and bug fixes."
image: release-notes.png
tags:
  - release
authors:
  - nzakas
categories:
  - Release Notes
---

## Highlights

This is a summary of the major changes you need to know about for this version of ESLint.

### 1.0.0 Work Beginning

0.24.0 is the last planned release prior to 1.0.0. We focused mostly on bug fixes and filling functionality gaps in this release, so we are better prepared for 1.0.0. We will still do bugfix releases as necessary, see [the release plans](preparing-for-1.0.0) for more information.

### New Rules

* `constructor-super` - ensures `super()` is called in derived class constructors
* `no-this-before-super` - ensures `this` isn't used before `super` in derived class constructors
* `no-unexpected-multiline` - ensures function calls and property access are wholly on one line
* `array-bracket-spacing` - ensures proper spacing of array literal brackets

## Bug Fixes

* Fix: `no-extra-semi` in class bodies (fixes [#2794](https://github.com/eslint/eslint/issues/2794)) (Toru Nagashima)
* Fix: Add --init to the CLI options (fixes [#2817](https://github.com/eslint/eslint/issues/2817)) (Gyandeep Singh)
* Fix: Allow blocked comments with markers and new-line (fixes [#2777](https://github.com/eslint/eslint/issues/2777)) (Gyandeep Singh)
* Fix: arraysInObjects for object-curly-spacing (fixes [#2752](https://github.com/eslint/eslint/issues/2752)) (Jamund Ferguson)
* Fix: Check type to be file when looking for config files (fixes [#2790](https://github.com/eslint/eslint/issues/2790)) (Gyandeep Singh)
* Fix: comma-dangle always-multiline: no comma right before the last brace (fixes [#2091](https://github.com/eslint/eslint/issues/2091)) (Benoît Zugmeyer)
* Fix: context report message to handle more scenarios (fixes [#2746](https://github.com/eslint/eslint/issues/2746)) (Gyandeep Singh)
* Fix: handle-callback-err missing arrow functions (fixes [#2823](https://github.com/eslint/eslint/issues/2823)) (Jamund Ferguson)
* Fix: no-dupe-args sparse array crash (fixes [#2848](https://github.com/eslint/eslint/issues/2848)) (Chris Walker)
* Fix: No-shadow rule duplicating error messages (fixes [#2706](https://github.com/eslint/eslint/issues/2706)) (Aliaksei Shytkin)
* Fix: object literals in arrow function bodies (fixes [#2702](https://github.com/eslint/eslint/issues/2702)) (Jose Roberto Vidal)
* Fix: object-shorthand rule should not warn for NFEs (fixes [#2748](https://github.com/eslint/eslint/issues/2748)) (Michael Ficarra)
* Fix: one-var 'never' option for mixed initialization (Fixes [#2786](https://github.com/eslint/eslint/issues/2786)) (Ian VanSchooten)
* Fix: space-after-keywords should ignore extra parens (fixes [#2847](https://github.com/eslint/eslint/issues/2847)) (Mathias Schreck)
* Fix: space-unary-ops flags expressions starting w/ keyword (fixes [#2764](https://github.com/eslint/eslint/issues/2764)) (Michael Ficarra)
* Fix: valid-jsdoc to work for object getters (fixes [#2407](https://github.com/eslint/eslint/issues/2407)) (Gyandeep Singh)

## Features

* New: `constructor-super` rule (fixes [#2720](https://github.com/eslint/eslint/issues/2720)) (Toru Nagashima)
* New: `no-this-before-super` rule (fixes [#2721](https://github.com/eslint/eslint/issues/2721)) (Toru Nagashima)
* New: add no-unexpected-multiline rule (fixes [#746](https://github.com/eslint/eslint/issues/746)) (Glen Mailer)
* New: array-bracket-spacing (fixes [#2226](https://github.com/eslint/eslint/issues/2226)) (Jamund Ferguson)

## Enhancements

* Update: Add `except-parens` option to `no-return-assign` rule (fixes [#2809](https://github.com/eslint/eslint/issues/2809)) (Toru Nagashima)
* Update: Add an option as an object to `generator-star-spacing` rule (fixes [#2787](https://github.com/eslint/eslint/issues/2787)) (Toru Nagashima)
* Update: Add block options to `lines-around-comment` rule (fixes [#2667](https://github.com/eslint/eslint/issues/2667)) (Gyandeep Singh)
* Update: Ignore JsDoc comments by default for `spaced-comment` (fixes [#2766](https://github.com/eslint/eslint/issues/2766)) (Gyandeep Singh)
* Update: refactor handle-callback-err to improve performance (fixes [#2841](https://github.com/eslint/eslint/issues/2841)) (Mathias Schreck)

## Documentation

* Docs: Clarify --rule description (fixes [#2773](https://github.com/eslint/eslint/issues/2773)) (Nicholas C. Zakas)
* Docs: Fix a minor typo in a prefer-const example (jviide)
* Docs: small fix in quote-props examples (Jose Roberto Vidal)

## Build Related

* Build: Update markdownlint dependency (David Anson)

## Dependency Upgrades

* Upgrade: eslint-tester to 0.8.1 (Nicholas C. Zakas)
