---
layout: post
title: ESLint 0.23.0 released
teaser: "We just pushed ESLint 0.23.0, which is a minor release upgrade. This release includes new features and bug fixes."
image: release-notes.png
tags:
  - release
authors:
  - ilyavolodin
categories:
  - Release Notes
---

## Highlights

This is a summary of the major changes you need to know about for this version of ESLint.

## Configuration Validation

The biggest feature of this release is addition of rules configuration validation. Now if you accidentally included a non-existing option in a rule configuration
you will be notified about it when you run ESLint. This also works for inline configuration inside JavaScript files and for configuration passed on command line.

Note that prior to this release, invalid rule options meant the rule would use its default options. This would happen without any warning, so improperly configured rules weren't working as intended in previous releases. If you start getting warned about invalid rule configuration, be sure to consult the rule documentation to determine how to fix it.

## New Rules

Three new rules were added in this release

* `computed-property-spacing` - require or disallow padding inside computed properties (off by default)
* `prefer-const` - suggest using of `const` declaration for variables that are never modified after declared (off by default)
* `spaced-comment` - require or disallow a space immediately following the `//` or `/*` in a comment (off by default)

## Breaking Changes

* Breaking: Automatically validate rule options (fixes [#2595](https://github.com/eslint/eslint/issues/2595)) (Brandon Mills)

## Bug Fixes

* Fix: "extends" within package.json (fixes [#2754](https://github.com/eslint/eslint/issues/2754)) (Gyandeep Singh)
* Fix: `prefer-const` treats `for-in`/`for-of` with the same way (Fixes [#2739](https://github.com/eslint/eslint/issues/2739)) (Toru Nagashima)
* Fix: don't try to strip "line:" prefix from parser errors with no such prefix (fixes [#2698](https://github.com/eslint/eslint/issues/2698)) (Tim Cuthbertson)
* Fix: never ignore config comment options (fixes [#2725](https://github.com/eslint/eslint/issues/2725)) (Brandon Mills)
* Fix: no-trailing-spaces now handles skipBlankLines (fixes [#2575](https://github.com/eslint/eslint/issues/2575)) (Greg Cochard)
* Fix: remove hard-coded list of unary keywords in space-unary-ops rule (fixes [#2696](https://github.com/eslint/eslint/issues/2696)) (Tim Cuthbertson)
* Fix: Misconfigured default option for lines-around-comment rule (fixes [#2677](https://github.com/eslint/eslint/issues/2677)) (Gyandeep Singh)
* Fix: `no-shadow` allows shadowing in the TDZ (fixes [#2568](https://github.com/eslint/eslint/issues/2568)) (Toru Nagashima)
* Fix: Check unused vars in exported functions (fixes [#2678](https://github.com/eslint/eslint/issues/2678)) (Gyandeep Singh)
* Fix: Allowing u flag in regex to properly lint no-empty-character-class (fixes [#2679](https://github.com/eslint/eslint/issues/2679)) (Dominic Barnes)
* Fix: trailing commas in object-curly-spacing (fixes [#2647](https://github.com/eslint/eslint/issues/2647)) (Jamund Ferguson)

## Features

* New: `computed-property-spacing` (refs [#2226](https://github.com/eslint/eslint/issues/2226)) (Jamund Ferguson)
* New: Allow extends to be an array (fixes [#2699](https://github.com/eslint/eslint/issues/2699)) (Justin Morris)
* New: globals@7.1.0 (fixes [#2682](https://github.com/eslint/eslint/issues/2682)) (silverwind)
* New: `prefer-const` rule (fixes [#2333](https://github.com/eslint/eslint/issues/2333)) (Toru Nagashima)
* New: `spaced-comment` rule (fixes [#1088](https://github.com/eslint/eslint/issues/1088)) (Gyandeep Singh)
* New: run processors when calling executeOnText (fixes [#2331](https://github.com/eslint/eslint/issues/2331)) (Mordy Tikotzky)

## Enhancements

* Update: Add clarification to spaced-comment (refs [#2588](https://github.com/eslint/eslint/issues/2588)) (Greg Cochard)
* Update: Add markers to spaced-comment (fixes [#2588](https://github.com/eslint/eslint/issues/2588)) (Greg Cochard)
* Update: no-lone-blocks does not report block-level scopes (fixes  [#2119](https://github.com/eslint/eslint/issues/2119)) (Jose Roberto Vidal)
* Update: yoda onlyEquality option (fixes [#2638](https://github.com/eslint/eslint/issues/2638)) (Denis Sokolov)
* Update: move executeOnText() tests to the correct describe block (fixes [#2648](https://github.com/eslint/eslint/issues/2648)) (Mordy Tikotzky)
* Update: add tests to assert that the preprocessor is running (fixes [#2651](https://github.com/eslint/eslint/issues/2651)) (Mordy Tikotzky)
* Upgrade: globals@8.0.0 (fixes [#2759](https://github.com/eslint/eslint/issues/2759)) (silverwind)

## Documentation

* Docs: eol-last docs fix (fixes [#2755](https://github.com/eslint/eslint/issues/2755)) (Gyandeep Singh)
* Docs: btmills is a reviewer (Nicholas C. Zakas)
* Docs: Add links to team members profile (Gyandeep Singh)
* Docs: add team and ES7 info to readme (Nicholas C. Zakas)
* Docs: Mark global-strict on by default (fixes [#2629](https://github.com/eslint/eslint/issues/2629)) (Ilya Volodin)
* Docs: deprecate no-wrap-func (fixes [#2644](https://github.com/eslint/eslint/issues/2644)) (Jose Roberto Vidal)
* Docs: Fixing grammar: then -> than (E)
* Docs: be consistent about deprecation status (Matthew Dapena-Tretter)
* Docs: Fix mistakes in object-curly-spacing docs (Matthew Dapena-Tretter)
* Docs: update comment to align with source code it's referencing (Michael Ficarra)

## Build Related

* Build: Revert lock io.js to v2.1.0 (refs [#2745](https://github.com/eslint/eslint/issues/2745)) (Brandon Mills)
* Build: Pin Sinon version (fixes [#2742](https://github.com/eslint/eslint/issues/2742)) (Ilya Volodin)
* Build: Stringify payload of release notes (fixes [#2640](https://github.com/eslint/eslint/issues/2640)) (Greg Cochard)
* Build: Lock io.js to v2.1.0 (fixes [#2653](https://github.com/eslint/eslint/issues/2653)) (Ilya Volodin)
