---
layout: post
title: ESLint 0.22.0 released
teaser: "We just pushed ESLint 0.22.0, which is a minor release upgrade. This release includes new features and bug fixes."
image: release-notes.png
tags:
  - release
authors:
  - ilyavolodin
categories:
  - Release Notes
---

## Highlights

This is a summary of the major changes you need to know about for this version of ESLint.

## New Rules
We added 3 new rules to ESLint this release:

* lines-around-comment - Enforces empty lines around comments (off by default)
* accessor-pairs - Enforces getter/setter pairs in objects (off by default)
* object-curly-spacing - Disallow or enforce spaces inside of curly braces in objects.

We also renamed existing rule `no-empty-class` to `no-empty-character-class` to prevent confusion with ES6 classes

## Preparation for configuration validation
We added rule schemas as well as schema validation, in preparation of enabling validation of `.eslintrc` configuration files.

## Bug Fixes

* Fix: “consistent-this” incorrectly flagging destructuring of `this` (fixes [#2633](https://github.com/eslint/eslint/issues/2633)) (David Aurelio)
* Fix: no-multiple-empty-lines and template strings (fixes [#2605](https://github.com/eslint/eslint/issues/2605)) (Jamund Ferguson)
* Fix: Shared config being clobbered by other config (fixes [#2592](https://github.com/eslint/eslint/issues/2592)) (Dominic Barnes)
* Fix: Improve around function/class names of `no-shadow` (fixes [#2556](https://github.com/eslint/eslint/issues/2556), [#2552](https://github.com/eslint/eslint/issues/2552)) (Toru Nagashima)
* Fix: Improve code coverage (fixes [#2590](https://github.com/eslint/eslint/issues/2590)) (Ilya Volodin)
* Fix: Allow scoped configs to have sub-configs (fixes [#2594](https://github.com/eslint/eslint/issues/2594)) (Greg Cochard)
* Fix: counting of variables statements in one-var (fixes [#2570](https://github.com/eslint/eslint/issues/2570)) (Mathias Schreck)
* Fix: Object shorthand rule incorrectly flagging getters/setters (fixes [#2563](https://github.com/eslint/eslint/issues/2563)) (Brad Dougherty)

## Features

* New: object-curly-spacing (fixes [#2225](https://github.com/eslint/eslint/issues/2225)) (Jamund Ferguson)
* New: lines-around-comment (fixes [#1344](https://github.com/eslint/eslint/issues/1344)) (Jamund Ferguson)
* New: accessor-pairs rule to object initializations (fixes [#1638](https://github.com/eslint/eslint/issues/1638)) (Gyandeep Singh)
* New: Add rule schemas (refs [#2179](https://github.com/eslint/eslint/issues/2179)) (Brandon Mills)
* New: Add config validator (refs [#2179](https://github.com/eslint/eslint/issues/2179)) (Brandon Mills)
* New: Add worker environment (fixes [#2442](https://github.com/eslint/eslint/issues/2442)) (Ilya Volodin)
* New no-empty-character class (fixes [#2508](https://github.com/eslint/eslint/issues/2508)) (Jamund Ferguson)
* New: Adds --ignore-pattern option. (fixes [#1742](https://github.com/eslint/eslint/issues/1742)) (Patrick McElhaney)

## Enhancements

* Upgrade: escope 3.1.0 (fixes [#2310](https://github.com/eslint/eslint/issues/2310), [#2405](https://github.com/eslint/eslint/issues/2405)) (Toru Nagashima)
* Upgrade: eslint-tester to 0.7.0 (Ilya Volodin)
* Update: allow shadowed references in no-alert (fixes [#1105](https://github.com/eslint/eslint/issues/1105)) (Mathias Schreck)
* Update: adds "functions" option to no-extra-parens (fixes [#2477](https://github.com/eslint/eslint/issues/2477)) (Jose Roberto Vidal)

## Documentation

* Docs: minor fix for one-var rule (Jamund Ferguson)
* Docs: Fix json formatting for lines-around-comments rule (Gyandeep Singh)
* Docs: Fix typo in shareable-configs example (fixes [#2571](https://github.com/eslint/eslint/issues/2571)) (Ted Piotrowski)

## Build Related

* Build: Add auto-update of release tag on github (fixes [#2566](https://github.com/eslint/eslint/issues/2566)) (Greg Cochard)
* Build: Unblock build by increasing code coverage (Ilya Volodin)
* Build: Add sudo:false for Travis (fixes [[#2582](https://github.com/eslint/eslint/issues/2582)](https://github.com/eslint/eslint/issues/2582)) (Ilya Volodin)
* Build: Relax markdownlint rules by disabling style-only items (David Anson)
