---
layout: post
title: ESLint 0.21.0 released
teaser: "We just pushed ESLint 0.21.0, which is a minor release upgrade. This release includes new features and bug fixes."
image: release-notes.png
tags:
  - release
  - breaking change
authors:
  - nzakas
categories:
  - Release Notes
---

## Highlights

This is a summary of the major changes you need to know about for this version of ESLint.

## Config Initialization

Setting up a configuration file for the first time can be difficult, and we're trying to make it easier. That's why we've added the `--init` command line flag. Using this flag, you'll be walked through a series of questions to setup the basic information in your config file. For example:

```
$ eslint --init
? What style of indentation do you use? Spaces
? What quotes do you use for strings? Double
? What line endings do you use? Unix
? Do you require semicolons? Yes
? Are you using ECMAScript 6 features? Yes
? Where will your code run? Browser
? Do you use JSX? No
? What format do you want your config file to be in? YAML
Successfully created .eslintrc file in c:\Users\Nicholas\projects\personal\tmp
```

We hope this new feature will help get people started with ESLint faster.

## Config Inheritance

Another feature we've added is the ability to inherit configuration settings. Now, you can use `extends` to specify another file from which you want to inherit settings. For example:

```json
{
    "extends": "../../config/myconfig.json"
}
```

Read more in the [documentation](https://eslint.org/docs/user-guide/configuring#extending-configuration-files).

## Shareable Configs

Rounding out our configuration changes is the ability to package up and share your configuration information with others. Shareable configs are simply npm packages that export an object containing your configuration preferences. You can then use `extends` to bring those settings into your project. See the [documentation](https://eslint.org/docs/developer-guide/shareable-configs) for more information.

### 1.0.0 Update

Some of our plans for 1.0.0 have shifted due to some last minute feedback. The new list of changes for 1.0.0 is [now available](https://github.com/eslint/eslint/issues?q=is%3Aopen+is%3Aissue+milestone%3Av1.0.0).

The biggest notable change from the previous list is [#2100](https://github.com/eslint/eslint/issues/2100), which will make `--reset` the default behavior of ESLint. We've had a lot of feedback that the default rules are a significant pain point, so in 1.0.0 we won't have any rules enabled by default. See the issue for more discussion.

Reminder: we are preparing a list of breaking changes that will be coming in v1.0.0 and are tracking them on [#1898](https://github.com/eslint/eslint/issues/1898). Stay tuned to that issue so you know what to expect.

## Breaking Changes

* Breaking: Do not check unset declaration types (Fixes [#2448](https://github.com/eslint/eslint/issues/2448)) (Ilya Volodin)

## Bug Fixes

* Fix object-shorthand arrow functions (fixes [#2414](https://github.com/eslint/eslint/issues/2414)) (Jamund Ferguson)
* Fix: `no-loop-func` rule allows functions at init part (fixes [#2427](https://github.com/eslint/eslint/issues/2427)) (Toru Nagashima)
* Fix: Adding exception for last line (Refs [#2423](https://github.com/eslint/eslint/issues/2423)) (Greg Cochard)
* Fix: brace-style to not warn about curly mix ifStatements (fixes [#1739](https://github.com/eslint/eslint/issues/1739)) (Gyandeep Singh)
* Fix: Check extra scope in no-use-before-define (fixes [#2372](https://github.com/eslint/eslint/issues/2372)) (Nicholas C. Zakas)
* Fix: crash on 0 max (fixes [#2423](https://github.com/eslint/eslint/issues/2423)) (Greg Cochard)
* Fix: Don't warn for member expression functions (fixes [#2402](https://github.com/eslint/eslint/issues/2402)) (Nicholas C. Zakas)
* Fix: Edge cases for no-wrap-func (fixes [#2466](https://github.com/eslint/eslint/issues/2466)) (Nicholas C. Zakas)
* Fix: Ensure baseConfig isn't changed (fixes [#2380](https://github.com/eslint/eslint/issues/2380)) (Nicholas C. Zakas)
* Fix: generator-star-spacing with class methods (fixes [#2351](https://github.com/eslint/eslint/issues/2351)) (Brandon Mills)
* Fix: Improves detection of self-referential functions (fixes [#2363](https://github.com/eslint/eslint/issues/2363)) (Jose Roberto Vidal)
* Fix: Include string literal keys in object-shorthand (Fixes [#2374](https://github.com/eslint/eslint/issues/2374)) (Jamund Ferguson)
* Fix: no-irregular-whitespace should work with irregular line breaks (fixes [#2316](https://github.com/eslint/eslint/issues/2316)) (Mathias Schreck)
* Fix: no-redeclare switch scoping (fixes [#2337](https://github.com/eslint/eslint/issues/2337)) (Nicholas C. Zakas)
* Fix: npm run profile script should use espree (fixes [#2150](https://github.com/eslint/eslint/issues/2150)) (Mathias Schreck)
* Fix: sanitise Jekyll interpolation during site generation (fixes [#2297](https://github.com/eslint/eslint/issues/2297)) (Michael Ficarra)
* Fix: space-in-brackets Cannot read property 'range' (fixes [#2392](https://github.com/eslint/eslint/issues/2392)) (Gyandeep Singh)
* Fix: space-in-brackets import declaration  (fixes [#2378](https://github.com/eslint/eslint/issues/2378)) (Gyandeep Singh)

## Features

* New: Add addPlugin method to CLI-engine (Fixes [#1971](https://github.com/eslint/eslint/issues/1971)) (Ilya Volodin)
* New: Add dot-location rule. (fixes [#1884](https://github.com/eslint/eslint/issues/1884)) (Greg Cochard)
* New: Add init command (fixes [#2302](https://github.com/eslint/eslint/issues/2302)) (Ilya Volodin)
* New: Add support for extending configurations (fixes [#1637](https://github.com/eslint/eslint/issues/1637)) (Espen Hovlandsdal)
* New: Adds skipBlankLines option to the no-trailing-spaces rule (fixes [#2303](https://github.com/eslint/eslint/issues/2303)) (Andrew Vaughan)
* New: Check --stdin-filename by ignore settings (fixes [#2432](https://github.com/eslint/eslint/issues/2432)) (Aliaksei Shytkin)
* New: linebreak-style rule (fixes [#1255](https://github.com/eslint/eslint/issues/1255)) (Erik Müller)
* New: no-unneeded-ternary rule to disallow boolean literals in conditional expressions (fixes [#2391](https://github.com/eslint/eslint/issues/2391)) (Gyandeep Singh)
* New: Shareable configs (fixes [#2415](https://github.com/eslint/eslint/issues/2415)) (Nicholas C. Zakas)

## Enhancements

* Update: Add "none" option to operator-linebreak rule (fixes [#2295](https://github.com/eslint/eslint/issues/2295)) (Casey Visco)
* Update: Add uninitialized and initialized options (fixes [#2206](https://github.com/eslint/eslint/issues/2206)) (Ian VanSchooten)
* Update: Exception option for `no-extend-native` and `no-native-reassign` (fixes [#2355](https://github.com/eslint/eslint/issues/2355)) (Gyandeep Singh)
* Update: key-spacing groups must be consecutive lines (fixes [#1728](https://github.com/eslint/eslint/issues/1728)) (Brandon Mills)

## Documentation

* Docs: Add `restParams` to `ecmaFeatures` options list (refs: [#2346](https://github.com/eslint/eslint/issues/2346)) (Bogdan Savluk)
* Docs: grammar fix in no-sync (Tony Lukasavage)
* Docs: Sort the rules (Lukas Böcker)
* Docs: Specify language for all code fences, enable corresponding markdownlint rule. (David Anson)
* Docs: Update configuring.md to fix incorrect link. (Ans)
* Docs: Update ecmaFeatures description (Nicholas C. Zakas)
