---
layout: post
title: ESLint 0.20.0 released
teaser: "We just pushed ESLint 0.20.0, which is a minor release upgrade. This release includes new features and bug fixes."
image: release-notes.png
tags:
  - release
  - breaking change
authors:
  - nzakas
categories:
  - Release Notes
---

## Highlights

This is a summary of the major changes you need to know about for this version of ESLint.

### Updating Rules for ECMAScript 6

We're still getting a fair number of bug reports related to specific ECMAScript 6 features. The good news is that the bug report rate has slowed dramatically, so we're getting to a much more stable place in terms of ES6 support. Keep those bug reports coming!

### Scoped Plugin Support

This release adds support for scoped npm modules (beginning with `@eslint/`, for example). This is a new feature that npm recently released, and we're happy to follow up by allowing you to use scoped packages as ESLint plugins. See [#2360](https://github.com/eslint/eslint/issues/2360) for more information.

### 1.0.0 Update

With the ESTree changes in, we just have a few outstanding issues before releasing 1.0.0. Those issues are:

* [#2302](https://github.com/eslint/eslint/issues/2302) - create a way to bootstrap `.eslintrc` files for new users
* [#2284](https://github.com/eslint/eslint/issues/2284) - should we switch to using 1-based column numbers instead of 0-based column numbers?
* [#2226](https://github.com/eslint/eslint/issues/2226) - split space-in-brackets rule; implement array-literal-spacing and computed-property-spacing rules.
* [#2225](https://github.com/eslint/eslint/issues/2225) - split space-in-brackets rule; implement curly-braces-spacing rule.

Reminder: we are preparing a list of breaking changes that will be coming in v1.0.0 and are tracking them on [[[#1898](https://github.com/eslint/eslint/issues/1898)](https://github.com/eslint/eslint/issues/1898)](https://github.com/eslint/eslint/issues/1898). Stay tuned to that issue so you know what to expect.

## Bug Fixes

* Fix: Add `v8` module to no-mixed-requires rule (fixes [#2320](https://github.com/eslint/eslint/issues/2320)) (Gyandeep Singh)
* Fix: allow plugins to be namespaced (fixes [#2360](https://github.com/eslint/eslint/issues/2360)) (Seth Pollack)
* Fix: Column position in space-infix-ops rule (fixes [#2354](https://github.com/eslint/eslint/issues/2354)) (Gyandeep Singh)
* Fix: key-spacing with single properties (fixes [#2311](https://github.com/eslint/eslint/issues/2311)) (Brandon Mills)
* Fix: Load .eslintrc in $HOME only if no other .eslintrc is found (fixes [#2279](https://github.com/eslint/eslint/issues/2279)) (Jasper Woudenberg)
* Fix: newline-after-var declare and export (fixes [#2325](https://github.com/eslint/eslint/issues/2325)) (Gyandeep Singh)
* Fix: newline-after-var to ignore declare in for specifiers (fixes [#2317](https://github.com/eslint/eslint/issues/2317)) (Gyandeep Singh)
* Fix: space-in-brackets to work with modules (fixes [#2216](https://github.com/eslint/eslint/issues/2216)) (Nicholas C. Zakas)
* Fix: support arrow functions in no-extra-parens (fixes [#2367](https://github.com/eslint/eslint/issues/2367)) (Michael Ficarra)

## Features

* New: add --stdin-filename option (fixes [#1950](https://github.com/eslint/eslint/issues/1950)) (Mordy Tikotzky)
* New: object-shorthand rule (refs: [#1617](https://github.com/eslint/eslint/issues/1617)) (Jamund Ferguson)

## Enhancements

* Update: backticks support for quotes rule (fixes [#2153](https://github.com/eslint/eslint/issues/2153)) (borislavjivkov)
* Update: one-var: enable let & const (fixes [#2301](https://github.com/eslint/eslint/issues/2301)) (Joey Baker)
* Update: Use `Object.assign()` polyfill for all object merging (fixes [#2348](https://github.com/eslint/eslint/issues/2348)) (Sindre Sorhus)

## Documentation

* Docs: `no-invalid-regexp`: add `ecmaFeatures` flags for `u`/`y` (Jordan Harband)
* Docs: Add meteor to avaiable environments list (bartmichu)
* Docs: Some typos and grammar. (AlexKVal)
* Docs: Update markdownlint dependency, resolve/suppress new issues. (David Anson)
