---
layout: post
title: ESLint 0.19.0 released
teaser: "We just pushed ESLint 0.19.0, which is a minor release upgrade. This release includes new features and bug fixes."
image: release-notes.png
tags:
  - release
  - breaking change
authors:
  - nzakas
categories:
  - Release Notes
---

## Highlights

This is a summary of the major changes you need to know about for this version of ESLint.

### More ECMAScript 6 fixes

This release addresses the root cause of several issues related to ECMAScript 6 features. We previously were having a lot of trouble with scoping issues related to modules, destructuring, and destructured parameters. In this release, we fixed a whole host of such errors so our ES6 support should be really solid at this point.

### ESTree Support for Default and Rest Parameters

The big parser upgrade to support the [ESTree](https://github.com/estree/estree/blob/master/es6.md) format for default and rest parameters is now complete. You can feel free to create custom rules using these features and feel confident knowing that the AST format will not be changing.

### 1.0.0 Update

With the ESTree changes in, we just have a few outstanding issues before releasing 1.0.0. Those issues are:

* [#2284](https://github.com/eslint/eslint/issues/2284) - should we switch to using 1-based column numbers instead of 0-based column numbers?
* [#2226](https://github.com/eslint/eslint/issues/2226) - split space-in-brackets rule; implement array-literal-spacing and computed-property-spacing rules.
* [#2225](https://github.com/eslint/eslint/issues/2225) - split space-in-brackets rule; implement curly-braces-spacing rule.

Reminder: we are preparing a list of breaking changes that will be coming in v1.0.0 and are tracking them on [[#1898](https://github.com/eslint/eslint/issues/1898)](https://github.com/eslint/eslint/issues/1898). Stay tuned to that issue so you know what to expect.

## Bug Fixes

* Fix: `no-empty` rule should allow any comments (fixes [#2188](https://github.com/eslint/eslint/issues/2188)) (Gyandeep Singh)
* Fix: Allow inline comments in newline-after-var rule (fixes [#2229](https://github.com/eslint/eslint/issues/2229)) (Casey Visco)
* Fix: block-scoped-var to work with classes (fixes [#2280](https://github.com/eslint/eslint/issues/2280)) (Nicholas C. Zakas)
* Fix: camelcase rule with {properties: never} shouldn't check assignment (fixes [#2189](https://github.com/eslint/eslint/issues/2189)) (Gyandeep Singh)
* Fix: Consider tabs for space-in-parens rule (fixes [#2191](https://github.com/eslint/eslint/issues/2191)) (Josh Quintana)
* Fix: Don't check concise methods in quote-props (fixes [#2251](https://github.com/eslint/eslint/issues/2251)) (Nicholas C. Zakas)
* Fix: duplicate semi and no-extra-semi errors (fixes [#2207](https://github.com/eslint/eslint/issues/2207)) (Brandon Mills)
* Fix: Function id missing in parent scope when using ecmaFeature `modules` for rule block-scoped-var (fixes [#2242](https://github.com/eslint/eslint/issues/2242)) (Michael Ferris)
* Fix: Handle comment lines in newline-after-var (fixed [#2237](https://github.com/eslint/eslint/issues/2237)) (Casey Visco)
* Fix: Ignore single lines for vertical alignment (fixes [#2018](https://github.com/eslint/eslint/issues/2018)) (Ian VanSchooten)
* Fix: no-undef and no-underscore-dangle to use double quotes (fixes [#2258](https://github.com/eslint/eslint/issues/2258)) (Gyandeep Singh)
* Fix: padded-blocks with ASI (fixes [#2273](https://github.com/eslint/eslint/issues/2273)) (Brandon Mills)
* Fix: Report better location for padded-blocks error (fixes [#2224](https://github.com/eslint/eslint/issues/2224)) (Nicholas C. Zakas)
* Fix: Require semicolon after import/export statements (fixes [#2174](https://github.com/eslint/eslint/issues/2174)) (Gyandeep Singh)
* Fix: semi error on export declaration (fixes [#2194](https://github.com/eslint/eslint/issues/2194)) (Brandon Mills)

## Features

* New: Allow modifying base config (fixes [#2143](https://github.com/eslint/eslint/issues/2143)) (Meo)
* New: no-continue rule (fixes [#1945](https://github.com/eslint/eslint/issues/1945)) (borislavjivkov)
* New: operator-linebreak rule (fixes [#1405](https://github.com/eslint/eslint/issues/1405)) (Benoît Zugmeyer)

## Enhancements

* Update: Add test for no-undef (fixes [#2214](https://github.com/eslint/eslint/issues/2214)) (Nicholas C. Zakas)

## Build Related

* Build: Add linting of Markdown files to "npm test" script (fixes [#2182](https://github.com/eslint/eslint/issues/2182)) (David Anson)
* Build: Fix gensite task to work even if files are missing (Nicholas C. Zakas)
* Build: Fixing site generation (Ilya Volodin)
* Build: Remove jshint files (fixes [#2222](https://github.com/eslint/eslint/issues/2222)) (Jeff Tan)

## Dependency Upgrades

* Upgrade: Espree to 1.12.3 (fixes [#2195](https://github.com/eslint/eslint/issues/2195)) (Gyandeep Singh)
* Upgrade: Espree 2.0.0 and escope 3.0.0 (fixes [#2234](https://github.com/eslint/eslint/issues/2234), fixes [#2201](https://github.com/eslint/eslint/issues/2201), fixes (Nicholas C. Zakas)
* Upgrade: Espree to 2.0.1 (Nicholas C. Zakas)

## Documentation

* Docs: Fix spell in camelcase doc (fixes [#2190](https://github.com/eslint/eslint/issues/2190)) (Gyandeep Singh)
* Docs: Fix typo in command-line-interface.md (Nate Eagleson)
* Docs: Fix typo in working-with-rules.md (Nate Eagleson)
* Docs: Fixing broken links in documentation (Ilya Volodin)
* Docs: Improve grammar and style in comma-dangle.md (Nate Eagleson)
* Docs: Improve grammar and style in padded-blocks.md (Nate Eagleson)
* Docs: no-empty fix comment change (refs [#2188](https://github.com/eslint/eslint/issues/2188)) (Gyandeep Singh)
* Docs: Remove hard tabs from *.md, enable corresponding markdownlint rule. (David Anson)
* Docs: Remove trailing spaces, enable corresponding markdownlint rule. (David Anson)
* Docs: Standardize on '*' for unordered lists, enable corresponding markdownlint rule. (David Anson)
* Docs: Update --no-ignore warning (Brandon Mills)
* Docs: Update one-var documentation (fixes [#2210](https://github.com/eslint/eslint/issues/2210)) (Nicholas C. Zakas)
* Docs: Update processors description (Nicholas C. Zakas)
* Docs: Update URL in no-wrap-func.md to resolve 404 (Nate Eagleson)
