---
layout: post
title: ESLint 0.18.0 released
teaser: "We just pushed ESLint 0.18.0, which is a minor release upgrade. This release includes new features and bug fixes."
image: release-notes.png
tags:
  - release
  - breaking change
authors:
  - nzakas
categories:
  - Release Notes
---

## Highlights

This is a summary of the major changes you need to know about for this version of ESLint.

### More Changes to JSX/React handling

Following up on the removal of React semantics in 0.17.0, we discovered that there was some lingering pieces of code that were still looking at React semantics that had been missed. So, we removed those extra bits of code so that ESLint is now completely free of React semantics. We will parse JSX fine, but we are not applying any semantics to the syntax.

If you're using React and want proper handling of identifiers, please use the excellent [eslint-plugin-react](https://github.com/yannickcr/eslint-plugin-react).

### Even More ECMAScript 6 fixes

The bug reports for ECMAScript 6 features are continuing to roll in, and we're working quickly to address those bugs as they appear. The standardization of ECMAScript 6 and its ESTree representation means we can really dig in and finalize functionality now.

### Website Reorganization

A big part of this release has been the reorganization of [eslint.org](https://eslint.org). All content is still available, and is now separated into a User Guide and a Developer Guide. We've also moved some of the content directly into the [website repo](https://github.com/eslint/eslint.github.io) so that it's easier to make changes. The majority of documentation still lives in the main ESLint repo, we've just moved out static information that isn't release-bound.

### 1.0.0 Update

To repeat the same announcement from the 0.17.0 release, the biggest remaining task is to use the finalized AST node structure for rest and default parameters as well as switching to use the new `handler` property of `TryStatement`. Espree needs to be updated with the new nodes before we can start that integration process.

We are preparing a list of breaking changes that will be coming in v1.0.0 and are tracking them on [#1898](https://github.com/eslint/eslint/issues/1898). Stay tuned to that issue so you know what to expect.

## Breaking Changes

* Breaking: Remove JSX support from no-undef (fixes [#2093](https://github.com/eslint/eslint/issues/2093)) (Nicholas C. Zakas)
* Breaking: rule no-empty also checking for empty catch blocks. (fixes [#1841](https://github.com/eslint/eslint/issues/1841)) (Dieter Oberkofler)

## Bug Fixes

* Fix: Add "Error" to the "new-cap" rule exceptions (fixes [#2098](https://github.com/eslint/eslint/issues/2098)) (Mickaël Tricot)
* Fix: arrow functions need wrapping (fixes [#2113](https://github.com/eslint/eslint/issues/2113)) (Nicholas C. Zakas)
* Fix: block-scoped-var to handle imports (fixes [#2087](https://github.com/eslint/eslint/issues/2087)) (Nicholas C. Zakas)
* Fix: Don't crash on empty array pattern item (fixes [#2111](https://github.com/eslint/eslint/issues/2111)) (Nicholas C. Zakas)
* Fix: Don't error on destructured params (fixes [#2051](https://github.com/eslint/eslint/issues/2051)) (Nicholas C. Zakas)
* Fix: Don't warn about destructured catch params (fixes [#2125](https://github.com/eslint/eslint/issues/2125)) (Nicholas C. Zakas)
* Fix: Ensure piped in code will trigger correct errors (fixes [#2154](https://github.com/eslint/eslint/issues/2154)) (Nicholas C. Zakas)
* Fix: func-names with ES6 classes (fixes [#2103](https://github.com/eslint/eslint/issues/2103)) (Marsup)
* Fix: indent crash on caseless switch (fixes [#2144](https://github.com/eslint/eslint/issues/2144)) (Brandon Mills)
* Fix: key-spacing crash on computed properties (fixes [#2120](https://github.com/eslint/eslint/issues/2120)) (Brandon Mills)
* Fix: Mark variables as used in module scope (fixes [#2137](https://github.com/eslint/eslint/issues/2137)) (Nicholas C. Zakas)
* Fix: markVariableAsUsed() should work in Node.js env (fixes [#2089](https://github.com/eslint/eslint/issues/2089)) (Nicholas C. Zakas)
* Fix: no-constant-condition should not flag += (fixes [#2155](https://github.com/eslint/eslint/issues/2155)) (Nicholas C. Zakas)
* Fix: no-dupe-args to work with destructuring (fixes [#2148](https://github.com/eslint/eslint/issues/2148)) (Nicholas C. Zakas)
* Fix: Unused recursive functions should be flagged (issue2095) (Nicholas C. Zakas)
* Fix: vars-on-top conflict with ES6 import (fixes [#2099](https://github.com/eslint/eslint/issues/2099)) (Gyandeep Singh)

## Features

* New: Add "always" and "never" options to "one-var" rule. (fixes [#1619](https://github.com/eslint/eslint/issues/1619)) (Danny Fritz)
* New: Added option int32Hint for space-infix-ops (fixes [#1295](https://github.com/eslint/eslint/issues/1295)) (Kirill Efimov)
* New: newline-after-var rule (fixes [#2057](https://github.com/eslint/eslint/issues/2057)) (Gopal Venkatesan)
* New: no-param-reassign rule (fixes [#1599](https://github.com/eslint/eslint/issues/1599)) (Nat Burns)
* New: space-before-function-paren rule (fixes [#2028](https://github.com/eslint/eslint/issues/2028)) (Brandon Mills)

## Enhancements

* Update: Omit setter param from no-unused-vars (fixes [#2133](https://github.com/eslint/eslint/issues/2133)) (Nicholas C. Zakas)
* Update: rule camelcase to allow snake_case in object literals. (fixes [#1919](https://github.com/eslint/eslint/issues/1919)) (Dieter Oberkofler)

## Documentation

* Docs: Adding back deprecated space-unary-word-ops documentation (Ilya Volodin)
* Docs: Cleaning dead links (Ilya Volodin)
* Docs: Fixed JSON syntax (Sajin)
* Docs: Fixing broken links (Ilya Volodin)
* Docs: Moving documentation out of the repository and modifying build scripts (Ilya Volodin)
* Docs: Update link to Documentation (Kate Lizogubova)
