---
layout: post
title: ESLint 0.17.0 released
teaser: "We just pushed ESLint 0.17.0, which is a minor release upgrade. This release includes new features and bug fixes."
image: release-notes.png
tags:
  - release
  - breaking change
authors:
  - nzakas
categories:
  - Release Notes
---

## Highlights

This is a summary of the major changes you need to know about for this version of ESLint.

### Changes to JSX/React handling

In this release, we made the decision to stop supporting React semantics of JSX. We had previously been checking JSX for identifiers in our rules and realized we could only do that correctly by building-in knowledge of how React works. Such knowledge already hurt us when the semantics changed a bit, and we really didn't want to find ourselves in that situation again.

ESLint will continue to support JSX syntax but will no longer apply React semantics to that syntax. Since we know that many ESLint users want React semantics, we've ensured there's a way for the excellent [eslint-plugin-react](https://github.com/yannickcr/eslint-plugin-react) to fill this gap. Specifically, we've added a new method that is available to rules that can indicate a variable has been used. Many of the React-based errors people were reporting related directly to interpretation of when variables had been used, and this change lets other plugin authors augment what ESLint thinks has been used.

### More ECMAScript 6 fixes

As a result of being the first tool to fully support ECMAScript 6, we've found a lot of bugs and issues both in ESLint and our dependencies. We've been working as quickly as possible to fix issues and work with other projects to fix their issues as well.

### Deprioritizing new rules

Because we are so focused on ECMAScript 6 support, we are deprioritizing adding new rules right now. You may still file issues for rules you'd like, but they likely won't be addressed by the ESLint team until after 1.0.0 is released. We will still accept pull requests for new rules, we just won't be spending much time on implementing new rules ourselves until after 1.0.0.

### 1.0.0 Update

We had hoped this next release would be 1.0.0, but we aren't quite there yet. The biggest remaining task is to use the finalized AST node structure for rest and default parameters as well as switching to use the new `handler` property of `TryStatement`. Espree needs to be updated with the new nodes before we can start that integration process.

We are preparing a list of breaking changes that will be coming in v1.0.0 and are tracking them on [#1898](https://github.com/eslint/eslint/issues/1898). Stay tuned to that issue so you know what to expect.

## Breaking Changes

* Breaking: Stop checking JSX variable use, expose API instead (fixes [#1911](https://github.com/eslint/eslint/issues/1911)) (Glen Mailer)

## Bug Fixes

* Fix: Add comma-dangle allow-multiline (fixes [#1984](https://github.com/eslint/eslint/issues/1984)) (Keith Cirkel)
* Fix: Check spacing of class methods (fixes [#1989](https://github.com/eslint/eslint/issues/1989)) (Nicholas C. Zakas)
* Fix: destructured arguments should work in block-scoped-var (fixes [#1996](https://github.com/eslint/eslint/issues/1996)) (Nicholas C. Zakas)
* Fix: Don't explode on default export function (fixes [#1985](https://github.com/eslint/eslint/issues/1985)) (Nicholas C. Zakas)
* Fix: Ignore super in no-undef (refs [#1968](https://github.com/eslint/eslint/issues/1968)) (Nicholas C. Zakas)
* Fix: Line breaking with just carriage return (fixes [#2005](https://github.com/eslint/eslint/issues/2005)) (Nicholas C. Zakas)
* Fix: location of new-cap error messages (fixes [#2025](https://github.com/eslint/eslint/issues/2025)) (Mathias Schreck)
* Fix: module import specifiers should be defined (refs [#1978](https://github.com/eslint/eslint/issues/1978)) (Nicholas C. Zakas)

## Features

* New: generator-star-spacing rule (fixes [#1680](https://github.com/eslint/eslint/issues/1680), fixes [#1949](https://github.com/eslint/eslint/issues/1949)) (Brandon Mills)
* New: no-duplicate-case rule to disallow a duplicate case label (fixes [#2015](https://github.com/eslint/eslint/issues/2015)) (Dieter Oberkofler)

## Enhancements

* Update: Add AST node exceptions to comma-style. (fixes [#1932](https://github.com/eslint/eslint/issues/1932)) (Evan Simmons)

## Dependency Upgrades

* Upgrade: Espree to v0.12.0 (refs [#1968](https://github.com/eslint/eslint/issues/1968)) (Nicholas C. Zakas)

## Documentation

* Clarify issue requirement for doc pull requests (Ian)
* Docs: Add spread operator to available language options (Nicholas C. Zakas)
