---
layout: post
title: ESLint 0.16.0 released
teaser: "We just pushed ESLint 0.16.0, which is a minor release upgrade. This release includes new features and bug fixes."
image: release-notes.png
tags:
  - release
  - breaking change
authors:
  - nzakas
categories:
  - Release Notes
---

## Highlights

This is a summary of the major changes you need to know about for this version of ESLint.

### Complete ECMAScript 6 support

0.16.0 adds more language options for parsing JavaScript, including:

* Classes
* Modules

Both of these options are off by default, and you can enable them in your configuration file. See [Configuring ESLint](https://eslint.org/docs/user-guide/configuring) for more information.

Classes and modules follow the newly-standardized [estree](https://github.com/estree/estree/) AST node structure, and so these changes may not be completely compatible with older parsers that have not yet upgraded.

We've included a new `es6` environment that enables all ECMAScript 6 features *except* modules. Since modules imply global strict mode, that puts the parser into a different mode. You'll need to manually opt-in to using modules via `ecmaFeatures.modules`. So if you are using ECMAScript 6 modules in your project, you'll want to enable the `es6` environment in addition to `ecmaFeatures.modules`.

**Note:** The AST structure for default parameters and rest parameters is still undergoing change and discussion. We recommend not creating custom rules using default or rest parameters until after ESLint 1.0.0.

### Single-line disable comment

Due to popular demand, we've added a new way to disable rules on a single line:

```js
// disables just semi for this line
doSomething()  //eslint-disable-line semi

// disables all rules for this line
doSomething()  //eslint-disable-line
```

Keep in mind that the comment must be at the end of the line you want to disable.

### 1.0.0 Update

We're getting even closer to 1.0.0. The biggest remaining task is to use the finalized AST node structure for rest and default parameters as well as switching to use the new `handler` property of `TryStatement`.

We are preparing a list of breaking changes that will be coming in v1.0.0 and are tracking them on [#1898](https://github.com/eslint/eslint/issues/1898). Stay tuned to that issue so you know what to expect.

## Breaking Changes

* Breaking: change no-comma-dangle to comma-dangle (fixes [#1350](https://github.com/eslint/eslint/issues/1350)) (Mathias Schreck)
* Breaking: Change no-space-before-semi to semi-spacing and add "after" option (fixes [#1671](https://github.com/eslint/eslint/issues/1671)) (Mathias Schreck)
* Breaking: made eol-last less strict (fixes [#1460](https://github.com/eslint/eslint/issues/1460)) (Glen Mailer)

## Bug Fixes

* Fix: allow block bindings in no-inner-declarations (fixes [#1893](https://github.com/eslint/eslint/issues/1893)) (Roberto Vidal)
* Fix: Better error when given null as rule config (fixes [#1760](https://github.com/eslint/eslint/issues/1760)) (Glen Mailer)
* Fix: block-scoped-var to work with destructuring (fixes [#1863](https://github.com/eslint/eslint/issues/1863)) (Nicholas C. Zakas)
* Fix: comma-spacing should ignore JSX text (fixes [#1916](https://github.com/eslint/eslint/issues/1916)) (Brandon Mills)
* Fix: Comment configuration of rule doesn't work (fixes [#1792](https://github.com/eslint/eslint/issues/1792)) (Jary)
* Fix: getScope and no-use-before-define for arrow functions (fixes [#1895](https://github.com/eslint/eslint/issues/1895)) (Brandon Mills)
* Fix: Make no-inner-declarations look for arrow functions (fixes [#1892](https://github.com/eslint/eslint/issues/1892)) (Brandon Mills)
* Fix: Make no-unused-vars ignore exports (fixes [#1903](https://github.com/eslint/eslint/issues/1903)) (Nicholas C. Zakas)
* Fix: Pass correct sourceType to escope (fixes [#1959](https://github.com/eslint/eslint/issues/1959)) (Nicholas C. Zakas)
* Fix: Rest args should work in no-undef and block-scoped-var (fixes [#1543](https://github.com/eslint/eslint/issues/1543)) (Nicholas C. Zakas)
* Fix: Scoping for Node.js (fixes [#892](https://github.com/eslint/eslint/issues/892)) (Nicholas C. Zakas)
* Fix: space-before-function-parentheses and object methods (fixes [#1920](https://github.com/eslint/eslint/issues/1920)) (Brandon Mills)
* Fix: strict rule should honor module code (fixes [#1956](https://github.com/eslint/eslint/issues/1956)) (Nicholas C. Zakas)
* Fix: Use unversioned sinon file in browser test (fixes [#1947](https://github.com/eslint/eslint/issues/1947)) (Nicholas C. Zakas)

## Features

* New: Add es6 environment (fixes [#1864](https://github.com/eslint/eslint/issues/1864), fixes [#1944](https://github.com/eslint/eslint/issues/1944)) (Nicholas C. Zakas)
* New: Adding support for "// eslint-disable-line rule" style comments (Billy Matthews)
* New: generator-star middle option (fixes [#1808](https://github.com/eslint/eslint/issues/1808)) (Jamund Ferguson)
* New: no-dupe-args rule (fixes [#1880](https://github.com/eslint/eslint/issues/1880)) (Jamund Ferguson)

## Enhancements

* Update: Add support for custom preprocessors (fixes [#1817](https://github.com/eslint/eslint/issues/1817)) (Ilya Volodin)
* Update: no-empty to check TryStatement.handler (fixes [#1930](https://github.com/eslint/eslint/issues/1930)) (Brandon Mills)
* Update: Remove preferGlobal from package.json (fixes [#1877](https://github.com/eslint/eslint/issues/1877)) (Nicholas C. Zakas)
* Update: space-before-function-parentheses to support generators (fixes [#1929](https://github.com/eslint/eslint/issues/1929)) (Brandon Mills)

## Dependency Upgrades

* Upgrade: Espree to 1.10.0 for classes support (Nicholas C. Zakas)
* Upgrade: Espree to v1.11.0 (Nicholas C. Zakas)

## Documentation

* Docs: Add mention of compatible parsers (Nicholas C. Zakas)
* Docs: no-plusplus.md - auto semicolon insertion (Miroslav Obradović)
* Docs: Update docs for token-related methods (fixes [#1878](https://github.com/eslint/eslint/issues/1878)) (Nicholas C. Zakas)
* Docs: Update ecmaFeatures list (fixes [#1942](https://github.com/eslint/eslint/issues/1942)) (Nicholas C. Zakas)
* Docs: Use union types in TokenStore JSDoc (refs [#1878](https://github.com/eslint/eslint/issues/1878)) (Brandon Mills)
