---
layout: post
title: ESLint 0.15.0 released
teaser: "We just pushed ESLint 0.15.0, which is a minor release upgrade. This release includes new features and bug fixes."
image: release-notes.png
tags:
  - release
  - breaking change
authors:
  - nzakas
categories:
  - Release Notes
---

## Highlights

This is a summary of the major changes you need to know about for this version of ESLint.

### More Language Options

0.15.0 adds more language options for parsing JavaScript, including:

* Spread operator
* Rest parameters
* Destructuring

All of these options are off by default, and you can enable them in your configuration file. See [Configuring ESLint](https://eslint.org/docs/user-guide/configuring) for more information.

**Note:** The AST structure for default parameters and rest parameters is still undergoing change and discussion. We recommend not creating custom rules using default or rest parameters until after ESLint 1.0.0.

### New Rule: space-before-function-parentheses

We had a significant gap in spacing after function names and before anonymous function parentheses. In order to cover this case, we removed `checkFunctionKeyword` option from `space-after-keywords` and deprecated `space-after-function-name` (it will be removed in 1.0.0). You should switch your code to use the new [`space-before-function-parentheses`](https://eslint.org/docs/rules/space-before-function-parentheses) as soon as possible.

### 1.0.0 Update

We're very close to 1.0.0. The last piece we're waiting for is to have the ECMAScript 6 AST finalized so that it's safe to start writing custom rules using ES6 nodes. You can follow that progress at the [estree](https://github.com/estree/estree/) project.

## Breaking Changes

* Breaking: space-before-function-parentheses replaces space-after-function-name and checkFunctionKeyword (fixes [#1618](https://github.com/eslint/eslint/issues/1618)) (Mathias Schreck)

## Bug Fixes

* Fix: Don't count else-if in max-depth (fixes [#1835](https://github.com/eslint/eslint/issues/1835)) (Nicholas C. Zakas)
* Fix: Don't flag for-of statement (fixes [#1852](https://github.com/eslint/eslint/issues/1852)) (Nicholas C. Zakas)
* Fix: Enable globalReturn for Node.js environment (fixes [#1158](https://github.com/eslint/eslint/issues/1158)) (Nicholas C. Zakas)
* Fix: Location of extra paren message (fixes [#1814](https://github.com/eslint/eslint/issues/1814)) (Nicholas C. Zakas)
* Fix: make rules work with for-of statements (fixes [#1859](https://github.com/eslint/eslint/issues/1859)) (Mathias Schreck)
* Fix: new-cap should allow defining exceptions (fixes [#1424](https://github.com/eslint/eslint/issues/1424)) (Brian Di Palma)
* Fix: Remove unnecessary file exists check (fixes [#1831](https://github.com/eslint/eslint/issues/1831)) (Nicholas C. Zakas)

## Features

* New: multi-line option for the curly rule (fixes [#1812](https://github.com/eslint/eslint/issues/1812)) (Hugo Wood)
* New: rule no-throw-literal added (fixes [#1791](https://github.com/eslint/eslint/issues/1791)) (Dieter Oberkofler)

## Enhancements

* Update: Add requireReturnDescription for valid-jsdoc (fixes [#1833](https://github.com/eslint/eslint/issues/1833)) (Brian Di Palma)
* Update: Backslashes in path (fixes [#1818](https://github.com/eslint/eslint/issues/1818)) (Jan Schär)

## Dependency Upgrades

* Upgrade: Espree to 1.9.1 (fixes [#1816](https://github.com/eslint/eslint/issues/1816), fixes [#1805](https://github.com/eslint/eslint/issues/1805)) (Nicholas C. Zakas)

## Documentation

* Docs: Change customformat value to path (suisho)
* Docs: Add a missing word in the Contributing doc (Ben Linskey)
* Docs: add webpack loader to the docs/integrations page (Maxime Thirouin)
* Docs: fix typo in configuring docs (mendenhallmagic)
* Docs: Fix typo in wrap-iife rule doc title (Ben Linskey)
* Docs: Update pages to fix rendering of lists (David Anson)
* Docs: Update pages to fix rendering of lists and fenced code blocks (David Anson)

# Build Related

* Build: Test using io.js as well (Nicholas C. Zakas)
