---
layout: post
title: ESLint 0.14.0 released
teaser: "We just pushed ESLint 0.14.0, which is a minor release upgrade. This release includes new features and bug fixes."
image: release-notes.png
tags:
  - release
  - breaking change
authors:
  - okuryu
categories:
  - Release Notes
---

## Highlights

This is a summary of the major changes you need to know about for this version of ESLint.

### More Language Options

0.14.0 adds more language options for parsing JavaScript, including:

* ECMAScript 6 arrow functions
* Global `return` statements (for use with Node.js scripts)

All of these options are off by default, and you can enable them in your configuration file. See [Configuring ESLint](https://eslint.org/docs/user-guide/configuring) for more information.

### ECMAScript 6 fixes

With the introduction of ECMAScript 6 features, a lot of bugs popped up that had to be tracked down. We fixed a large number of bugs related to ES6 features so things like variable scoping should be fairly accurate now.

### New Rule: indent

A rule covering indentation has been one of our long-requested features since ESLint began. We ported the logic from JSCS into a new rule, [indent](https://eslint.org/docs/rules/indent). It has been modified so it's not exactly the same, and although we provided incorrect attribution initially, that has been fixed to comply with JSCS's licensing terms. We thank the JSCS team for bringing this to our attention so we could ensure property attribution.

### 1.0.0 is Coming!

We expect to have only a small number of releases before 1.0.0 is released. Our goal is ensuring stability and trying to avoid breaking changes after 1.0.0. To that end, we are going to wait until we see breaking changes stop for a couple of releases before being ready to declare a release as 1.0.0.

## Breaking Changes

* Breaking: Exit code is now error count (Nicholas C. Zakas)
* Breaking: remove implied eval check from no-eval (fixes [#1202](https://github.com/eslint/eslint/issues/1202)) (Mathias Schreck)
* Breaking: Remove node from results (fixes [#957](https://github.com/eslint/eslint/issues/957)) (Nicholas C. Zakas)
* Breaking: Show error and warning counts in stylish summary (fixes [#1746](https://github.com/eslint/eslint/issues/1746)) (Brandon Mills)

## Bug Fixes

* Fix: Allow single line else-if (fixes [#1739](https://github.com/eslint/eslint/issues/1739)) (Nicholas C. Zakas)
* Fix: comma-spacing for template literals (fixes [#1736](https://github.com/eslint/eslint/issues/1736)) (Nicholas C. Zakas)
* Fix: Don't crash when $HOME isn't set (fixes [#1465](https://github.com/eslint/eslint/issues/1465)) (Nicholas C. Zakas)
* Fix: Don't throw error for arguments (fixes [#1759](https://github.com/eslint/eslint/issues/1759)) (Nicholas C. Zakas)
* Fix: Don't warn on computed nonliteral properties (fixes [#1762](https://github.com/eslint/eslint/issues/1762)) (Nicholas C. Zakas)
* Fix: Ensure template string references count (fixes [#1542](https://github.com/eslint/eslint/issues/1542)) (Nicholas C. Zakas)
* Fix: Make no-multi-spaces work for every case (fixes [#1603](https://github.com/eslint/eslint/issues/1603), fixes [#1659](https://github.com/eslint/eslint/issues/1659)) (Nicholas C. Zakas)
* Fix: no-undef to work with arrow functions (fixes [#1604](https://github.com/eslint/eslint/issues/1604)) (Nicholas C. Zakas)
* Fix: Scoping issues for no-unused-vars (fixes [#1733](https://github.com/eslint/eslint/issues/1733)) (Nicholas C. Zakas)
* Fix: Scoping issues for no-unused-vars (fixes [#1741](https://github.com/eslint/eslint/issues/1741)) (Nicholas C. Zakas)
* Fix: Support exceptions in no-multi-spaces (fixes [#1755](https://github.com/eslint/eslint/issues/1755)) (Brandon Mills)

## Features

* New: Add predefined Meteor globals (fixes [#1763](https://github.com/eslint/eslint/issues/1763)) (Johan Brook)
* New: Allow parser to be configured (fixes [#1624](https://github.com/eslint/eslint/issues/1624)) (Nicholas C. Zakas)
* New: Rule indent (fixes [#1022](https://github.com/eslint/eslint/issues/1022)) (Dmitriy Shekhovtsov)
* New: Rule indent (fixes [#1022](https://github.com/eslint/eslint/issues/1022)) (Dmitriy Shekhovtsov)
* Revert "New: Rule indent (fixes [#1022](https://github.com/eslint/eslint/issues/1022))" (Nicholas C. Zakas)

## Enhancements

* Update: Add getNodeByRangeIndex method (refs [#1755](https://github.com/eslint/eslint/issues/1755)) (Brandon Mills)
* Update: Check all assignments for consistent-this (fixes [#1513](https://github.com/eslint/eslint/issues/1513)) (Timothy Jones)
* Update: CLIEngine results include warning and error count (fixes [#1732](https://github.com/eslint/eslint/issues/1732)) (gyandeeps)
* Update: Fast-path for empty input (fixes [#546](https://github.com/eslint/eslint/issues/546)) (Nicholas C. Zakas)
* Update: fix eslint indentations (fixes [#1770](https://github.com/eslint/eslint/issues/1770)) (Dmitriy Shekhovtsov)
* Update: Fix indentation of comment (Nicholas C. Zakas)
* Update: Improve CLIEngine.getFormatter() (refs [#1723](https://github.com/eslint/eslint/issues/1723)) (Nicholas C. Zakas)
* Update: Make rules work with arrow functions (fixes [#1508](https://github.com/eslint/eslint/issues/1508), fixes [#1509](https://github.com/eslint/eslint/issues/1509), fixes [#1493](https://github.com/eslint/eslint/issues/1493)) (Nicholas C. Zakas)
* Update: Replace getTokenByRange(Index->Start) (refs [#1721](https://github.com/eslint/eslint/issues/1721)) (Brandon Mills)

## Dependency Upgrades

* Upgrade: Espree to version 1.8.0 (Nicholas C. Zakas)

## Documentation

* Docs: Add Backbone plugin link (Ilya Volodin)
* Docs: Added `eslint-enable` inline (Ivan Fraixedes)
* Docs: Added double quotes for JSON keys for comma-spacing and key-spacing rule (Dmitry Polovka)
* Docs: Correct getFormatter() documentation (refs [#1723](https://github.com/eslint/eslint/issues/1723)) (Nicholas C. Zakas)
* Docs: fixed typo in consistent-return docs (Vitor Balocco)
* Docs: fixed typo in no-lone-blocks docs (Vitor Balocco)
* Docs: Forgotten parentheses in code snippet (Ivan Fraixedes)
* Docs: use npm's keyword route (Tom Vincent)

# Build Related

* Build: Add Node.js 0.12 testing (Nicholas C. Zakas)
* Build: Update sitegen script (Closes [#1725](https://github.com/eslint/eslint/issues/1725)) (Ilya Volodin)
