---
layout: post
title: ESLint 0.13.0 released
teaser: "We just pushed ESLint 0.13.0, which is a minor release upgrade. This release includes new features and bug fixes."
image: release-notes.png
tags:
  - release
  - breaking change
authors:
  - nzakas
categories:
  - Release Notes
---

## Highlights

This is a summary of the major changes you need to know about for this version of ESLint.

### More ECMAScript 6 support

0.13.0 adds more support for several ECMAScript 6, including:

* Template strings
* Default parameters
* Unicode code point escapes

All of these options are off by default, and you can enable them in your configuration file. See [Configuring ESLint](https://eslint.org/docs/user-guide/configuring) for more information.

### Breaking: Block scoping

Additionally, 0.13.0 has full support for block scoping (`let` and `const`), so all scope-related rules should work the way you expect. This is a breaking change because if you were previously using `let` and `const`, the scope was being calculated incorrectly, and that may result in different behavior than in 0.13.0.

### Deprecating global-strict and no-extra-strict

The `global-strict` and `no-extra-strict` rules have been deprecated in favor of adding this functionality into the `strict` rule. We suggest you upgrade to using the updated `strict` rule as soon as possible. The `global-strict` and `no-extra-strict` rules will be removed when 1.0.0 is released.

## Breaking Changes

* Breaking: Update escope (fixes [#1642](https://github.com/eslint/eslint/issues/1642)) (Nicholas C. Zakas)

## Bug Fixes

* Fix: disregards leading './' in ignore pattern or file name (fixes [#1685](https://github.com/eslint/eslint/issues/1685)) (Chris Montrois)
* Fix: Except object literal methods from func-names (fixes [#1699](https://github.com/eslint/eslint/issues/1699)) (Brandon Mills)
* Fix: generator-star should allow params (fixes [#1677](https://github.com/eslint/eslint/issues/1677)) (Brandon Mills)
* Fix: Make no-redeclare work with let (fixes [#917](https://github.com/eslint/eslint/issues/917)) (Nicholas C. Zakas)
* Fix: Missing undeclared variables in JSX (fixes [#1676](https://github.com/eslint/eslint/issues/1676)) (Yannick Croissant)
* Fix: no-unused-expressions rule incorrectly flagging  yield (fixes [#1672](https://github.com/eslint/eslint/issues/1672)) (Rémi Gérard-Marchant)
* Fix: no-unused-vars for JSX (fixes [#1673](https://github.com/eslint/eslint/issues/1673) and fixes [#1534](https://github.com/eslint/eslint/issues/1534)) (Yannick Croissant)

## Enhancements

* Update: Add allowPattern option for dot-notation rule (fixes [#1679](https://github.com/eslint/eslint/issues/1679)) (Tim Schaub)
* Update: Add CLIEngine.getFormatter() (fixes [#1653](https://github.com/eslint/eslint/issues/1653)) (Nicholas C. Zakas)
* Update: Added globals for: phantom,jquery, prototypejs, shelljs (fixes [#1704](https://github.com/eslint/eslint/issues/1704)) (Dmitriy Shekhovtsov)
* Update: Combine strict mode rules (fixes [#1246](https://github.com/eslint/eslint/issues/1246)) (Brandon Mills)
* Update: no-warning-comments matches on whole word only (fixes [#1709](https://github.com/eslint/eslint/issues/1709)) (Nick Fisher)
* Update: Switch to using estraverse-fb (fixes [#1712](https://github.com/eslint/eslint/issues/1712)) (Nicholas C. Zakas)
* Update: The rule spaced-line-comment now also allows tabs and not only spaces as whitespace. (fixes [#1713](https://github.com/eslint/eslint/issues/1713)) (Dieter Oberkofler)
* Update: use global strict mode everywhere (fixes [#1691](https://github.com/eslint/eslint/issues/1691)) (Brandon Mills)

## Dependency Upgrades

* Upgrade: Espree to 1.7.1 (fixes [#1706](https://github.com/eslint/eslint/issues/1706)) (Nicholas C. Zakas)
* Upgrade: globals module to latest (fixes [#1670](https://github.com/eslint/eslint/issues/1670)) (Nicholas C. Zakas)

## Documentation

* Docs: Add angularjs-eslint link into the integration doc (Emmanuel DEMEY)
* Docs: add Jasmine rules and eslintplugin npm links (Tom Vincent)
* Docs: Add more info about context (fixes [#1330](https://github.com/eslint/eslint/issues/1330)) (Nicholas C. Zakas)
* Docs: Fixed example for the space-return-throw-case rule (mpal9000)
* Docs: Make CLA notice more prominent (Nicholas C. Zakas)
* Docs: Update README FAQ (Nicholas C. Zakas)

# Build Related

* Build: Add JSDoc generation (fixes [#1363](https://github.com/eslint/eslint/issues/1363)) (Nicholas C. Zakas)
