---
layout: post
title: ESLint 0.12.0 released
teaser: "We just pushed ESLint 0.12.0, which is a minor release upgrade. This release includes new features and bug fixes."
image: release-notes.png
tags:
  - release
  - breaking change
authors:
  - nzakas
categories:
  - Release Notes
---

## Highlights

This is a summary of the major changes you need to know about for this version of ESLint.

### Partial ECMAScript 6 support

0.12.0 introduces support for several ECMAScript 6 features, including:

* `let` and `const`
* Regular expression `y` flag
* Regular expression `u` flag
* Binary literals
* Octal literals
* `for-of`
* Generators
* Object literal syntax changes

All of these options are off by default, and you can enable them in your configuration file. See [Configuring ESLint](https://eslint.org/docs/user-guide/configuring) for more information.

We also have two rules that are specific for ES6: [no-var](https://eslint.org/docs/rules/no-var) and [generator-star](https://eslint.org/docs/rules/generator-star).

**Known limitation:** Block scope calculation doesn't work yet for `let` and `const`. We are actively working on fixing that. This may affect rules like [no-unused-vars](https://eslint.org/docs/rules/no-var) until we resolve this (hopefully soon).

### JSX support

0.12.0 also has full support for the [JSX](http://facebook.github.io/jsx/) extension created by Facebook. ESLint now fully supports JSX natively (it's not transformed before linting). JSX parsing is off by default, and you can enable it in your [configuration file](https://eslint.org/docs/user-guide/configuring). This is being tracked in [#917](https://github.com/eslint/eslint/issues/917).

### es6jsx end-of-life

The `es6jsx` branch is now considered obsolete and changes will continue to be merged into the master branch. Please make sure you're using the latest stable ESLint going forward.

## Breaking Changes

* Breaking: Allow parser feature flips (fixes [#1602](https://github.com/eslint/eslint/issues/1602)) (Nicholas C. Zakas)

## Features

* New: gen-star rule (refs [#1617](https://github.com/eslint/eslint/issues/1617)) (Jamund Ferguson)
* New: no-var rule (refs [#1617](https://github.com/eslint/eslint/issues/1617)) (Jamund Ferguson)

## Bug Fixes

* Fix: Allow comments in key-spacing groups (fixes [#1632](https://github.com/eslint/eslint/issues/1632)) (Brandon Mills)
* Fix: Allow individual newlines in space-in-brackets (fixes [#1614](https://github.com/eslint/eslint/issues/1614)) (Brandon Mills)
* Fix: block-scoped-var reports labels (fixes [#1630](https://github.com/eslint/eslint/issues/1630)) (Michael Ficarra)
* Fix: Broken JSX test (Nicholas C. Zakas)
* Fix: Don't warn on JSX literals with newlines (fixes [#1533](https://github.com/eslint/eslint/issues/1533)) (Nicholas C. Zakas)
* Fix: Find JSXIdentifier refs in no-unused-vars (fixes [#1534](https://github.com/eslint/eslint/issues/1534)) (Nicholas C. Zakas)
* Fix: no-bitwise reports on bitwise assignment expressions (fixes [#1643](https://github.com/eslint/eslint/issues/1643)) (Mathias Schreck)
* Fix: Property regex flag checking (fixes [#1537](https://github.com/eslint/eslint/issues/1537)) (Nicholas C. Zakas)
* Fix: quotes rule ignores JSX literals (fixes [#1477](https://github.com/eslint/eslint/issues/1477)) (Nicholas C. Zakas)
* Fix: Support JSX spread operator (fixes [#1634](https://github.com/eslint/eslint/issues/1634)) (Nicholas C. Zakas)
* Fix: Track JSX global variable correctly (fixes [#1534](https://github.com/eslint/eslint/issues/1534)) (Nicholas C. Zakas)

## Enhancements

* Update: Update optionator, --no in help (fixes [#1134](https://github.com/eslint/eslint/issues/1134)) (George Zahariev)
* Update: Add a couple JSX tests (Nicholas C. Zakas)
* Update: Expose ecmaFeatures on context (fixes [#1648](https://github.com/eslint/eslint/issues/1648)) (Nicholas C. Zakas)
* Update: Fully enable JSX support (fixes [#1640](https://github.com/eslint/eslint/issues/1640)) (Nicholas C. Zakas)

## Dependency Upgrades

* Upgrade: several dependencies (fixes [#1377](https://github.com/eslint/eslint/issues/1377)) (Nicholas C. Zakas)

## Documentation

* Docs: Add angularjs-eslint link into the integration doc (Emmanuel DEMEY)
* Docs: add newline to no-process-env (fixes [#1627](https://github.com/eslint/eslint/issues/1627)) (Tom Vincent)
* Docs: Added Fitbit to the list of companies (Igor Zalutsky)
* Docs: Correct alignment in example project tree (Tim Schaub)
* Docs: Document ecmaFeatures (Nicholas C. Zakas)
* Docs: Remove illegal code fence (Nicholas C. Zakas)
* Docs: Remove references to Esprima (Nicholas C. Zakas)
