---
layout: post
title: ESLint 0.11.0 released
teaser: "We just pushed ESLint 0.11.0, which is a minor release upgrade. This release includes new features, bug fixes, and a parser switch."
image: release-notes.png
tags:
  - release
  - breaking change
authors:
  - nzakas
categories:
  - Release Notes
---

## Highlights

This is a summary of the major changes you need to know about for this version of ESLint.

### New parser

0.11.0 is the first version of ESLint to run on our own parser, [Espree](https://github.com/eslint/espree). Espree is currently configured to behave like Esprima 1.2.2, which was the parser that 0.10.0 was using, so you should see no differences in the behavior of ESLint related to the parser change.

Making this change allowed us to fix a couple of bugs we've had open that were related to Esprima issues.

### ECMAScript 5 by default

This is the first release where we've started transitioning all settings to be ECMAScript 5 by default. ECMAScript 5 is the most widely-supported version of JavaScript, and so we want to assume ECMAScript 5 code and allow users to opt-in to ECMAScript 3 and ECMAScript 6 features.

Part of this involved a change made for [#1484](https://github.com/eslint/eslint/issues/1484), which updated the `dot-notation` rule to allow keywords be used (as allowed by ECMAScript 5 but not ECMAScript 3). The option `allowKeywords` was added with a default value of `true` so that you can opt-out of this behavior if you need to support an ECMAScript 3 environment.

This means the following used to result in a warning but no longer does in 0.11.0:

```js
obj.delete = 5;
```

## Breaking Changes

* Breaking: add es3 config option to dot-notation rule (fixes [#1484](https://github.com/eslint/eslint/issues/1484)) (Michael Ficarra)

## Features

* New: Configuration via package.json (fixes [#698](https://github.com/eslint/eslint/issues/698)) (Michael Mclaughlin)
* New: space-after-function-name (fixes [#1340](https://github.com/eslint/eslint/issues/1340)) (Roberto Vidal)

## Bug Fixes

* Fix: Adding regexp literal exception (fixes [#1589](https://github.com/eslint/eslint/issues/1589)) (Greg Cochard)
* Fix: brace-style stroustrup should report on cuddled elseif (fixes [#1583](https://github.com/eslint/eslint/issues/1583)) (Ian Christian Myers)
* Fix: check if next statement is on newline when warning against extra semicolons. (fixes [#1580](https://github.com/eslint/eslint/issues/1580)) (Evan You)
* Fix: column location of key-spacing with additional tokens (fixes [#1458](https://github.com/eslint/eslint/issues/1458)) (Mathias Schreck)
* Fix: function arguments now count towards no-shadow check (fixes [#1584](https://github.com/eslint/eslint/issues/1584)) (Glen Mailer)
* Fix: padded-blocks incorrectly complained on comments (fixes [#1416](https://github.com/eslint/eslint/issues/1416)) (Mathias Schreck)
* Fix: valid-jsdoc should recognize @class (fixes [#1585](https://github.com/eslint/eslint/issues/1585)) (Nicholas C. Zakas)
* Fix: yoda treats negative numbers as literals (fixes [#1571](https://github.com/eslint/eslint/issues/1571)) (Brandon Mills)

## Enhancements

* Update: add yoda exception for range tests (fixes [#1561](https://github.com/eslint/eslint/issues/1561)) (Brandon Mills)
* Update: Set environments w/ globals (fixes [#1577](https://github.com/eslint/eslint/issues/1577)) (Elan Shanker)
* Update: Switch to use Espree (fixes [#1595](https://github.com/eslint/eslint/issues/1595)) (Nicholas C. Zakas)

## Dependency Upgrades

* Upgrade: Update Espree to 1.3.1 (Nicholas C. Zakas)

## Build-Related

* Build: tag correct commit (refs [#1606](https://github.com/eslint/eslint/issues/1606)) (Mathias Schreck)
