---
layout: post
title: ESLint 0.10.0 released
teaser: "We just pushed ESLint 0.10.0, which is a minor release upgrade. This release includes new features, bug fixes, and performance improvements. It does not include support for ECMAScript 6 or JSX, as these have been delayed until 0.11.0."
image: release-notes.png
tags:
  - release
  - breaking change
authors:
  - nzakas
categories:
  - Release Notes
---

## Highlights

This is a summary of the major changes you need to know about for this version of ESLint.

### Command Line Interface

The CLI for ESLint has been updated, including some breaking changes.

First, the `node_modules` directory will automatically be ignored in all projects (#1163). This comes after finding that many projects added `node_modules` to their `.eslintignore` files and fielding many questions about why ESLint was slow (answer: because it was linting `node_modules`).

Second, it's now possible to lint files without an extension (#1131). All you have to do is pass them in on the command line, such as:

```
eslint file-without-ext
```

ESLint will not automatically lint files without extensions in directories that are passed on the command line. You can also pass files without a `.js` extension directly on the command line to lint them. In short, ESLint will lint anything you pass directly on the command line without question.

Third, you can now specify alternate file extensions for ESLint to find when looking in directories (#801). This is done via the `--ext` flag. By default, ESLint looks for all files with a `.js` extension. You can change that extension by specifying it with `--ext`:

```
eslint --ext .js2
```

This will cause ESLint to look only for files with a `.js2` extension. You can specify multiple extensions to search for as well:

```
eslint --ext .js --ext .js2
```

This will cause ESLint to look for files with either `.js` or `.js2` extensions.

### CLIEngine updated

The `CLIEngine` object has been updated to allow you to specify `extensions`, which corresponds to the `--ext` flag. You can read more about this in the [Node.js API documentation](https://eslint.org/docs/developer-guide/nodejs-api).

### space-unary-word-ops is now space-unary-ops

Sometimes when creating a new rule it becomes apparent that it should actually be combined with an existing rule. This is what happened with `space-unary-word-ops`. The new `space-unary-ops` replaces it and adds support for non-word unary operations.

## Breaking Changes

* Breaking: Allow extensionless files to be passed on CLI (fixes #1131) (Nicholas C. Zakas)
* Breaking: ignore node_modules by default (fixes #1163) (Brandon Mills)
* Breaking: Add space-unary-ops rules (#1346) (Marcin Kumorek)

## Features

* New: Add ability to time individual rules (fixes #1437) (Brandon Mills)
* New: add no-inline-comment rule (fixes #1366) (Greg Cochard)
* New: Add operator-assignment rule (fixes #1420) (Brandon Mills)
* New: Allow other file extensions (fixes #801) (Nicholas C. Zakas)

## Bug Fixes

* Fix: Add Object and Function as exceptions in new-cap (refs #1487) (Nicholas C. Zakas)
* Fix: Adds clamping to getSource beforeCount (fixes #1427) (Greg Gianforcaro)
* Fix: check function call arguments in comma-spacing (fixes #1515) (Mathias Schreck)
* Fix: Collect variables declare in switch-case.(fixes #1453) (chris)
* Fix: crash in no-multi-spaces on empty array elements (fixes #1418) (Brandon Mills)
* Fix: Don't explode on directory traversal (fixes #1452) (Nicholas C. Zakas)
* Fix: env rules merging for command line config (fixes #1271) (Roberto Vidal)
* Fix: ignore undefined identifiers in typeof (fixes #1482) (Mathias Schreck)
* Fix: Ignoring empty comments. (fixes #1488) (Greg Cochard)
* Fix: JSDoc parsing by updating doctrine (fixes #1442) (Nicholas C. Zakas)
* Fix: message for numeric property names in quote-props (fixes #1459) (Brandon Mills)
* Fix: no-fallthrough should work when semis are missing (fixes #1447) (Nicholas C. Zakas)
* Fix: remove extra capture group (Nate-Wilkins)
* Fix: single quotes (Nate-Wilkins)
* Fix: typo: iffe to iife, none to non (Michael Ficarra)

## Enhancements

* Update: Add `beforeAll` and `afterAll` to the Jasmine globals (fixes #1478) (Gyandeep Singh)
* Update: Add Event to browser globals (fixes #1474) (Nicholas C. Zakas)
* Update: Add exception options to space-in-parens (fixes #1368) (David Clark)
* Update: Add no-cond-assign option to disallow nested assignments in conditionals (fixes #1444) (Jeff Williams)
* Update: allow distinct alignment groups in key-spacing (fixes #1439) (Brandon Mills)
* Update: refactor tokens API (refs #1212) (Brandon Mills)
* Update: Remove shebang workaround in spaced-line-comment (fixes #1433) (Michael Ficarra)
* Update: restore the "runs" global present in Jasmine 1.3 (fixes #1498) (Michał Gołębiowski)

## Documentation

* Docs: change 'and' to 'an' in docs/rules/valid-jsdoc.md (fixes #1441) (Michael Ficarra)
* Docs: Explain .eslintignore features (fixes #1094) (Brandon Mills)
* Docs: Fix broken code fences in key-spacing docs (Brandon Mills)
* Docs: Remove assumption about the rule config (Alexander Schmidt)
* Docs: update badges (Yoshua Wuyts)
* Docs: Update pages to fix rendering of lists and fenced code blocks (David Anson)

## Build-Related

* Build: Add check for license issues (fixes #782) (Brandon Mills)
* Build: Escape period in regex (fixes #1428) (Brandon Mills)
* Build: Filter and sort versions in gensite (fixes #1430) (Brandon Mills)
* Fix: '.md' to '.html' with anchors (fixes #1415) (Nate-Wilkins)
* Revert "Fix: '.md' to '.html' with anchors (fixes #1415)" (Nicholas C. Zakas)
