---
layout: post
title: ESLint 0.9.0 released
teaser: "We just pushed ESLint 0.9.0, which is a minor release upgrade. This release includes new features, bug fixes, and performance improvements."
image: release-notes.png
tags:
  - release
  - breaking change
authors:
  - nzakas
categories:
  - Release Notes
---

## Highlights

This is a summary of the major changes you need to know about for this version of ESLint.

### Plugins

Plugins can now be shipped with a default configuration specified. For more information, see the [plugins documentation](https://eslint.org/docs/developer-guide/working-with-plugins).

### Comma Spacing

There's a new `comma-spacing` rule, so we removed comma spacing checks from `space-infix-ops` to consolidate that functionality.

### CLIEngine updated

The `CLIEngine` object has been updated with more functionality for tools developers. You can now use it to lint plain text via a `executeOnText()` method and a `getConfigForFile()` method that returns the calculated configuration information for a given file. You can read more about this in the [Node.js API documentation](https://eslint.org/docs/developer-guide/nodejs-api).

### Governance Model

With this release, we're introducing the [ESLint Governance Model](https://eslint.org/docs/developer-guide/governance) to help more people become involved with the project. The governance model establishes the rules by which contributors can increase their involvement with the project and influence its direction.

## Breaking Changes

* Breaking: Removed comma spacing check from space-infix-ops (fixes [#1361](https://github.com/eslint/eslint/issues/1361)) (vegetableman)

## Features

* New: add --quiet option (fixes [#905](https://github.com/eslint/eslint/issues/905)) (Mathias Schreck)
* New: Add key-spacing rule (fixes [#1280](https://github.com/eslint/eslint/issues/1280)) (Brandon Mills)
* New: add rule for multiple empty lines (fixes [#1254](https://github.com/eslint/eslint/issues/1254)) (Greg Cochard)
* New: add rule for padded blocks (fixes [#1278](https://github.com/eslint/eslint/issues/1278)) (Mathias Schreck)
* New: add space-before-blocks rule (fixes [#1277](https://github.com/eslint/eslint/issues/1277)) (Mathias Schreck)
* New: add spaced-line-comment rule (fixes [#1345](https://github.com/eslint/eslint/issues/1345)) (Greg Cochard)
* New: Added comma-spacing rule (Fixes [#628](https://github.com/eslint/eslint/issues/628), Fixes [#1319](https://github.com/eslint/eslint/issues/1319)) (vegetableman)
* New: Added comma-style rule (fixes [#1282](https://github.com/eslint/eslint/issues/1282)) (vegetableman)
* New: added no-multi-spaces rule (fixes [#630](https://github.com/eslint/eslint/issues/630)) (vegetableman)
* New: Added no-process-env rule (fixes [#657](https://github.com/eslint/eslint/issues/657)) (vegetableman)
* New: Adding in rule for irregular whitespace checking. (fixes [#1024](https://github.com/eslint/eslint/issues/1024)) (Jonathan Kingston)
* New: Allow reading from STDIN (fixes [#368](https://github.com/eslint/eslint/issues/368)) (Nicholas C. Zakas)

## Bug Fixes

* Fix: add rule ensuring [#1258](https://github.com/eslint/eslint/issues/1258) is fixed by recent rewrite (fixes [#1258](https://github.com/eslint/eslint/issues/1258)) (Michael Ficarra)
* Fix: addressed linting errors (Nicholas C. Zakas)
* Fix: allow comma-last with object properties having line breaks (fixes [#1314](https://github.com/eslint/eslint/issues/1314)) (vegetableman)
* Fix: Ensure messages are sorted by line (fixes [#1343](https://github.com/eslint/eslint/issues/1343)) (Nicholas C. Zakas)
* Fix: Make sure shebang comment node is removed (fixes [#1352](https://github.com/eslint/eslint/issues/1352)) (Nicholas C. Zakas)
* Fix: no-comma-dangle violation in unit test and Makefile.js/lint not checking return codes (fixes [#1306](https://github.com/eslint/eslint/issues/1306)) (David Anson)
* Fix: no-fallthrough incorrectly flagged falls through annotations (fixes [#1353](https://github.com/eslint/eslint/issues/1353)) (Mathias Schreck)
* Fix: no-shadow rule should consider function expressions (fixes [#1322](https://github.com/eslint/eslint/issues/1322)) (Mathias Schreck)
* Fix: resolve linting issue in (fixes [#1339](https://github.com/eslint/eslint/issues/1339)) (Nicholas C. Zakas)
* Fix: space-in-parens should not throw for multiline statements (fixes [#1351](https://github.com/eslint/eslint/issues/1351)) (Jary)

## Enhancements

* Update: add "as-needed" option to quote-props rule (fixes [#1279](https://github.com/eslint/eslint/issues/1279)) (Michael Ficarra)
* Update: Add CLIEngine#getConfigForFile (fixes [#1309](https://github.com/eslint/eslint/issues/1309)) (Nicholas C. Zakas)
* Update: Add missing environments and fix sorting/grouping of rules (fixes [#1307](https://github.com/eslint/eslint/issues/1307), fixes [#1308](https://github.com/eslint/eslint/issues/1308)) (David Anson)
* Update: add space after function keyword check (fixes [#1276](https://github.com/eslint/eslint/issues/1276)) (Mathias Schreck)
* Update: Add support for plugin default configuration (fixes [#1358](https://github.com/eslint/eslint/issues/1358)) (Ilya Volodin)
* Update: Added arraysInObjects and objectsInObjects options to space-in-brackets rule (fixes [#1265](https://github.com/eslint/eslint/issues/1265), fixes [#1302](https://github.com/eslint/eslint/issues/1302)) (vegetableman)
* Update: remove globals present only in Jasmine plugins (fixes [#1326](https://github.com/eslint/eslint/issues/1326)) (Michał Gołębiowski)
* Update: split propertyName from singleValue in space-in-brackets (fixes [#1253](https://github.com/eslint/eslint/issues/1253)) (Michael Ficarra)
* Update: turn on comma-style for project (fixes [#1316](https://github.com/eslint/eslint/issues/1316)) (Nicholas C. Zakas)

## Documentation

* Docs: Add BountySource badge to README (Nicholas C. Zakas)
* Docs: Add Contributor Model (fixes [#1341](https://github.com/eslint/eslint/issues/1341)) (Nicholas C. Zakas)
* Docs: Add docs on Node.js API (fixes [#1247](https://github.com/eslint/eslint/issues/1247)) (Nicholas C. Zakas)
* Docs: Add recommended keywords for plugins (fixes [#1248](https://github.com/eslint/eslint/issues/1248)) (Nicholas C. Zakas)
* Docs: Add reference to CLA (Nicholas C. Zakas)
* Docs: Added "the native web" to the list of companies that use ESLint. (Golo Roden)
* Docs: added more Related Rules sections (fixes [#1347](https://github.com/eslint/eslint/issues/1347)) (Delapouite)
* Docs: Correct a few misspelled words (David Anson)
* Docs: Explain global vs. local plugins (fixes [#1238](https://github.com/eslint/eslint/issues/1238)) (Nicholas C. Zakas)
* Docs: fix eqeqeq isNullCheck comment (Denis Sokolov)
* Docs: Fix sorting of rules within each section (David Anson)
* Docs: fixed broken link and changed warning level to error level (vegetableman)
* Docs: Remove moot integration plugins (Sindre Sorhus)
* Docs: Update multiple pages to fix rendering of fenced code blocks (David Anson)

## Build-Related

* Build: add version numbers to docs (fixes [#1170](https://github.com/eslint/eslint/issues/1170)) (Mathias Schreck)
* Build: separate site publishing form generation (fixes [#1356](https://github.com/eslint/eslint/issues/1356)) (Mathias Schreck)
