---
layout: post
title: ESLint 0.8.0 released
teaser: "We just pushed ESLint 0.8.0, which is a minor release upgrade. This release includes new features, bug fixes, and performance improvements."
image: release-notes.png
tags:
  - release
  - breaking change
authors:
  - nzakas
categories:
  - Release Notes
---

## Highlights

This is a summary of the major changes you need to know about for this version of ESLint.

### Plugins

This is the first version of ESLint that formally supports shareable plugins. Currently, plugins allow you to bundle several rules together and publish them on [npm](https://npmjs.org). This allows you to share groups of rules easily with others. Creating plugins is very simple:

1. Create an npm package with the name `eslint-plugin-{your plugin name}` such as `eslint-plugin-foo`.
2. Export an object that has a `rules` property. The `rules` property should contain keys that are your rule IDs and values that are the rule implementation.

For more information, see the [plugins documentation](https://eslint.org/docs/developer-guide/working-with-plugins).

### Ignore files

Due to some feedback we received regarding `.eslintignore` files, we have decided to automatically duplicate and append `/**` to every entry in the file. This is to address the issue where simple directory names would not match files within that directory. For example, using `node_modules/` would not ignore all files in `node_modules/`, so now we will use that rule plus `node_modules/**` to ensure all files in the directory are ignored.

### Performance improvements

There were several fixes made to improve performance. On our benchmark, we've sped up processing time by 100-200ms (roughly a 10% improvement).

### no-global-strict is now global-strict

In an effort to embrace different coding preferences, we've changed the `no-global-strict` rule (which disallowed `"use strict"` in the global scope) to `[global-strict](https://eslint.org/docs/rules/global-strict)`. This allows you to either enforce or disallow global `"use strict"`.

### CLIEngine exported, cli deprecated

ESLint now exports the `CLIEngine` interface, which is what powers the ESLint command line utility. If you are writing plugins for other systems that make use of the ESLint `cli` object, then you should transition to using `CLIEngine` instead.

The `cli` object will stop being exported in a future version of ESLint.

## Breaking Changes

* Breaking: Change no-global-strict to global-strict and add "always" option (fixes [#989](https://github.com/eslint/eslint/issues/989)) (Brandon Mills)
* Breaking: Ignore children of all patterns by adding "/**" (Fixes [#1069](https://github.com/eslint/eslint/issues/1069)) (jrajav)

## Features

* New:  Adding 'vars-on-top' rule (fixes [#1148](https://github.com/eslint/eslint/issues/1148)) (Gyandeep Singh)
* New: accept plugins from cli (fixes [#1113](https://github.com/eslint/eslint/issues/1113)) (Mathias Schreck)
* New: Add no-extra-bind rule to flag unnecessary bind calls (fixes [#982](https://github.com/eslint/eslint/issues/982)) (Bence Dányi)
* New: add no-void rule (fixes [#1017](https://github.com/eslint/eslint/issues/1017)). (Mike Sidorov)
* New: Add rules.import() (fixes [#1114](https://github.com/eslint/eslint/issues/1114)) (Mathias Schreck)
* New: Added rule disallowing reserved words being used as keys (fixes [#1144](https://github.com/eslint/eslint/issues/1144)) (Emil Bay)
* New: Adding 'plugin' CLI option (fixes [#1112](https://github.com/eslint/eslint/issues/1112)) (Greg)
* New: Adds support for the `jasmine` env (fixes [#1176](https://github.com/eslint/eslint/issues/1176)) (James Whitney)
* New: advanced handle-callback-err configuration (fixes [#1124](https://github.com/eslint/eslint/issues/1124)) (Mathias Schreck)
* New: Expose CLIEngine (fixes [#1083](https://github.com/eslint/eslint/issues/1083)) (Gyandeep Singh)
* New: Load plugins from configs (fixes [#1115](https://github.com/eslint/eslint/issues/1115)). (Mathias Schreck)
* New: Make mergeConfigs() merge plugin entries (fixes [#1111](https://github.com/eslint/eslint/issues/1111)) (Mathias Schreck)
* New: space-in-parens rule (Closes [#627](https://github.com/eslint/eslint/issues/627)) (jrajav)

## Bug Fixes

* Fix: Add Date.UTC to allowed capitalized functions (David Brockman Smoliansky)
* Fix: Correct a typo in the error message in tests (Michał Gołębiowski)
* Fix: crash when loading empty eslintrc file (fixes [#1164](https://github.com/eslint/eslint/issues/1164)) (Michael Ficarra)
* Fix: don't break node offsets if hasbang present (fixes [#1078](https://github.com/eslint/eslint/issues/1078)) (Vitaly Puzrin)
* Fix: dot-notation rule flags non-keyword reserved words (fixes [#1102](https://github.com/eslint/eslint/issues/1102)) (Michael Ficarra)
* Fix: Error when there's a \r in .eslintrc ([#1172](https://github.com/eslint/eslint/issues/1172)) (Gyandeep Singh)
* Fix: for-in support to no-empty-label rule (fixes [#1161](https://github.com/eslint/eslint/issues/1161)) (Marc Harter)
* Fix: mergeConfigs ensures the plugins property exists (fixes [#1191](https://github.com/eslint/eslint/issues/1191)). (Mathias Schreck)
* Fix: no-extra-strict behavior for named function expressions (fixes [#1209](https://github.com/eslint/eslint/issues/1209)) (Mathias Schreck)
* Fix: no-fallthrough: continue affects control flow, too (fixes [#1220](https://github.com/eslint/eslint/issues/1220)) (Michael Ficarra)
* Fix: no-unreachable should check top-level statements (fixes [#1138](https://github.com/eslint/eslint/issues/1138)) (Brandon Mills)
* Fix: no-unused-expressions better directive detection (fixes [#1195](https://github.com/eslint/eslint/issues/1195)) (Michael Ficarra)
* Fix: no-unused-expressions directive support (fixes [#1185](https://github.com/eslint/eslint/issues/1185)) (Michael Ficarra)
* Fix: no-unused-var should respect compound assignments (fixes [#1166](https://github.com/eslint/eslint/issues/1166)) (Michael Ficarra)
* Fix: rewrite no-spaced-func rule (refs [#1212](https://github.com/eslint/eslint/issues/1212)) (Michael Ficarra)
* Fix: rewrite no-unused-vars rule (refs [#1212](https://github.com/eslint/eslint/issues/1212)) (Michael Ficarra)
* Fix: skip dot files and ignored dirs on traverse (fixes [#1077](https://github.com/eslint/eslint/issues/1077), related to [#814](https://github.com/eslint/eslint/issues/814)) (Vitaly Puzrin)
* Fix: space-after-keywords checks finally of TryStatement (fixes [#1122](https://github.com/eslint/eslint/issues/1122)) (Michael Ficarra)
* Fix: space-after-keywords checks while of DoWhileStatement (fixes [#1120](https://github.com/eslint/eslint/issues/1120)) (Michael Ficarra)
* Fix: space-after-keywords w/ "never" should allow else-if (fixes [#1118](https://github.com/eslint/eslint/issues/1118)) (Michael Ficarra)
* Fix: Speed up getScope() (refs [#1212](https://github.com/eslint/eslint/issues/1212)) (Brandon Mills)
* Fix: Speed up no-unreachable (fixes [#1135](https://github.com/eslint/eslint/issues/1135)) (Brandon Mills)
* Fix: Speed up tokens API (refs [#1212](https://github.com/eslint/eslint/issues/1212)) (Brandon Mills)
* Perf-related revert "Fix: Speed up tokens API (refs [#1212](https://github.com/eslint/eslint/issues/1212))" (Nicholas C. Zakas)
* Fix: Useless bind call in cli-engine (fixes [#1181](https://github.com/eslint/eslint/issues/1181)) (Bence Dányi)

## Enhancements

* Update: Add 'allowSingleLine' option to brace-style (fixes [#1089](https://github.com/eslint/eslint/issues/1089)) (John Gozde)
* Update: Added comments support to .eslintignore (fixes [#1084](https://github.com/eslint/eslint/issues/1084)) (Vitaly Puzrin)
* Update: Declare ES6 collections (Map, Set, WeakMap, WeakSet) as built-in globals (fixes [#1189](https://github.com/eslint/eslint/issues/1189)) (Michał Gołębiowski)
* Update: enabled 'no-trailing-spaces' rule by default (fixes [#1051](https://github.com/eslint/eslint/issues/1051)) (Vitaly Puzrin)
* Update: ES3 `ReservedWord`s (fixes [#1151](https://github.com/eslint/eslint/issues/1151)) Adds ES3 `ReservedWord`s to the list of keywords in the `dot-notation` rule (fixes [#1151](https://github.com/eslint/eslint/issues/1151)) (Emil Bay)
* Update: Update comment parser to read rule slashes (fixes [#1116](https://github.com/eslint/eslint/issues/1116)) (Jary)
* Update: Use xml-escape instead of inline helper (Ref [#848](https://github.com/eslint/eslint/issues/848)) (jrajav)

## Documentation

* Docs: Add link to new Atom linter (fixes [#1125](https://github.com/eslint/eslint/issues/1125)) (Gil Pedersen)
* Docs: Added Gruntjs plugin on integrations page (Gyandeep Singh)
* Docs: Change eol-last examples to <pre> (Fixes [#1068](https://github.com/eslint/eslint/issues/1068)) (jrajav)
* Docs: document plugin usage (fixes [#1117](https://github.com/eslint/eslint/issues/1117)) (Mathias Schreck)
* Docs: fix some typos. (Mathias Schreck)
* Docs: Spell checking and one extra closing curly in code example (Juga Paazmaya)
* docs: Update link (Mathias Bynens)
* Docs: Updates `amd` description (fixes [#1175](https://github.com/eslint/eslint/issues/1175)) (James Whitney)

## Build-Related

* Build: Exclude readme/index from rules Resources generation (Fixes [#1072](https://github.com/eslint/eslint/issues/1072)) (jrajav)
