---
layout: post
title: ESLint 0.7.1 released
teaser: "We just pushed ESLint 0.7.1, which is the minor release upgrade from 0.6.2. Unfortunately, due to an error in the publishing process of 0.6.2, 0.6.2 was initially pushed to npm as 0.7.0. We unpublished 0.7.0 and republished as 0.6.2."
image: release-notes-patch.png
tags:
  - release
  - breaking change
authors:
  - nzakas
categories:
  - Release Notes
---

Due to npm's security restrictions, we aren't allowed to push a new 0.7.0 to the npm registry, which is why this version is 0.7.1.

## Highlights

This is a summary of the major changes you need to know about for this version of ESLint.

### .eslintignore Change

As we announced previously, the JSON format for `.eslintignore` files has been removed. Make sure to update your `.eslintignore` files appropriately.

### Configuration Changes

0.7.1 formalizes how configuration works when there are multiple `.eslintrc` files. We have implemented configuration cascading, meaning that a `.eslintrc` file automatically inherits the settings from the `.eslintrc` file in its ancestor directories. This is how configuration was always envisioned to work in ESLint, but there were several bugs in the functionality. Because these bugs have been fixed, you may notice some different behavior with your current configuration settings. For more information on the configuration hierarchy, see the [Configuration documentation](https://eslint.org/docs/user-guide/configuring).

### no-yoda is now yoda

In an effort to embrace different coding preferences, we've changed the `no-yoda` rule (which disallowed yoda conditions) to `[yoda](https://eslint.org/docs/rules/yoda)`. This allows you to either enforce or disallow yoda conditions.

### CLI changes

The CLI has gone through an update, now allowing you to pass `--color` and `--no-color` to turn on or off color in the output. You can also use `-o` to specify a file to output the results into rather than outputting to the console.

## Breaking Changes

* Breaking: Implement configuration hierarchy (fixes [#963](https://github.com/eslint/eslint/issues/963)) (Nicholas C. Zakas)
* Breaking: CLIEngine abstraction for CLI operations; formatters no longer are passed configs (fixes [#935](https://github.com/eslint/eslint/issues/935)) (Nicholas C. Zakas)
* Breaking: Change 'no-yoda' rule to 'yoda' and add "always" option (Fixes [#959](https://github.com/eslint/eslint/issues/959)) (jrajav)
* Breaking: Refactor .eslintignore functionality (refs [#928](https://github.com/eslint/eslint/issues/928), fixes [#901](https://github.com/eslint/eslint/issues/901), fixes [#837](https://github.com/eslint/eslint/issues/837), fixes [#853](https://github.com/eslint/eslint/issues/853)) (Nicholas C. Zakas)
* Breaking: Remove JSON support for .eslintignore (fixes [#883](https://github.com/eslint/eslint/issues/883)) (icebox)

## Features

* New: Add getSourceLines() to core and rule context (fixed [#1005](https://github.com/eslint/eslint/issues/1005)) (Jary)
* New: report output to a file (fixes [#1027](https://github.com/eslint/eslint/issues/1027)) (Gyandeep Singh)
* New: add [no-undefined](https://eslint.org/docs/rules/no-undefined) rule (fixes [#1020](https://github.com/eslint/eslint/issues/1020)) (Michael Ficarra)
* New: Added [no-mixed-spaces-and-tabs](https://eslint.org/docs/rules/no-mixed-spaces-and-tabs) rule (fixes [#1003](https://github.com/eslint/eslint/issues/1003)) (Jary)
* New: Added [no-trailing-spaces](https://eslint.org/docs/rules/no-trailing-spaces) rule (fixes [#995](https://github.com/eslint/eslint/issues/995)) (Vitaly Puzrin)
* New: Added [eol-last](https://eslint.org/docs/rules/eol-last) rule (Fixes [#996](https://github.com/eslint/eslint/issues/996)) (Vitaly Puzrin)
* New: Allow the cli parameter "color" and "no-color" (fixes [#954](https://github.com/eslint/eslint/issues/954)) (Tom Gallacher)

## Bug Fixes

* Fix: Check output file isn't dir, fix tests (Fixes [#1034](https://github.com/eslint/eslint/issues/1034)) (jrajav)
* Fix: Ignore unused params for args: 'none' (Fixes [#1026](https://github.com/eslint/eslint/issues/1026)) (jrajav)
* Fix: Point eqeqeq error at operator (Fixes [#1029](https://github.com/eslint/eslint/issues/1029)) (jrajav)
* Fix: Allow stdout to drain before exiting (fixes [#317](https://github.com/eslint/eslint/issues/317)) (Nicholas C. Zakas)
* Fix: rewrite eol-last rule (fixes [#1007](https://github.com/eslint/eslint/issues/1007)) (fixes [#1008](https://github.com/eslint/eslint/issues/1008)) (Michael Ficarra)
* Fix: add additional IIFE exception in no-extra-parens (fixes [#1004](https://github.com/eslint/eslint/issues/1004)) (Michael Ficarra)
* Fix: Put rule severity in messages (Fixes [#984](https://github.com/eslint/eslint/issues/984)); deprecates passing full config to Formatters (jrajav)
* Fix: no-unused-vars to check only file globals (fixes [#975](https://github.com/eslint/eslint/issues/975)) (Aliaksei Shytkin)
* Fix: Fixes no-unused-vars to check /*globals*/ (Fixes [#955](https://github.com/eslint/eslint/issues/955)) (jrajav)
* Fix: valid-jsdoc no more warning for multi-level params (Fixes [#925](https://github.com/eslint/eslint/issues/925)) (Delapouite)
* Fix: Correct order of arguments passed to assert.equal (fixes [#945](https://github.com/eslint/eslint/issues/945)) (Michał Gołębiowski)
* Fix: Corrects configs merging into base config (Fixes [#838](https://github.com/eslint/eslint/issues/838)) (jrajav)
* Fix: Adding check if char is non-alphabetic to new-cap (Fixes [#940](https://github.com/eslint/eslint/issues/940)) (jrajav)

## Enhancements

* Update: Factor ignores out of Config (fixes [#958](https://github.com/eslint/eslint/issues/958)) (jrajav)
* Update: greatly simplify eqeqeq's operator finding logic (fixes [#1037](https://github.com/eslint/eslint/issues/1037)) (Michael Ficarra)
* Update: no-eval to also warn on setTimeout and setInterval (fixes [#721](https://github.com/eslint/eslint/issues/721)) (Nicholas C. Zakas)
* Update: Rule `new-cap` checks capitalized functions (fixes [#904](https://github.com/eslint/eslint/issues/904)) (Aliaksei Shytkin)
* Update: Search parent directories for .eslintignore (Fixes [#933](https://github.com/eslint/eslint/issues/933)) (jrajav)
* Update: space-in-brackets now always allows empty object and array literals to have no spaces (fixes [#797](https://github.com/eslint/eslint/issues/797)) (Nicholas C. Zakas)
* Update: Write the summary in stylish formatter in yellow if no errors (fixes [#906](https://github.com/eslint/eslint/issues/906)); test coloring of messages (Michał Gołębiowski)

## Documentation

* Docs: Add '/', forgotten in first commit (Fixes [#931](https://github.com/eslint/eslint/issues/931)) (jrajav)
* Docs: Add Related Rules sections (Fixes [#990](https://github.com/eslint/eslint/issues/990)) (jrajav)
* Docs: guard-for-in - added missing id in title (Fixes [#969](https://github.com/eslint/eslint/issues/969)) (Delapouite)
* Docs: Mention allowed semicolons in "never" mode for 'semi' rule (fixes [#931](https://github.com/eslint/eslint/issues/931)) (jrajav)
* Docs: Mention Yeoman generator in dev setup (fixes [#914](https://github.com/eslint/eslint/issues/914)) (Nicholas C. Zakas)
* Docs: Removed reference to brace-style Stroustrup default (fixes [#1000](https://github.com/eslint/eslint/issues/1000)) (Caleb Troughton)
* Docs: Update about page description (fixes [#936](https://github.com/eslint/eslint/issues/936)) (Nicholas C. Zakas)
* Docs: Updated contributor guide and dev env setup guide (Nicholas C. Zakas)
* Docs: Updated documentation for several rules (Nicholas C. Zakas)

## Build-Related

* Breaking: Change 'no-yoda' rule to 'yoda' and add "always" option (Fixes [#959](https://github.com/eslint/eslint/issues/959)) (jrajav)
* Breaking: CLIEngine abstraction for CLI operations; formatters no longer are passed configs (fixes [#935](https://github.com/eslint/eslint/issues/935)) (Nicholas C. Zakas)
* Breaking: Implement configuration hierarchy (fixes [#963](https://github.com/eslint/eslint/issues/963)) (Nicholas C. Zakas)
* Breaking: Refactor .eslintignore functionality (refs [#928](https://github.com/eslint/eslint/issues/928), fixes [#901](https://github.com/eslint/eslint/issues/901), fixes [#837](https://github.com/eslint/eslint/issues/837), fixes [#853](https://github.com/eslint/eslint/issues/853)) (Nicholas C. Zakas)
* Breaking: Remove JSON support for .eslintignore (fixes [#883](https://github.com/eslint/eslint/issues/883)) (icebox)
* Build + Docs: Adding generated resource links to rule docs (Fixes [#1021](https://github.com/eslint/eslint/issues/1021)) (jrajav)
* Build: Makefile - Check for rule ids in docs titles (Fixes [#969](https://github.com/eslint/eslint/issues/969)) (Delapouite)
* Build: Remove flaky perf test from Travis (Nicholas C. Zakas)
