---
layout: post
title: ESLint 0.6.0 released
teaser: "We just pushed ESLint 0.6.0, which is a significant release with new features, new rules, and of course, some bug fixes."
image: release-notes.png
tags:
  - breaking change
  - release
authors:
  - nzakas
categories:
  - Release Notes
---

## Deprecation Notices

* The 0.6.x ESLint will be the last to support the deprecated JSON format for `.eslintignore`. This was deprecated in 0.5.1 and will be removed in 0.7.0. Please change your `.eslintignore` files to the new plain-text format. See [#761](https://github.com/eslint/eslint/issues/761).

## Breaking Changes

* [brace-style](https://eslint.org/docs/rules/brace-style) now disallows block statements where curlies are on the same line. While not strictly a breaking change, it is a significant enough change to warrant being called out in this way. ([#758](https://github.com/eslint/eslint/issues/758))
* Node 0.8.x is no longer officially supported as of 0.6.0. We will no longer accept or fix bugs for Node 0.8.x.

## Rules

* **Breaking:** [brace-style](https://eslint.org/docs/rules/brace-style) now disallows block statements where curlies are on the same line. While not strictly a breaking change, it is a significant enough change to warrant being called out in this way. ([#758](https://github.com/eslint/eslint/issues/758))
* **New:** [default-case](https://eslint.org/docs/rules/default-case) ([#787](https://github.com/eslint/eslint/issues/787))
* **New:** [no-new-require](https://eslint.org/docs/rules/no-new-require) ([#847](https://github.com/eslint/eslint/issues/847))
* **New:** [space-after-keywords](https://eslint.org/docs/rules/space-after-keywords)  ([#807](https://github.com/eslint/eslint/issues/807))
* **New:** [no-lonely-if](https://eslint.org/docs/rules/no-lonely-if) (fixes [#790](https://github.com/eslint/eslint/issues/790)) (Brandon Mills)
* **New:** [no-restricted-modules](https://eslint.org/docs/rules/no-restricted-modules) ([#791](https://github.com/eslint/eslint/issues/791))
* **New:** [no-inner-declarations](https://eslint.org/docs/rules/no-inner-declarations) ([#587](https://github.com/eslint/eslint/issues/587))
* **Update:** The default value for the `vars` option of [no-unused-vars](https://eslint.org/docs/rules/no-unused-vars) was changed to "all". This addresses the issue where some were unexpectedly seeing unused global variables missed. ([#760](https://github.com/eslint/eslint/issues/760))
* **Update:** [valid-jsdoc](https://eslint.org/docs/rules/valid-jsdoc) now allows you to optionally turn off parameter description checks ([#822](https://github.com/eslint/eslint/issues/822))
* **Update:** [no-extra-parens](https://eslint.org/docs/rules/no-extra-parens) now doesn't flag IIFEs ([#655](https://github.com/eslint/eslint/issues/655))
* **Fix:** [semi](https://eslint.org/docs/rules/semi) rule was incorrectly flagging extra semicolon ([#840](https://github.com/eslint/eslint/issues/840))
* **Update:** Add "nofunc" option to [no-use-before-define](https://eslint.org/docs/rules/no-use-before-define) ([#829](https://github.com/eslint/eslint/issues/829))
* **Fix:** [block-scoped-var](https://eslint.org/docs/rules/block-scoped-var) correct scope for functions, arguments ([#832](https://github.com/eslint/eslint/issues/832))

## Configuration

* **Update:** You can now use comments to enable/disable rules around certain portions of a file ([#305](https://github.com/eslint/eslint/issues/305))

## CLI

* **Update:** Added `--rule` flag to specify rules on the [command line](https://eslint.org/docs/user-guide/command-line-interface). ([#692](https://github.com/eslint/eslint/issues/692))
* **Update:** Added `--force` to force ESLint to lint ignored files. Also, you'll now get a warning when ESLint is ignoring files that are explicitly passed on the command line.

## Documentation

* **Update:** [Contribution Guidelines](https://eslint.org/docs/developer-guide/contributing)
* **Update:** [Development Environment](https://eslint.org/docs/developer-guide/development-environment)

## Build

* Add linting of Makefile.js. ([#870](https://github.com/eslint/eslint/issues/870))
* Add check so that documentation reflects the correct on/off default for each rule ([#865](https://github.com/eslint/eslint/issues/865))

## Upgrades

* Esprima to 1.2 (fixes [#842](https://github.com/eslint/eslint/issues/842)) (Nicholas C. Zakas)


## Complete Changelog

The following is the complete list of changes in this version:

* Fix: Remove -r alias for --rule (fixes [#882](https://github.com/eslint/eslint/issues/882)) (Nicholas C. Zakas)
* Docs: Update dev setup, contributing, default-case descriptions (Nicholas C. Zakas)
* Update: valid-jsdoc now allows you to optionally turn off parameter description checks (fixes [#822](https://github.com/eslint/eslint/issues/822)) (Nicholas C. Zakas)
* Breaking: brace-style now disallows block statements where curlies are on the same line (fixes [#758](https://github.com/eslint/eslint/issues/758)) (Nicholas C. Zakas)
* Add linting Makefile.js (fixes [#870](https://github.com/eslint/eslint/issues/870)) (icebox)
* add rule flag, closes [#692](https://github.com/eslint/eslint/issues/692) (George Zahariev)
* Add check between rules doc and index (fixes [#865](https://github.com/eslint/eslint/issues/865)) (icebox)
* Add Build Next mention in integrations README. (icebox)
* document new IIFE exception for no-extra parens added as part of [#655](https://github.com/eslint/eslint/issues/655) (Michael Ficarra)
* (fixes [#622](https://github.com/eslint/eslint/issues/622)) Add rule ID on documentation pages (Delapouite)
* fixes [#655](https://github.com/eslint/eslint/issues/655): add IIFE exception to no-extra-parens (Michael Ficarra)
* add new rule "no-new-require" (Wil Moore III)
* exit with non-zero status when tests fail (fixes [#858](https://github.com/eslint/eslint/issues/858)) (Márton Salomváry)
* removed unicode zero width space character from messages (fixes [#857](https://github.com/eslint/eslint/issues/857)) (Márton Salomváry)
* Change: --rulesdir now can be specified multiple times (fixes [#830](https://github.com/eslint/eslint/issues/830)) (Nicholas C. Zakas)
* Update: Node 0.8 no longer supported (fixes [#734](https://github.com/eslint/eslint/issues/734)) (Nicholas C. Zakas)
* Update: Add typed arrays into builtin environment globals (fixes [#846](https://github.com/eslint/eslint/issues/846)) (Nicholas C. Zakas)
* Fix: Add prototype methods to global scope (fixes [#700](https://github.com/eslint/eslint/issues/700)) (Nicholas C. Zakas)
* Rule: no-restricted-modules (fixes [#791](https://github.com/eslint/eslint/issues/791)) (Christian)
* Upgrade: Esprima to 1.2 (fixes [#842](https://github.com/eslint/eslint/issues/842)) (Nicholas C. Zakas)
* Docs: reporting level 2 is an error (fixes [#843](https://github.com/eslint/eslint/issues/843)) (Brandon Mills)
* Upgrade: Esprima to 1.2, switch to using Esprima comment attachment (fixes [#730](https://github.com/eslint/eslint/issues/730)) (Nicholas C. Zakas)
* Fix: Semi rule incorrectly flagging extra semicolon (fixes [#840](https://github.com/eslint/eslint/issues/840)) (Nicholas C. Zakas)
* Build: Update Travis to only test Node 0.10 (refs [#734](https://github.com/eslint/eslint/issues/734)) (Nicholas C. Zakas)
* Add "nofunc" option (fixes [#829](https://github.com/eslint/eslint/issues/829)) (Conrad Zimmerman)
* Rule: no-inner-declarations (fixes [#587](https://github.com/eslint/eslint/issues/587)) (Brandon Mills)
* Rule 'block-scoped-var': correct scope for functions, arguments (fixes [#832](https://github.com/eslint/eslint/issues/832)) (Aliaksei Shytkin)
* Rule: default-case (fixes [#787](https://github.com/eslint/eslint/issues/787)) (Aliaksei Shytkin)
* Ignored files are excluded unless --force is passed on the CLI (Nick Fisher)
* Fixes a typo and a broken link in the documentation (Nick Fisher)
* Replaces .some() with .indexOf() where appropriate (Nick Fisher)
* Fix correct config merge for array values (fixes [#819](https://github.com/eslint/eslint/issues/819)) (Aliaksei Shytkin)
* Remove warning about ESLint being in Alpha (Nick Fisher)
* Adds `space-after-keywords` rule (fixes [#807](https://github.com/eslint/eslint/issues/807)) (Nick Fisher)
* Rule: no-lonely-if (fixes [#790](https://github.com/eslint/eslint/issues/790)) (Brandon Mills)
* Add ignore comments in file (fixes [#305](https://github.com/eslint/eslint/issues/305)) (Aliaksei Shytkin)
* Change: no-unused-vars default to 'all' (fixes [#760](https://github.com/eslint/eslint/issues/760)) (Nicholas C. Zakas)
