---
layout: post
title: ESLint 0.5.1 released
teaser: "We just pushed ESLint 0.5.1, which is a small release to fix some important bugs discovered in 0.5.0."
image: release-notes-patch.png
tags:
  - release
authors:
  - nzakas
categories:
  - Release Notes
---

## Deprecation Notices

* With this release, we are deprecating the JSON format for `.eslintignore` in favor of a plain-text format. The change was made in a backwards-compatible way, but JSON support will be removed in the future, so you should start converting your `.eslintignore`. See [#761](https://github.com/eslint/eslint/issues/761).

## Complete Changelog

The following is the complete list of changes in this version:

* Fix general config not to be modified by comment config in files (fixes [#806](https://github.com/eslint/eslint/issues/806)) (Aliaksei Shytkin)
* Docs: SVG badges (Ryuichi Okumura)
* fixes [#804](https://github.com/eslint/eslint/issues/804): clean up implementation of [#803](https://github.com/eslint/eslint/issues/803) (which fixed [#781](https://github.com/eslint/eslint/issues/781)) (Michael Ficarra)
* Build: Fix perf test to take median of three runs (fixes [#781](https://github.com/eslint/eslint/issues/781)) (Nicholas C. Zakas)
* Fix: --reset will now properly ignore default rules in environments.json (fixes [#800](https://github.com/eslint/eslint/issues/800)) (Nicholas C. Zakas)
* Docs: Updated contributor guidelines (Nicholas C. Zakas)
* Added Mocha global variables for TDD style. Fixes [#793](https://github.com/eslint/eslint/issues/793). (Golo Roden)
* Rule: no-sequences (fixes [#561](https://github.com/eslint/eslint/issues/561)) (Brandon Mills)
* Change .eslintingore to plain text (fixes [#761](https://github.com/eslint/eslint/issues/761)) (Brandon Mills)
* Change 'no-spaced-func' message (fixes [#762](https://github.com/eslint/eslint/issues/762)) (Aliaksei Shytkin)
* Rule 'block-scoped-var' works correct when object inits (fixes [#783](https://github.com/eslint/eslint/issues/783)) (Aliaksei Shytkin)
* Build: Always build docs site on top of origin/master (Nicholas C. Zakas)
