---
layout: post
title: ESLint 0.5.0 released
teaser: "We just pushed ESLint 0.5.0, which introduces some new functionality as well as some breaking changes. Please read this notice carefully."
image: release-notes.png
tags:
  - breaking change
  - release
authors:
  - nzakas
categories:
  - Release Notes
---

Special thanks to Brandon Mills and George Zahariev for their working on making the CLI even more awesome, and Michael Ficarra for his help and advice on improving runtime performance.

## Breaking Changes

* In previous versions, ESLint would read `/*jshint node:true*/` and `/*jslint node:true*/` to set the environment in files. This feature was undocumented and has been replaced with `/*eslint-env node */` to set the environment in files. See [#759](https://github.com/eslint/eslint/issues/759).
* The 0.4.x releases of ESLint had a licensing issue with a dependency of Optionator that was had no license applied to it, making ESLint's license picture a bit muddy. We upgraded to the latest version of Optionator, in which the offending module has been removed, returning ESLint's license to pristine shape. Even though functionality did not change due to this, the license story for ESLint did, and so we consider it a breaking change.

## New Rules

* Rule: [valid-typeof](https://eslint.org/docs/rules/valid-typeof) by Ian Christian Myers

## Rule Changes

* Fix: Make sure no-path-concat doesn't flag non-concat operations (fixes [#776](https://github.com/eslint/eslint/issues/776)) (Nicholas C. Zakas)
* Rule 'no-unused-var' in functional expression with identifier (fixes [#775](https://github.com/eslint/eslint/issues/775)) (Aliaksei Shytkin)
* Add options for rule 'no-unused-vars' to check all arguments in functions (fixes [#728](https://github.com/eslint/eslint/issues/728)) (Aliaksei Shytkin)
* Rule block-scoped-var works correct with object properties (fixes [#755](https://github.com/eslint/eslint/issues/755)) (Aliaksei Shytkin)
* Fixes [#740](https://github.com/eslint/eslint/issues/740) - Make sure callbacks exist before marking them as 'handled'. (mstuart)
* fixes [#743](https://github.com/eslint/eslint/issues/743): wrap-regex rule warns on regex used in dynamic member access (Michael Ficarra)

## CLI Changes

* Add `--global` cli flag (ref [#692](https://github.com/eslint/eslint/issues/692)) (Brandon Mills)
* Add `--env` cli flag (ref [#692](https://github.com/eslint/eslint/issues/692)) (Brandon Mills)

## Complete Changelog

The following is the complete list of changes in this version:

* Build: Bump perf limit so Travis won't fail every time (fixes [#780](https://github.com/eslint/eslint/issues/780)) (Nicholas C. Zakas)
* Add tests to cover 100% of eslint.js (Aliaksei Shytkin)
* Fix: Make sure no-path-concat doesn't flag non-concat operations (fixes [#776](https://github.com/eslint/eslint/issues/776)) (Nicholas C. Zakas)
* Rule 'no-unused-var' in functional expression with identifier (fixes [#775](https://github.com/eslint/eslint/issues/775)) (Aliaksei Shytkin)
* Rule: valid-typeof (Ian Christian Myers)
* Add global cli flag (ref [#692](https://github.com/eslint/eslint/issues/692)) (Brandon Mills)
* update to latest Optionator (George Zahariev)
* Add options for rule 'no-unused-vars' to check all arguments in functions (fixes [#728](https://github.com/eslint/eslint/issues/728)) (Aliaksei Shytkin)
* Fix: Cleanup package.json (Nicholas C. Zakas)
* New: Experimental support for CSS Auron (fixes [#765](https://github.com/eslint/eslint/issues/765)) (Nicholas C. Zakas)
* Lint tests on build (fixes [#764](https://github.com/eslint/eslint/issues/764)) (Aliaksei Shytkin)
* Rule block-scoped-var works correct with object properties (fixes [#755](https://github.com/eslint/eslint/issues/755)) (Aliaksei Shytkin)
* Breaking: implement eslint-env and remove jshint/jslint environment comment support (fixes [#759](https://github.com/eslint/eslint/issues/759)) (Aliaksei Shytkin)
* readme: npm i -> npm install (Linus Unnebäck)
* Add env flag to cli options summary (fixes [#752](https://github.com/eslint/eslint/issues/752)) (Brandon Mills)
* Fix: Give the perf test a better calculated budget (fixes [#749](https://github.com/eslint/eslint/issues/749)) (Nicholas C. Zakas)
* give the `env` flag type `[String]`, improve code (fixes [#748](https://github.com/eslint/eslint/issues/748)) (George Zahariev)
* fixes [#735](https://github.com/eslint/eslint/issues/735): add new, more efficient getTokens interfaces (Michael Ficarra)
* Add --env cli flag (ref [#692](https://github.com/eslint/eslint/issues/692)) (Brandon Mills)
* Fixes [#740](https://github.com/eslint/eslint/issues/740) - Make sure callbacks exist before marking them as 'handled'. (mstuart)
* fixes [#743](https://github.com/eslint/eslint/issues/743): wrap-regex rule warns on regex used in dynamic member access (Michael Ficarra)
* replace tab indents with 4 spaces in lib/rules/handle-callback-err.js (Michael Ficarra)
* Adding homepage and bugs links to package.json (Peter deHaan)
* JSDoc for rules (Anton Rudeshko)
