---
layout: post
title: ESLint 0.4.0 released
teaser: "We just pushed ESLint 0.4.0, which is a significant release due to the number of bug fixes and significant changes included."
image: release-notes.png
tags:
  - breaking change
  - release
authors:
  - nzakas
categories:
  - Release Notes
---

## Configuration Files

* Configuration files can now be written in YAML. This includes `.eslintrc` files.
* All configuration files can be in either JSON or YAML format, no special indicator of the format is necessary

## Core

* **Breaking Change:** Changed `:after` in node selectors to be `:exit` instead
* Switch to using optionator instead of optimist for CLI input
* Split out ESLintTester into its own repository (https://github.com/eslint/eslint-tester)
* CLI used to output a single blank line when there were no errors, now it doesn't output anything in this case

## Performance

* Implementing benchmarks to help identify performance bottlenecks
* Refactoring allowed a 400-700ms improvement on our benchmarks

## Rules

* **Breaking Change:** `unnecessary-strict` rule was renamed to `no-extra-strict`
* **Breaking Change:** `regex-spaces` rule was renamed to `no-regex-spaces`
* **Breaking Change:** `no-new-array` rule was renamed to `no-array-constructor`
* New Rule: valid-jsdoc (fixes [#536](https://github.com/eslint/eslint/issues/536)) (Nicholas C. Zakas)
* New Rule: func-names (fixes [#595](https://github.com/eslint/eslint/issues/595)) (Kyle Nunery)
* New Rule: no-extra-boolean-cast (fixes [#557](https://github.com/eslint/eslint/issues/557)) (Brandon Mills)
* New Rule: no-sparse-arrays (fixes [#499](https://github.com/eslint/eslint/issues/499)) (Nicholas C. Zakas)
* New Rule: no-process-exit (fixes [#568](https://github.com/eslint/eslint/issues/568)) (Nicholas C. Zakas)
* New Rule: no-labels (fixes [#550](https://github.com/eslint/eslint/issues/550)) (Nicholas C. Zakas)
* New Rule: no-lone-blocks (fixes [#512](https://github.com/eslint/eslint/issues/512)) (Brandon Mills)
* New Rule: no-path-concat (fixes [#540](https://github.com/eslint/eslint/issues/540)) (Nicholas C. Zakas)
* New Rule: no-yoda (fixes [#504](https://github.com/eslint/eslint/issues/504)) (Nicholas C. Zakas)
* New Rule: consistent-return (fixes [#481](https://github.com/eslint/eslint/issues/481)) (Nicholas C. Zakas)
* There was a bug in `no-unused-vars` that would incorrectly flag unused parameters in the case of nested functions - this was fixed
* There was a bug in `no-cond-assign` that could result in an error being thrown - this was fixed
* All rules now have documentation and build will fail if a rule is added without documentation

## Other

* Created [Yeoman generator](https://github.com/eslint/generator-eslint) to help create new rules

## Breaking Changes

The complete list of breaking changes are as follows:

* `unnecessary-strict` rule was renamed to `no-extra-strict`
* `regex-spaces` rule was renamed to `no-regex-spaces`
* `no-new-array` rule was renamed to `no-array-constructor`
* Changed `:after` in node selectors to be `:exit` instead

## Complete Changelog

The following is the complete list of changes in this version:

* Change: Switch :after to :exit (fixes [#605](https://github.com/eslint/eslint/issues/605)) (Nicholas C. Zakas)
* Fix: Make sure no-unused-vars doesn't get confused by nested functions (fixes [#584](https://github.com/eslint/eslint/issues/584)) (Nicholas C. Zakas)
* Update: .eslintrc to check more things (Nicholas C. Zakas)
* Fix: Make sure JSDoc parser accepts JSDoc3-style optional parameters (Nicholas C. Zakas)
* Docs: Update documentation with linking instructions for ESLintTester (Nicholas C. Zakas)
* New Rule: valid-jsdoc (fixes [#536](https://github.com/eslint/eslint/issues/536)) (Nicholas C. Zakas)
* [#595](https://github.com/eslint/eslint/issues/595) improved func-names documentation (Kyle Nunery)
* [#595](https://github.com/eslint/eslint/issues/595) added more func-names tests (Kyle Nunery)
* [#595](https://github.com/eslint/eslint/issues/595) fix rule message and add more tests (Kyle Nunery)
* use optionator for option parsing, not optimist (George Zahariev)
* Include instructions for working with ESLintTester (Nicholas C. Zakas)
* [#595](https://github.com/eslint/eslint/issues/595) remove needless 'function Foo() {}' in tests (Kyle Nunery)
* [#595](https://github.com/eslint/eslint/issues/595) fix whitespace (Kyle Nunery)
* [#595](https://github.com/eslint/eslint/issues/595) fix markdown for js code blocks (Kyle Nunery)
* Adding information about Yeomen generator (Ilya Volodin)
* [#595](https://github.com/eslint/eslint/issues/595) add docs for rule func-names (Kyle Nunery)
* [#595](https://github.com/eslint/eslint/issues/595) add func-names rule (Kyle Nunery)
* migrate variables array to map (Brandon Mills)
* Perf: Move try-catch out of verify() function to allow V8 optimization (refs [#574](https://github.com/eslint/eslint/issues/574)) (Nicholas C. Zakas)
* Docs: Added instructions for running npm run profile (Nicholas C. Zakas)
* refactor variable name lookup into a separate function (Brandon Mills)
* optimize findVariable() in no-unused-vars (Brandon Mills)
* move to tests/bench (Chris Dickinson)
* add `npm run profile`. (Chris Dickinson)
* [#586](https://github.com/eslint/eslint/issues/586) refactor based on https://github.com/eslint/eslint/pull/590#discussion_r9476367 (Christian)
* [#586](https://github.com/eslint/eslint/issues/586) added no-unreachable jsdoc, documentation note on hoisting case (Christian)
* [#586](https://github.com/eslint/eslint/issues/586) add hoisting check to no-unreachable (Christian)
* readme: Remove stray asterisk (Timo Tijhof)
* [#580](https://github.com/eslint/eslint/issues/580) Remove eslint.getAllComments(), related docs, related tests (Christian)
* Added test for bug fix [#582](https://github.com/eslint/eslint/issues/582). Test Passes (Shmueli Englard)
* Added curly braces to if statment (Shmueli Englard)
* Added new test for fix to [#582](https://github.com/eslint/eslint/issues/582) (fixes 582) (Shmueli Englard)
* Bug [#582](https://github.com/eslint/eslint/issues/582): Added check if node.value isn't a string just exit (Shmueli Englard)
* Update Rule: implement curly options for single-statement bodies (fixes [#511](https://github.com/eslint/eslint/issues/511)) (Nicholas C. Zakas)
* New Rule: no-extra-boolean-cast (fixes [#557](https://github.com/eslint/eslint/issues/557)) (Brandon Mills)
* New Rule: no-sparse-arrays (fixes [#499](https://github.com/eslint/eslint/issues/499)) (Nicholas C. Zakas)
* Fix: no-spaced-func is now an error (Nicholas C. Zakas)
* New Rule: no-process-exit (fixes [#568](https://github.com/eslint/eslint/issues/568)) (Nicholas C. Zakas)
* New Rule: no-labels (fixes [#550](https://github.com/eslint/eslint/issues/550)) (Nicholas C. Zakas)
* New Rule: no-lone-blocks (fixes [#512](https://github.com/eslint/eslint/issues/512)) (Brandon Mills)
* Added Emacs/Flycheck integration (Nikolai Prokoschenko)
* Build: Add perf test (Nicholas C. Zakas)
* Fix: no-cond-assign shouldn't throw error when there's a for loop with an empty conditional (fixes [#53](https://github.com/eslint/eslint/issues/53)) (Nicholas C. Zakas)
* Docs: Add docs for no-regex-spaces and all doc errors now break build (closes [#562](https://github.com/eslint/eslint/issues/562)) (Nicholas C. Zakas)
* Rename: regex-spaces to no-regex-spaces (Nicholas C. Zakas)
* Docs: Add docs for no-underscore-dangle (refs [#562](https://github.com/eslint/eslint/issues/562)) (Nicholas C. Zakas)
* Docs: Add docs for no-undef-init (refs [#562](https://github.com/eslint/eslint/issues/562)) (Nicholas C. Zakas)
* Docs: Add docs for no-return-assign (refs [#562](https://github.com/eslint/eslint/issues/562)) (Nicholas C. Zakas)
* Fix: Misspelling in no-return-assign message (Nicholas C. Zakas)
* Docs: Add docs for no-new-wrappers (refs [#562](https://github.com/eslint/eslint/issues/562)) (Nicholas C. Zakas)
* Docs: Add docs for no-new-object (refs [#562](https://github.com/eslint/eslint/issues/562)) (Nicholas C. Zakas)
* Docs: Add docs for no-implied-eval (refs [#562](https://github.com/eslint/eslint/issues/562)) (Nicholas C. Zakas)
* Docs: Updated documentation for developing rules (Nicholas C. Zakas)
* Testing: Move ESLintTester to be external dependency (fixes [#480](https://github.com/eslint/eslint/issues/480)) (Nicholas C. Zakas)
* Docs: Add list of known integrations (Nicholas C. Zakas)
* Fix [#570](https://github.com/eslint/eslint/issues/570) (dmp42)
* document no-array-constructor rule (Michael Ficarra)
* fixes [#500](https://github.com/eslint/eslint/issues/500): no-array-constructor should not flag 1-argument construction (Michael Ficarra)
* fixes [#501](https://github.com/eslint/eslint/issues/501): no-array-constructor recognises CallExpression form (Michael Ficarra)
* rename no-new-array rule to no-array-constructor; ref [#501](https://github.com/eslint/eslint/issues/501) (Michael Ficarra)
* Fix: Make radix rule warn on invalid second parameter (fixes [#563](https://github.com/eslint/eslint/issues/563)) (Nicholas C. Zakas)
* Docs: Added no-floating-decimal docs (refs [#562](https://github.com/eslint/eslint/issues/562)) (Nicholas C. Zakas)
* New Rule: no-path-concat (fixes [#540](https://github.com/eslint/eslint/issues/540)) (Nicholas C. Zakas)
* Docs: Add some missing rule docs (refs [#562](https://github.com/eslint/eslint/issues/562)) (Nicholas C. Zakas)
* Fix: CLI should not output anything when there are no warnings (fixes [#558](https://github.com/eslint/eslint/issues/558)) (Nicholas C. Zakas)
* New Rule: no-yoda (fixes [#504](https://github.com/eslint/eslint/issues/504)) (Nicholas C. Zakas)
* New Rule: consistent-return (fixes [#481](https://github.com/eslint/eslint/issues/481)) (Nicholas C. Zakas)
* Rewrite configuration documentation to include information about globals (fixes [#555](https://github.com/eslint/eslint/issues/555)) (Nicholas C. Zakas)
* Allow YAML configuration files (fixes [#491](https://github.com/eslint/eslint/issues/491)) (Nicholas C. Zakas)
