---
layout: post
title: ESLint 0.3.0 released
teaser: "We just pushed ESLint 0.3.0, which is a significant release due to the number of bug fixes and significant changes included."
image: release-notes.png
tags:
  - breaking change
  - release
authors:
  - nzakas
categories:
  - Release Notes
---

## Configuration Files

* **Breaking Change:** Removed the ability to use JavaScript as a configuration file format ([more info](https://eslint.org/blog/2014/01/breaking-change-config-file))
* Added the ability to use JavaScript-style comments in configuration files.
* Added support for `.eslintignore` files
* Allow configuration files to have any extension and assume they contain JSON

## Formatters

* **Breaking Change:** Switched to using stylish format as the default for ESLint ([more info](https://eslint.org/blog/2014/01/breaking-change-formatter))
* Merged stylish formatter into the main repository
* Added the rule ID to all formatter output to more easily identify which rule is causing a warning

## Core

* Added the ability to traverse comment nodes in rules
* Ignore shebangs in JavaScript files so ESLint can validate all Node.js files

## Rules

* **Breaking Change**: `unnecessary-strict` rule was renamed to `no-extra-strict`
* `no-empty` now disallows empty `catch` blocks when a `finally` block is present
* `no-unused-vars` was incorrectly reporting function expressions weren't used when method calls were made on them - this was fixed
* `brace-style` was incorrectly reporting a violation when an `if` statement conditional spanned multiple lines - this was fixed

## Documentation

* Lots of documentation updates and fixes
* Setup [eslint.org](https://eslint.org) as the new home for documentation

## Breaking Changes

The complete list of breaking changes are as follows:

* [Removed the ability to use JavaScript as a configuration file format](https://eslint.org/blog/2014/01/breaking-change-config-file)
* [Switched to using stylish format as the default](https://eslint.org/blog/2014/01/breaking-change-formatter)
* `unnecessary-strict` rule was renamed to `no-extra-strict`

## Complete Changelog

The following is the complete list of changes in this version:

* Config: Allow comments in JSON configuration files (fixes [[#492](https://github.com/eslint/eslint/issues/492)](https://github.com/eslint/eslint/issues/492)) (Nicholas C. Zakas)
* Bug: max-len fix to report correct line number (fixes [#552](https://github.com/eslint/eslint/issues/552)) (Nicholas C. Zakas)
* Build: Use browserify to create browser-ready ESLint (fixes [#119](https://github.com/eslint/eslint/issues/119)) (Nicholas C. Zakas)
* Docs: Ensure all rules have entry on top-level rules index page (Nicholas C. Zakas)
* Docs: Add docs for no-fallthrough rule (Nicholas C. Zakas)
* Update README.md (Peter deHaan)
* Update README.md (Peter deHaan)
* Update package.json (Peter deHaan)
* Docs: Added documentation for semi rule (Nicholas C. Zakas)
* Build: Reset branch coverage target (Nicholas C. Zakas)
* Update build system to generate eslint.org during release (Nicholas C. Zakas)
* Updated setup doc (Nicholas C. Zakas)
* Fix [#525](https://github.com/eslint/eslint/issues/525) & [#528](https://github.com/eslint/eslint/issues/528) (Mangled Deutz)
* Improve no-negated-in-lhs description (David Bruant)
* Fixing typo (David Bruant)
* Update no-new.md (Tamas Fodor)
* Update no-extra-semi.md (Tamas Fodor)
* Fixing broken links in documentation (Ilya Volodin)
* Update about page (Nicholas C. Zakas)
* Site generation build step and documentation updates to support it (fixes [#478](https://github.com/eslint/eslint/issues/478)) (Nicholas C. Zakas)
* Change message for brace-style rule (fixes [#490](https://github.com/eslint/eslint/issues/490)) (Nicholas C. Zakas)
* Add question about ES6 support to FAQ (fixes [#530](https://github.com/eslint/eslint/issues/530)) (Nicholas C. Zakas)
* Set unlimited number of listeners for event emitter (fixes [#524](https://github.com/eslint/eslint/issues/524)) (Nicholas C. Zakas)
* Add support for comment events (fixes [#531](https://github.com/eslint/eslint/issues/531)) Add :after events for comments (Nicholas C. Zakas)
* Add :after events for comments (Nicholas C. Zakas)
* Allow config files to have any name (fixes [#486](https://github.com/eslint/eslint/issues/486)). (Aparajita Fishman)
* List available formatters (fixes [#533](https://github.com/eslint/eslint/issues/533)). (Aparajita Fishman)
* Add support for comment events (fixes [#531](https://github.com/eslint/eslint/issues/531)) (Nicholas C. Zakas)
* Add Stylish formatter and make it default. Fixes [#517](https://github.com/eslint/eslint/issues/517) (Sindre Sorhus)
* Fix missing code exit (Mangled Deutz)
* Added unit test for calling Config.getConfig with no arguments. (Aparajita Fishman)
* Typo (Mangled Deutz)
* Fixed docs typo (Nicholas C. Zakas)
* Mark functions as used when any method is called on them (Nicholas C. Zakas)
* Fixed: Config.getConfig is called either with a file path or with no args (fixes [#520](https://github.com/eslint/eslint/issues/520)) (Aparajita Fishman)
* Fix minor bug in no-empty rule (Nicholas C. Zakas)
* add more info for failure messages (Nicholas C. Zakas)
* Add ruleId to all formatters output (fixes [#472](https://github.com/eslint/eslint/issues/472)) (Nicholas C. Zakas)
* Remove unused code (Nicholas C. Zakas)
* Correctly handle case with both finally and catch in no-empty (Nicholas C. Zakas)
* Update documentation for no-unused-vars (Nicholas C. Zakas)
* Ensure that bound function expressions are reported as being used (fixes [#510](https://github.com/eslint/eslint/issues/510)) (Nicholas C. Zakas)
* Allow empty catch/finally blocks (fixes [#514](https://github.com/eslint/eslint/issues/514)) and update documentation (fixes [#513](https://github.com/eslint/eslint/issues/513)) (Nicholas C. Zakas)
* Updated contribution guidelines (Nicholas C. Zakas)
* Add default setting for no-cond-assign (Nicholas C. Zakas)
* Add build step to check rule consistency (Nicholas C. Zakas)
* update docs: explicit cli args are exempt from eslintignore exclusions (Michael Ficarra)
* fixes [#505](https://github.com/eslint/eslint/issues/505): no-cond-assign should ignore doubly parenthesised tests (Michael Ficarra)
* Renamed unnecessary-strict to no-extra-strict (Nicholas C. Zakas)
* Fixed missing documentation links (Nicholas C. Zakas)
* Add build task to check for missing docs and tests for rules (Nicholas C. Zakas)
* Slight reorganization of rule groups (Nicholas C. Zakas)
* Added one-var and sorted some rules (Nicholas C. Zakas)
* Updated Travis badge for new location (Nicholas C. Zakas)
* fixes [#494](https://github.com/eslint/eslint/issues/494): allow shebangs in processed JS files (Michael Ficarra)
* fixes [#496](https://github.com/eslint/eslint/issues/496): lint ignored files when explicitly specified via the CLI (Michael Ficarra)
* More tests (Ilya Volodin)
* Upgrade Istanbul (Ilya Volodin)
* fixes [#495](https://github.com/eslint/eslint/issues/495): holey arrays cause no-comma-dangle rule to throw (Michael Ficarra)
* Documentation and minor changes (Ilya Volodin)
* Adding missing package registration (Ilya Volodin)
* Adding support for .eslintignore and .jshintignore (Closes [#484](https://github.com/eslint/eslint/issues/484)) (Ilya Volodin)
* fixes [#482](https://github.com/eslint/eslint/issues/482): brace-style bug with multiline conditions (Michael Ficarra)
* Switching Travis to use ESLint (Closes [#462](https://github.com/eslint/eslint/issues/462)) (Ilya Volodin)
