/*
 * Copyright 2021 epimethix@protonmail.com
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.github.epimethix.lumicore.orm;

import com.github.epimethix.lumicore.common.orm.model.Entity;

public interface OwnedEntity<ID, U extends AbstractUser<?>> extends Entity<ID> {
	/**
	 * Column name: {@value #OWNER} for optional use
	 */
	public final static String OWNER = "owner";
	
	U getOwner();

	void setOwner(U user);
}
