---
title: 前端框架选择之我见
date: 2023-06-28 10:54:00
tag: [React, Vue]
excerpt: 虽然 Web 前端领域更新和发展得十分迅速，但是对于框架的争论仍然可以说是持续了很长的时间的一个话题，虽然主要火力都在 React 和 Vue 上🤣，作为一个开发者，到底该怎么在花样众多的现代框架和新工具中做出抉择呢？我也来说说我的看法
draft: true
---

因为掘金某 Veev 的瓜小小的引爆了前端圈子，[@cail castle](https://twitter.com/thecalicastle) 的文章也让我想说说我对这部分问题的看法。 

## TL;DR

*WIP*

## Vue 与 React 其本身的优劣

其实首先 Vue 和 React 没有绝对的优胜者，在大多数情况下两者没有显著的差异。

它们各有各的优势和不足之处，脱离实际业务场景来聊这些属于耍流氓，但我们确确实实需要简单了解下这两者的优点和缺点。

抛开相似的部分比如虚拟 DOM ，基于组件构建应用的方式等之外，在我眼中的两者的优劣有什么呢？

### React

虽然大家都知道 React 的定位是库(Library)而不是框架(Framework)，但其本身的一些约束和特性完全就是框架的样子所以大部分人都会默认是框架XD。

提到 React 的优点，我个人认为除了两者相似的部分以外的优点就是其高度的灵活性，all in JS 的思想没有额外的学习成本，只要学习 Javascript 就能上手使用 ~~当然如果不手写渲染函数使用 JSX 是需要简单了解下~~

纯粹的 JS 也同样带来了更好的 TypeScript 支持，当然有一小部分是和 M$ py交易来的但无伤大雅。虽然 Vue 满满的 TS 体验追上来了，但是我觉得应该永远达不到 React 这种顺畅的感觉。

所以扩展性也是很棒的，毕竟就是在纯粹的 JS 上增加功能，这也是 React 社区如此庞大的原因之一吧。

***

再来说缺点，在我看来 React 的许多优点都是因为其本身是纯粹的 JavaScript 带来的，灵活这本身就是 JavaScript 的形容词，但其实恰恰是这个灵活给 React 带来了一直存在的负担。很多 React 开发者都应该明白一件事：React 16 以来许多的更新都是为了弥补灵活的缺点——无法在编译阶段做更多的优化。

基于这部分原因，使用 React 就有一个很尖锐的问题，你需要接受 UX 远远优先于 DX 的开发，因为 React 完全无法做到提升开发体验所以就只能选择在用户体验上做到极致(于是出现了 ~~PHP.js~~ RSC 这样的完全用户体验优先但是大多数开发者都吐槽的东西)，但是这两者就像取消调休和双休一样不应该是互斥的选项。

### Vue
 
单独看 Vue 并没有什么亮眼的优点。响应式的变量只能算是 Vue 的特性；提供了一些额外的语法糖但可能有部分人不喜欢记忆过多 API，而且灵活性确实不如 JSX；不需要选择繁杂的实现方式，有一套官方的最佳实践，但这减少了选择；或许使用模板开发会比较适合入门算是一个。

但如果作比较的话还是有不少的优势的，比起 React 无法在编译阶段优化，模板的形式在编译阶段可以静态分析然后再做优化，比起纯粹的 re-render 会获得更好的性能而不需要开发者自己维护这部分。~~当然或许也有人觉得开手动挡更爽对此不置可否~~

***

Vue 真正的缺点的话就是没有大公司支持，而且没有像 RN 那样的跨平台实践。WIP

## 其社区和核心开发者的境遇

提到 Vue 当然不得不提那个男人，无论怎么说 Vue 实际上就是尤大单打独斗的结果，Vue 团队核心成员大多数是负责周边设施的开发和维护。

*WIP*

React 作为 Meta 开源的框架，显而易见的目的就是为了公司业务服务。

*WIP*

## 大环境的选择

基于 React 周边设施的完善，确实 React 在大多数情况下都能找到解决方案。

*WIP*
