# Offensive & Defensive Android Reverse Engineering

Training materials crafted and publicly provided by Red Naga members;
 - Jon 'jcase' Sawyer
 - Tim 'diff' Strazzere
 - Caleb 'I need something to put here' Fenton

Due to some issues with the github inline PDF viewer, we would highly suggest downloading the [PDF](https://github.com/rednaga/training/blob/master/DEFCON23/O%26D%20-%20Android%20Reverse%20Engineering.pdf) and opening it on your machine. Originally presented at the [DEFCON 23 workshops](https://www.defcon.org/html/defcon-23/dc-23-workshops-schedule.html#Strazzere)

Vulnerabilities discussed are disclosed in the [rednaga/disclosures repo](https://github.com/rednaga/disclosures), specifically;
 - ["HTC Peap" CVE-2015-5525, CVE-2015-5526 & CVE-2015-5527](https://github.com/rednaga/disclosures/blob/master/HTCPeap.md)
 - ["Qualcomm System Agent", No CVEs assigned](https://github.com/rednaga/disclosures/blob/master/QCOMSysAgent.md)

Some of the resources which where originally provided on the USB drive passed around are available in the [challenges directory](https://github.com/rednaga/training/blob/master/DEFCON23/challenges/).

### Abstract

Thinking like an attacker, you will learn to identify juicy Android targets, reverse engineer them, find vulnerabilities, and write exploits. We will deep dive into reverse engineering Android frameworks, applications, services, and boot loaders with the end goal of rooting devices.

Approaching from a defensive perspective, we will learn quickly triage applications to determine maliciousness, exploits, and weaknesses. After learning triage skills, we will deep dive into malicious code along while dealing with packers, obfuscators, and anti-reversing techniques.

Between the offensive and defensive aspects of this class, you should walk away with the fundamentals of reverse engineering and a strong understanding of how to further develop your skills for mobile platforms.

### Prerequisites
We would expect students to know minimal reverse engineering concepts. Would also be good, though not required, to have some of the following non-free tools:

 - IDA Pro
 - Hopper
 - JEB

### Licensing

<a rel="license" href="http://creativecommons.org/licenses/by-nc-sa/4.0/"><img alt="Creative Commons License" style="border-width:0" src="https://i.creativecommons.org/l/by-nc-sa/4.0/88x31.png" /></a><br />This work is licensed under a <a rel="license" href="http://creativecommons.org/licenses/by-nc-sa/4.0/">Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International License</a>.
TLDR - free for personal use, commercial use is forbidden unless you contact us and gain permission
